/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace.compiled.motions;

import edu.duke.cs.osprey.confspace.compiled.AssignedCoords;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.ContinuousMotion;
import edu.duke.cs.osprey.confspace.compiled.DegreeOfFreedom;
import edu.duke.cs.osprey.tools.Protractor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class DihedralAngle
implements ContinuousMotion {
    public final Description desc;
    public final AssignedCoords coords;
    public final int moli;
    public final int posi;
    public final int ai;
    public final int bi;
    public final int ci;
    public final int di;
    public final int[] ri;
    public final double initialAngleRadians;
    public final double minAngleRadians;
    public final double maxAngleRadians;
    public final Dof dof;

    public DihedralAngle(Description desc, AssignedCoords coords, int moli, int posi) {
        this.desc = desc;
        this.coords = coords;
        this.moli = moli;
        this.posi = posi;
        this.ai = this.getAtomIndex(desc.a);
        this.bi = this.getAtomIndex(desc.b);
        this.ci = this.getAtomIndex(desc.c);
        this.di = this.getAtomIndex(desc.d);
        this.ri = new int[desc.rotated.length];
        for (int i = 0; i < this.ri.length; ++i) {
            this.ri[i] = this.getAtomIndex(desc.rotated[i]);
        }
        this.initialAngleRadians = this.measureAngleRadians();
        this.minAngleRadians = Math.toRadians(desc.minDegrees);
        this.maxAngleRadians = Math.toRadians(desc.maxDegrees);
        this.dof = new Dof();
    }

    private String getName() {
        if (this.posi == -1) {
            return this.coords.confSpace.molInfos[this.moli].name;
        }
        return this.coords.confSpace.name(this.posi);
    }

    private int getAtomIndex(int atomi) {
        return this.desc.getAtomIndex(this.coords.confSpace, this.posi, atomi);
    }

    private String getAtomName(int atomi) {
        if (this.posi == -1) {
            return this.coords.confSpace.staticNames[atomi];
        }
        if (atomi >= 0) {
            return this.coords.confSpace.positions[this.posi].confs[this.coords.assignments[this.posi]].atomNames[atomi];
        }
        return this.coords.confSpace.staticNames[-atomi - 1];
    }

    public double measureAngleRadians() {
        Vector3d a = new Vector3d();
        Vector3d b = new Vector3d();
        Vector3d c = new Vector3d();
        Vector3d d = new Vector3d();
        this.coords.coords.get(this.ai, a);
        this.coords.coords.get(this.bi, b);
        this.coords.coords.get(this.ci, c);
        this.coords.coords.get(this.di, d);
        return DihedralAngle.measureAngleRadians(a, b, c, d);
    }

    public double measureAngleDegrees() {
        return Math.toDegrees(this.measureAngleRadians());
    }

    public void setAngle(double angleRadians) {
        Vector3d temp = new Vector3d();
        Quaterniond qIn = new Quaterniond();
        Quaterniond qZ = new Quaterniond();
        Quaterniond qOut = new Quaterniond();
        Vector3d a = new Vector3d();
        Vector3d b = new Vector3d();
        Vector3d c = new Vector3d();
        Vector3d d = new Vector3d();
        this.coords.coords.get(this.ai, a);
        this.coords.coords.get(this.bi, b);
        this.coords.coords.get(this.ci, c);
        this.coords.coords.get(this.di, d);
        a.sub((Vector3dc)b);
        c.sub((Vector3dc)b);
        d.sub((Vector3dc)b);
        qIn.lookAlong((Vector3dc)c, (Vector3dc)a);
        d.rotate((Quaterniondc)qIn);
        qZ.rotationZ(1.5707963267948966 - angleRadians - Math.atan2(d.y, d.x));
        qOut.set((Quaterniondc)qIn).conjugate();
        for (int i : this.ri) {
            this.coords.coords.get(i, temp);
            temp.sub((Vector3dc)b);
            temp.rotate((Quaterniondc)qIn);
            temp.rotate((Quaterniondc)qZ);
            temp.rotate((Quaterniondc)qOut);
            temp.add((Vector3dc)b);
            this.coords.coords.set(i, (Vector3dc)temp);
        }
    }

    private static double measureAngleRadians(Vector3d a, Vector3d b, Vector3d c, Vector3d d) {
        a.sub((Vector3dc)b);
        c.sub((Vector3dc)b);
        d.sub((Vector3dc)b);
        Quaterniond q = new Quaterniond().lookAlong((Vector3dc)c, (Vector3dc)a);
        d.rotate((Quaterniondc)q);
        return Protractor.normalizeMinusPiToPi(1.5707963267948966 - Math.atan2(d.y, d.x));
    }

    @Override
    public void appendDofs(List<DegreeOfFreedom> dofs) {
        dofs.add(this.dof);
    }

    public static class Description
    implements ContinuousMotion.ConfDescription,
    ContinuousMotion.MolDescription {
        public final double minDegrees;
        public final double maxDegrees;
        public final int a;
        public final int b;
        public final int c;
        public final int d;
        public final int[] rotated;

        public Description(double minDegrees, double maxDegrees, int a, int b, int c, int d, int[] rotated) {
            this.minDegrees = minDegrees;
            this.maxDegrees = maxDegrees;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.rotated = rotated;
        }

        @Override
        public ContinuousMotion build(AssignedCoords conf, ConfSpace.Pos pos) {
            return new DihedralAngle(this, conf, 0, pos.index);
        }

        @Override
        public ContinuousMotion build(AssignedCoords conf, int molInfoIndex) {
            return new DihedralAngle(this, conf, molInfoIndex, -1);
        }

        @Override
        public int maxNumDofs() {
            return 1;
        }

        public int getAtomIndex(ConfSpace confSpace, int posi, int atomi) {
            if (posi == -1) {
                return confSpace.getStaticAtomIndex(atomi);
            }
            if (atomi >= 0) {
                return confSpace.getConfAtomIndex(posi, atomi);
            }
            return confSpace.getStaticAtomIndex(-atomi - 1);
        }
    }

    public class Dof
    implements DegreeOfFreedom {
        public final DihedralAngle dihedral;
        private double angleRadians;
        private final Set<Integer> modifiedPosIndices;

        public Dof() {
            this.dihedral = DihedralAngle.this;
            this.angleRadians = DihedralAngle.this.initialAngleRadians;
            this.modifiedPosIndices = new HashSet<Integer>();
            this.modifiedPosIndices.add(DihedralAngle.this.posi);
        }

        @Override
        public String name() {
            return String.format("dihedral angle @ %s: %s-%s-%s-%s", DihedralAngle.this.getName(), DihedralAngle.this.getAtomName(DihedralAngle.this.desc.a), DihedralAngle.this.getAtomName(DihedralAngle.this.desc.b), DihedralAngle.this.getAtomName(DihedralAngle.this.desc.c), DihedralAngle.this.getAtomName(DihedralAngle.this.desc.d));
        }

        @Override
        public double min() {
            return DihedralAngle.this.minAngleRadians;
        }

        @Override
        public double max() {
            return DihedralAngle.this.maxAngleRadians;
        }

        @Override
        public double get() {
            return this.angleRadians;
        }

        @Override
        public void set(double val) {
            if (val != this.angleRadians) {
                this.dihedral.setAngle(val);
                this.angleRadians = val;
            }
        }

        @Override
        public Set<Integer> modifiedPosIndices() {
            return this.modifiedPosIndices;
        }

        @Override
        public double initialStepSize() {
            return 0.004363323;
        }
    }
}

