/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.control;

import edu.duke.cs.osprey.astar.GMECMutSpace;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.control.ParamSet;
import edu.duke.cs.osprey.dof.deeper.DEEPerSettings;
import edu.duke.cs.osprey.dof.deeper.RamachandranChecker;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.energy.EnergyFunctionGenerator;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.pruning.PruningControl;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.tools.StringParsing;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class ConfigFileParser {
    public final ParamSet params;

    public static ConfigFileParser makeFromFilePaths(String ... paths) {
        return ConfigFileParser.makeFromFilePaths(Arrays.asList(paths));
    }

    public static ConfigFileParser makeFromFilePaths(Iterable<String> paths) {
        ConfigFileParser cfp = new ConfigFileParser();
        for (String path2 : paths) {
            cfp.params.addParamsFromFile(new File(path2));
        }
        return cfp;
    }

    public static ConfigFileParser makeFromFiles(Iterable<File> files) {
        ConfigFileParser cfp = new ConfigFileParser();
        for (File file : files) {
            cfp.params.addParamsFromFile(file);
        }
        return cfp;
    }

    public ConfigFileParser() {
        this.params = new ParamSet();
    }

    public ConfigFileParser(ConfigFileParser other) {
        this.params = new ParamSet(other.params);
    }

    protected DEEPerSettings setupDEEPer() {
        DEEPerSettings dset = new DEEPerSettings(this.params.getBool("doPerturbations"), this.params.getRunSpecificFileName("perturbationFile", ".pert"), this.params.getBool("selectPerturbations"), this.params.getValue("startingPerturbationFile"), this.params.getBool("onlyStartingPerturbations"), this.params.getDouble("maxShearParam"), this.params.getDouble("maxBackrubParam"), this.params.getBool("selectLCAs"), this.getFlexRes(), this.params.getValue("PDBNAME"), this.params.getBool("DORAMACHECK"), EnvironmentVars.resTemplates);
        dset.loadPertFile(null);
        return dset;
    }

    private ArrayList<String[]> freeBBZoneTermini() {
        ArrayList<String[]> ans = new ArrayList<String[]>();
        for (String rt : this.params.searchParams("BBFREEBLOCK")) {
            String strandLimitsString = this.params.getValue(rt);
            String[] termini = new String[]{StringParsing.getToken(strandLimitsString, 1), StringParsing.getToken(strandLimitsString, 2)};
            ans.add(termini);
        }
        return ans;
    }

    private ArrayList<String[]> moveableStrandTermini() {
        ArrayList<String[]> ans = new ArrayList<String[]>();
        for (String rt : this.params.searchParams("STRANDROTTRANS")) {
            if (!this.params.getBool(rt)) continue;
            String strandNum = rt.substring(14);
            String strandLimitsString = this.params.getValue("STRAND" + strandNum);
            String[] termini = new String[]{StringParsing.getToken(strandLimitsString, 1), StringParsing.getToken(strandLimitsString, 2)};
            ans.add(termini);
        }
        return ans;
    }

    public SearchProblem getSearchProblem() {
        String name = this.params.getValue("RUNNAME");
        ArrayList<String> flexRes = this.getFlexRes();
        ArrayList<ArrayList<String>> allowedAAs = this.getAllowedAAs();
        if (flexRes.size() != allowedAAs.size()) {
            throw new RuntimeException("ERROR: Number of flexible positions different in flexible residue and allowed AA type parameters!");
        }
        System.out.println("CREATING SEARCH PROBLEM.  NAME: " + name);
        ArrayList<String[]> moveableStrands = this.moveableStrandTermini();
        ArrayList<String[]> freeBBZones = this.freeBBZoneTermini();
        DEEPerSettings dset = this.setupDEEPer();
        SearchProblem search2 = new SearchProblem(name, this.params.getFile("PDBNAME").getAbsolutePath(), flexRes, allowedAAs, this.params.getBool("AddWT"), this.params.getBool("doMinimize"), this.params.getBool("UseEPIC"), new EPICSettings(this.params), this.params.getBool("UseTupExp"), new LUTESettings(this.params), dset, moveableStrands, freeBBZones, this.params.getBool("useEllipses"), this.params.getBool("useERef"), this.params.getBool("AddResEntropy"), this.params.getBool("addWTRots"), null, this.params.getBool("useVoxelG"), this.getWtRotOnlyRes());
        search2.numEmatThreads = this.params.getInt("EmatThreads");
        return search2;
    }

    public ArrayList<String> getFlexRes() {
        ArrayList<String> flexResList = new ArrayList<String>();
        int numStrands = this.params.searchParams("STRANDMUT").size() - this.params.searchParams("STRANDMUTNUMS").size();
        for (int smNum = 0; smNum < numStrands; ++smNum) {
            String param = "STRANDMUT" + smNum;
            String resListString = this.params.getValue(param);
            StringTokenizer tokenizer = new StringTokenizer(resListString);
            while (tokenizer.hasMoreTokens()) {
                flexResList.add(tokenizer.nextToken());
            }
        }
        return flexResList;
    }

    protected ArrayList<String> getWtRotOnlyRes() {
        ArrayList<String> wtRotOnlyRes = new ArrayList<String>();
        String val = this.params.getValue("WTRotOnlyRes");
        StringTokenizer tokenizer = new StringTokenizer(val);
        while (tokenizer.hasMoreTokens()) {
            wtRotOnlyRes.add(tokenizer.nextToken());
        }
        return wtRotOnlyRes;
    }

    public ArrayList<ArrayList<String>> getAllowedAAs() {
        ArrayList<String> resAllowedRecords = this.params.searchParams("RESALLOWED");
        if (resAllowedRecords.isEmpty()) {
            return new ArrayList<ArrayList<String>>();
        }
        boolean usingStrandFormat = resAllowedRecords.get(0).contains("_");
        for (int rec = 1; rec < resAllowedRecords.size(); ++rec) {
            if (usingStrandFormat == resAllowedRecords.get(rec).contains("_")) continue;
            throw new RuntimeException("ERROR: Inconsistent formatting of resAllowed records (should be all by PDB residue number or all by strand)");
        }
        if (usingStrandFormat) {
            return this.getAllowedAAsByStrand();
        }
        return this.getAllowedAAsByPDBResNum();
    }

    ArrayList<ArrayList<String>> getAllowedAAsByStrand() {
        ArrayList<ArrayList<String>> allowedAAs = new ArrayList<ArrayList<String>>();
        int str = 0;
        while (true) {
            ArrayList<String> resAllowedRecords = this.params.searchParams("RESALLOWED" + str);
            int numRecordsInStrand = resAllowedRecords.size();
            for (int recNum = 0; recNum < numRecordsInStrand; ++recNum) {
                String param = "RESALLOWED" + str + "_" + recNum;
                String allowedAAString = this.params.getValue(param);
                ArrayList<String> resAllowedAAs = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer(allowedAAString);
                while (tokenizer.hasMoreTokens()) {
                    resAllowedAAs.add(tokenizer.nextToken().toUpperCase());
                }
                allowedAAs.add(resAllowedAAs);
            }
            if (numRecordsInStrand == 0) break;
            ++str;
        }
        return allowedAAs;
    }

    ArrayList<ArrayList<String>> getAllowedAAsByPDBResNum() {
        ArrayList<ArrayList<String>> allowedAAs = new ArrayList<ArrayList<String>>();
        ArrayList<String> flexRes = this.getFlexRes();
        for (int flexResNum = 0; flexResNum < flexRes.size(); ++flexResNum) {
            String param = "RESALLOWED" + flexRes.get(flexResNum);
            String allowedAAString = this.params.getValue(param);
            ArrayList<String> resAllowedAAs = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(allowedAAString);
            while (tokenizer.hasMoreTokens()) {
                resAllowedAAs.add(tokenizer.nextToken().toUpperCase());
            }
            allowedAAs.add(resAllowedAAs);
        }
        return allowedAAs;
    }

    public PruningControl setupPruning(SearchProblem searchSpace, double pruningInterval, boolean useEPIC, boolean useTupExp) {
        boolean initPruneMat = false;
        if (searchSpace.pruneMat == null) {
            initPruneMat = true;
        } else if (searchSpace.pruneMat.getPruningInterval() < pruningInterval) {
            initPruneMat = true;
        }
        if (initPruneMat) {
            searchSpace.pruneMat = new PruningMatrix(searchSpace.confSpace, pruningInterval);
        }
        return new PruningControl(searchSpace, pruningInterval, this.params.getBool("TYPEDEP"), this.params.getDouble("BOUNDSTHRESH"), this.params.getInt("ALGOPTION"), this.params.getBool("USEFLAGS"), this.params.getBool("USETRIPLES"), false, useEPIC, useTupExp, this.params.getDouble("STERICTHRESH"));
    }

    @Deprecated
    public void loadData() {
        ForcefieldParams.Forcefield ff = ForcefieldParams.Forcefield.get(this.params.getValue("Forcefield"));
        ForcefieldParams ffparams = new ForcefieldParams(ff);
        ffparams.distDepDielect = this.params.getBool("DISTDEPDIELECT");
        ffparams.dielectric = this.params.getDouble("DIELECTCONST");
        ffparams.vdwMultiplier = this.params.getDouble("VDWMULT");
        ffparams.solvScale = this.params.getDouble("SOLVSCALE");
        ffparams.hElect = this.params.getBool("HELECT");
        ffparams.hVDW = this.params.getBool("HVDW");
        ffparams.shellDistCutoff = this.params.getDouble("SHELLDISTCUTOFF");
        ffparams.solvationForcefield = this.params.getBool("USEPOISSONBOLTZMANN") ? ForcefieldParams.SolvationForcefield.PoissonBoltzmann : (this.params.getBool("DOSOLVATIONE") ? ForcefieldParams.SolvationForcefield.EEF1 : null);
        EnvironmentVars.curEFcnGenerator = new EnergyFunctionGenerator(ffparams);
        ResidueTemplateLibrary.Builder templateLibBuilder = new ResidueTemplateLibrary.Builder(ff).clearRotamers().addRotamers(this.params.readPath("ROTFILE")).clearResidueEntropies().addResidueEntropies(this.params.readPath("RESENTROPYFILE"));
        if (this.params.getBool("UseDunbrackRotamers")) {
            templateLibBuilder.addBackboneDependentRotamers(this.params.readPath("DUNBRACKROTFILE"));
        }
        for (String grotFile : this.params.searchParams("GROTFILE")) {
            templateLibBuilder.addRotamers(this.params.readPath(grotFile));
        }
        EnvironmentVars.resTemplates = templateLibBuilder.build();
        if (!this.params.getValue("RAMAGLYFILE").equalsIgnoreCase("none")) {
            RamachandranChecker.getInstance().readInputFiles(this.params.readPath("RAMAGLYFILE"), this.params.readPath("RAMAPROFILE"), this.params.readPath("RAMAGENFILE"), this.params.readPath("RAMAPREPROFILE"));
        }
        EnvironmentVars.alwaysIdealizeSidechainsAfterMutation = this.params.getBool("ALWAYSIDEALIZESIDECHAINSAFTERMUTATION");
    }

    public boolean hasGMECMutFile() {
        return !this.params.getValue("GMECMutFile", "None").equalsIgnoreCase("None");
    }

    public GMECMutSpace parseGMECMutFile(ConfSpace confSpace) {
        String mutFileName = this.params.getValue("GMECMutFile", "None");
        if (mutFileName.equalsIgnoreCase("None")) {
            return null;
        }
        return new GMECMutSpace(mutFileName, confSpace);
    }
}

