/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.control;

import edu.duke.cs.osprey.handlempi.MPIMaster;
import edu.duke.cs.osprey.tools.FileTools;
import edu.duke.cs.osprey.tools.StringParsing;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ParamSet
implements Serializable {
    private static final long serialVersionUID = 4364963601242324780L;
    private Map<String, Entry> params;
    private Map<String, Entry> defaultParams;
    private Map<String, Entry> wildcardDefaults;
    private boolean isVerbose;

    public ParamSet() {
        this.params = new HashMap<String, Entry>();
        this.defaultParams = new HashMap<String, Entry>();
        this.wildcardDefaults = new HashMap<String, Entry>();
        this.isVerbose = true;
        FileTools.ResourcePathRoot configRoot = new FileTools.ResourcePathRoot("/config");
        ParamSet.loadParams(configRoot, "defaults.cfg", this.defaultParams);
        for (String param : this.defaultParams.keySet()) {
            if (!param.endsWith("*")) continue;
            String wildcard = param.substring(0, param.length() - 1);
            this.wildcardDefaults.put(wildcard, this.defaultParams.get(param));
        }
    }

    public ParamSet(ParamSet other) {
        this.params = new HashMap<String, Entry>(other.params);
        this.defaultParams = new HashMap<String, Entry>(other.defaultParams);
        this.wildcardDefaults = new HashMap<String, Entry>(other.wildcardDefaults);
    }

    public void setVerbosity(boolean val) {
        this.isVerbose = val;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public void addParamsFromFile(String path2) {
        this.addParamsFromFile(new File(path2));
    }

    public void addParamsFromFile(File file) {
        FileTools.FilePathRoot root = new FileTools.FilePathRoot(file.getAbsoluteFile().getParentFile());
        file = root.makeRelative(file);
        this.addParams(root, file.getPath());
    }

    public void addParamsFromResource(String path2) {
        FileTools.ResourcePathRoot root = FileTools.ResourcePathRoot.parentOf(path2);
        path2 = root.makeRelative(path2);
        this.addParams(root, path2);
    }

    public void addParams(FileTools.PathRoot root, String path2) {
        ParamSet.loadParams(root, path2, this.params);
    }

    private static void loadParams(FileTools.PathRoot root, String path2, Map<String, Entry> paramMap) {
        String text = root.read(path2);
        for (String line : FileTools.parseLines(text)) {
            int commentStartPos = line.indexOf(37);
            if (commentStartPos >= 0) {
                line = line.substring(0, commentStartPos);
            }
            if (line.isEmpty()) continue;
            String paramName = StringParsing.getToken(line, 1).trim();
            if (paramMap.containsKey(paramName = paramName.toUpperCase())) {
                throw new RuntimeException("parameter " + paramName + " already read");
            }
            String paramVal = line.substring(paramName.length() + 1);
            paramMap.put(paramName, new Entry(paramVal, root));
        }
    }

    public void setValue(String paramName, String newValue) {
        this.setValue(paramName, newValue, null);
    }

    public void setValue(String paramName, String newValue, FileTools.PathRoot root) {
        paramName = paramName.toUpperCase();
        this.params.put(paramName, new Entry(newValue, root));
    }

    public String getValue(String paramName) {
        Entry entry = this.params.get(paramName = paramName.toUpperCase());
        if (entry == null) {
            entry = this.defaultParams.get(paramName);
            if (entry == null) {
                entry = this.findWildcard(paramName);
            }
            if (entry == null) {
                throw new RuntimeException("ERROR: Parameter " + paramName + " not found");
            }
            if (this.isVerbose) {
                MPIMaster.printIfMaster("Parameter " + paramName + " not set. Using default value " + entry.value);
            }
        } else if (this.isVerbose) {
            MPIMaster.printIfMaster("Parameter " + paramName + " set to " + entry.value);
        }
        return entry.value.trim();
    }

    private Entry findWildcard(String paramName) {
        for (String wildcard : this.wildcardDefaults.keySet()) {
            if (!paramName.startsWith(wildcard)) continue;
            return this.wildcardDefaults.get(wildcard);
        }
        return null;
    }

    public FileTools.PathRoot getRoot(String paramName) {
        Entry entry = this.params.get(paramName = paramName.toUpperCase());
        if (entry == null) {
            entry = this.defaultParams.get(paramName);
        }
        if (entry == null) {
            entry = this.findWildcard(paramName);
        }
        if (entry != null) {
            return entry.root;
        }
        return null;
    }

    public int getInt(String paramName) {
        String val = this.getValue(paramName);
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: Value " + val + " for parameter " + paramName + " can't be parsed as an integer");
        }
    }

    public boolean getBool(String paramName) {
        String val = this.getValue(paramName);
        try {
            return Boolean.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: Value " + val + " for parameter " + paramName + " can't be parsed as a boolean");
        }
    }

    public double getDouble(String paramName) {
        String val = this.getValue(paramName);
        try {
            return Double.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: Value " + val + " for parameter " + paramName + " can't be parsed as a double");
        }
    }

    public String getRunSpecificFileName(String paramName, String suffix) {
        if (this.params.containsKey(paramName = paramName.toUpperCase())) {
            return this.params.get((Object)paramName).value;
        }
        return this.getValue("RUNNAME") + suffix;
    }

    public ArrayList<String> searchParams(String searchTerm) {
        searchTerm = searchTerm.toUpperCase();
        ArrayList<String> matches = new ArrayList<String>();
        for (String paramName : this.params.keySet()) {
            if (!paramName.contains(searchTerm)) continue;
            matches.add(paramName);
        }
        return matches;
    }

    public String getValue(String paramName, String defaultVal) {
        String val;
        Entry entry = this.params.get(paramName = paramName.toUpperCase());
        if (entry == null) {
            if (defaultVal == null) {
                throw new RuntimeException("ERROR: Parameter " + paramName + " not found");
            }
            val = defaultVal;
            if (this.isVerbose) {
                MPIMaster.printIfMaster("Parameter " + paramName + " not set. Using default value " + val);
            }
        } else {
            val = entry.value;
            if (this.isVerbose) {
                MPIMaster.printIfMaster("Parameter " + paramName + " set to " + val);
            }
        }
        return val.trim();
    }

    public int getInt(String paramName, int defaultVal) {
        String val = this.getValue(paramName, String.valueOf(defaultVal));
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: Value " + val + " for parameter " + paramName + " can't be parsed as an integer");
        }
    }

    public boolean getBool(String paramName, boolean defaultVal) {
        String val = this.getValue(paramName, String.valueOf(defaultVal));
        try {
            return Boolean.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: Value " + val + " for parameter " + paramName + " can't be parsed as a boolean");
        }
    }

    public double getDouble(String paramName, double defaultVal) {
        String val = this.getValue(paramName, String.valueOf(defaultVal));
        try {
            return Double.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: Value " + val + " for parameter " + paramName + " can't be parsed as a double");
        }
    }

    public File getFile(String paramName) {
        String path2 = this.getValue(paramName);
        FileTools.PathRoot root = this.getRoot(paramName);
        if (root instanceof FileTools.FilePathRoot) {
            return ((FileTools.FilePathRoot)root).resolve(new File(path2));
        }
        throw new Error("param " + paramName + " was loaded from a resource, so it can't reference files");
    }

    public String readPath(String paramName) {
        String path2 = this.getValue(paramName);
        FileTools.PathRoot root = this.getRoot(paramName);
        return root.read(path2);
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = 521766449139228629L;
        public final String value;
        public final FileTools.PathRoot root;

        public Entry(String value2, FileTools.PathRoot root) {
            this.value = value2;
            this.root = root;
        }
    }
}

