/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.analysis;

import ch.obermuhlner.math.big.DefaultBigDecimalMath;
import edu.duke.cs.osprey.Constants;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.design.analysis.CommandAnalysis;
import edu.duke.cs.osprey.design.analysis.ProbabilityEnergyTuple;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.tools.BigMath;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class ThermodynamicsConfListener
implements CommandAnalysis {
    private List<ConfSearch.EnergiedConf> confs = new ArrayList<ConfSearch.EnergiedConf>();
    private BigDecimal pFuncLowerBound;
    private BigDecimal pFuncUpperBound;
    private static BoltzmannCalculator bCalc = new BoltzmannCalculator(PartitionFunction.decimalPrecision);

    @Override
    public void onConf(ConfSearch.ScoredConf conf) {
        this.confs.add((ConfSearch.EnergiedConf)conf);
    }

    private static BigMath makeBigMath() {
        return new BigMath(PartitionFunction.decimalPrecision);
    }

    private static BigDecimal getBoundedProbability(ConfSearch.EnergiedConf conf, BigDecimal bound) {
        return bCalc.calc(conf.getEnergy()).divide(bound, RoundingMode.HALF_EVEN);
    }

    private ProbabilityEnergyTuple getConfProperties(ConfSearch.EnergiedConf conf) {
        return new ProbabilityEnergyTuple(conf, this.getLowerBoundProbability(conf), this.getUpperBoundProbability(conf), BigDecimal.valueOf(conf.getEnergy()));
    }

    private Stream<ProbabilityEnergyTuple> confPropStream() {
        return ((Stream)this.confs.stream().parallel()).map(this::getConfProperties);
    }

    private BigDecimal getUpperBoundProbability(ConfSearch.EnergiedConf conf) {
        return ThermodynamicsConfListener.getBoundedProbability(conf, this.pFuncLowerBound);
    }

    private BigDecimal getLowerBoundProbability(ConfSearch.EnergiedConf conf) {
        return ThermodynamicsConfListener.getBoundedProbability(conf, this.pFuncUpperBound);
    }

    private BigDecimal getUpperBoundEnthalpy() {
        return this.confPropStream().map(props -> props.lowerBoundProbability().multiply(props.energy())).reduce(BigDecimal::add).orElseThrow();
    }

    private BigDecimal getLowerBoundEnthalpy() {
        BigDecimal part1 = this.confPropStream().map(prop -> prop.upperBoundProbability().multiply(prop.energy())).reduce(BigDecimal::add).orElseThrow();
        BigDecimal upperBoundProbabilitySum = this.confPropStream().map(ProbabilityEnergyTuple::upperBoundProbability).reduce(BigDecimal::add).orElseThrow();
        BigDecimal part2 = BigDecimal.ONE.subtract(upperBoundProbabilitySum).multiply(this.confPropStream().reduce((first, second) -> second).orElseThrow().energy());
        return part1.add(part2);
    }

    private BigDecimal getUpperBoundEntropy() {
        return ThermodynamicsConfListener.makeBigMath().set(Constants.R).mult(DefaultBigDecimalMath.log((BigDecimal)this.pFuncUpperBound)).add(this.getUpperBoundEnthalpy().doubleValue() / Constants.T).get();
    }

    private BigDecimal getLowerBoundEntropy() {
        return ThermodynamicsConfListener.makeBigMath().set(Constants.R).mult(DefaultBigDecimalMath.log((BigDecimal)this.pFuncLowerBound)).add(this.getLowerBoundEnthalpy().doubleValue() / Constants.T).get();
    }

    @Override
    public void printResults() {
        System.out.println(String.format("Enthalpy[%.04f - %.04f]", this.getLowerBoundEnthalpy(), this.getUpperBoundEnthalpy()));
        System.out.println(String.format("Entropy[%.04f - %.04f]", this.getLowerBoundEntropy(), this.getUpperBoundEntropy()));
    }
}

