/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.design.commands.DelegatingCommand;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.ematrix.compiled.EmatCalculator;
import edu.duke.cs.osprey.ematrix.compiled.ErefCalculator;
import edu.duke.cs.osprey.energy.compiled.CPUConfEnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.ConfEnergyCalculatorAdapter;
import edu.duke.cs.osprey.kstar.KStar;
import edu.duke.cs.osprey.kstar.KStarSettings;
import edu.duke.cs.osprey.kstar.ScoredSequence;
import edu.duke.cs.osprey.kstar.SequenceAnalyzer;
import edu.duke.cs.osprey.kstar.pfunc.GradientDescentPfunc;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.FileTools;
import java.io.File;
import java.util.List;

@Parameters(commandDescription="Run K* using compiled conformation spaces.")
public class CommandKStar
extends DelegatingCommand {
    public static final String CommandName = "kstar";
    public static final String CommandDescription = "Run K* using compiled conformation spaces.";
    @Parameter(names={"--complex-confspace"}, description="Path to the compiled complex conformation space file.", required=true)
    private String complexConfSpacePath;
    @Parameter(names={"--design-confspace"}, description="Path to the compiled design conformation space file.", required=true)
    private String designConfSpacePath;
    @Parameter(names={"--target-confspace"}, description="Path to the compiled target conformation space file.", required=true)
    private String targetConfSpacePath;
    @Parameter(names={"--stability-threshold"}, description="Pruning criteria to remove sequences with unstable unbound states relative to the wild type sequence. Set to a negative number to disable.")
    public double stabilityThreshold = 5.0;

    @Override
    public int run(JCommander commander, String[] args) {
        this.cleanupStuffFromPreviousRuns();
        long start = System.currentTimeMillis();
        ConfSpace complex = ConfSpace.fromBytes(FileTools.readFileBytes(this.complexConfSpacePath));
        ConfSpace design = ConfSpace.fromBytes(FileTools.readFileBytes(this.designConfSpacePath));
        ConfSpace target = ConfSpace.fromBytes(FileTools.readFileBytes(this.targetConfSpacePath));
        Parallelism parallelism = this.delegate.getParallelism();
        TaskExecutor taskExecutor = parallelism.makeTaskExecutor();
        KStarSettings settings = new KStarSettings.Builder().setStabilityThreshold(this.stabilityThreshold).setMaxNumConf(this.delegate.maxConfs).build();
        KStar kstar = new KStar(target, design, complex, settings);
        for (KStar.ConfSpaceInfo confSpaceInfo : kstar.confSpaceInfos()) {
            CPUConfEnergyCalculator energyCalculator = new CPUConfEnergyCalculator((ConfSpace)confSpaceInfo.confSpace);
            SimpleReferenceEnergies referenceEnergies = new ErefCalculator.Builder(energyCalculator).build().calc(taskExecutor);
            EnergyMatrix energyMatrix = new EmatCalculator.Builder(energyCalculator).setReferenceEnergies(referenceEnergies).build().calc(taskExecutor);
            confSpaceInfo.confEcalc = new ConfEnergyCalculatorAdapter.Builder(energyCalculator, taskExecutor).setReferenceEnergies(referenceEnergies).build();
            confSpaceInfo.pfuncFactory = rcs -> new GradientDescentPfunc(confSpaceInfo.confEcalc, new ConfAStarTree.Builder(energyMatrix, rcs).setTraditional().build(), new ConfAStarTree.Builder(energyMatrix, rcs).setTraditional().build(), rcs.getNumConformations());
        }
        List<ScoredSequence> sequences = kstar.run(taskExecutor);
        SequenceAnalyzer analyzer = new SequenceAnalyzer(kstar);
        for (ScoredSequence sequence : sequences) {
            System.out.println("result:");
            System.out.println("\tsequence: " + String.valueOf(sequence.sequence()));
            System.out.println("\tscore: " + String.valueOf(sequence.score()));
            SequenceAnalyzer.Analysis analysis = analyzer.analyze(sequence.sequence(), this.delegate.writeNConfs);
            System.out.println(analysis);
            String seqstr = sequence.sequence().toString(Sequence.Renderer.ResTypeMutations).replace(' ', '-');
            File ensembleFile = new File(this.delegate.ensembleDir, String.format("seq.%s.pdb", seqstr));
            analysis.writePdb(ensembleFile.getAbsolutePath(), String.format("Top %d conformations for sequence %s", this.delegate.writeNConfs, sequence.sequence()));
        }
        long end = System.currentTimeMillis();
        System.out.printf("Took %f seconds%n", (double)(end - start) / 1000.0);
        return 0;
    }

    @Override
    public String getCommandName() {
        return CommandName;
    }

    @Override
    public String getCommandDescription() {
        return CommandDescription;
    }
}

