/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public abstract class DegreeOfFreedom
implements Serializable {
    private static final long serialVersionUID = 3348198591978172994L;
    double curVal;

    public abstract void apply(double var1);

    public double getCurVal() {
        return this.curVal;
    }

    public Residue getResidue() {
        return null;
    }

    public DegreeOfFreedom copy() {
        throw new UnsupportedOperationException("unsupported by " + this.getClass().getName());
    }

    public void setMolecule(Molecule val) {
        throw new UnsupportedOperationException("unsupported by " + this.getClass().getName());
    }

    public abstract DOFBlock getBlock();

    public abstract String getName();

    public static HashMap<String, Integer> nameToIndexMap(List<DegreeOfFreedom> dofs) {
        HashMap<String, Integer> ans = new HashMap<String, Integer>();
        for (int index = 0; index < dofs.size(); ++index) {
            ans.put(dofs.get(index).getName(), index);
        }
        return ans;
    }
}

