/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.Strand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DofInfo {
    public final RCTuple tuple;
    public final List<Integer> counts = new ArrayList<Integer>();
    public final List<Integer> offsets = new ArrayList<Integer>();
    public final List<Integer> ids = new ArrayList<Integer>();
    public final List<Strand> strands = new ArrayList<Strand>();
    public final List<SimpleConfSpace.Position> positions = new ArrayList<SimpleConfSpace.Position>();
    public final List<SimpleConfSpace.ResidueConf> resConfs = new ArrayList<SimpleConfSpace.ResidueConf>();
    public final Map<String, Integer> blockIndicesByResNum = new HashMap<String, Integer>();
    private int numDofs = 0;

    public DofInfo(RCTuple tuple) {
        this.tuple = tuple;
    }

    public int addStrand(Strand strand, int numDofs) {
        int blockIndex = this.counts.size();
        this.counts.add(numDofs);
        this.offsets.add(this.numDofs());
        this.ids.add(-1);
        this.strands.add(strand);
        this.positions.add(null);
        this.resConfs.add(null);
        this.numDofs += numDofs;
        return blockIndex;
    }

    public int addPos(SimpleConfSpace.Position pos, SimpleConfSpace.ResidueConf rc, int numDofs) {
        int blockIndex = this.counts.size();
        this.counts.add(numDofs);
        this.offsets.add(this.numDofs());
        this.ids.add(pos.index);
        this.strands.add(null);
        this.positions.add(pos);
        this.resConfs.add(rc);
        this.blockIndicesByResNum.put(pos.resNum, blockIndex);
        this.numDofs += numDofs;
        return blockIndex;
    }

    public int size() {
        return this.counts.size();
    }

    public int numDofs() {
        return this.numDofs;
    }

    public Integer getBlockIndex(String resNum) {
        return this.blockIndicesByResNum.get(resNum);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            buf.append(String.format("block %s:\n", i));
            buf.append(String.format("\toffset:      %d\n", this.offsets.get(i)));
            buf.append(String.format("\tcount:       %d\n", this.counts.get(i)));
            buf.append(String.format("\tstrand:      %s\n", this.strands.get(i)));
            buf.append(String.format("\tpos:         %d %s\n", this.positions.get((int)i).index, this.positions.get((int)i).resNum));
            buf.append(String.format("\trc:          %d %s %s\n", this.resConfs.get((int)i).index, this.resConfs.get((int)i).template.name, this.resConfs.get(i).getRotamerCode()));
        }
        return buf.toString();
    }
}

