/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import edu.duke.cs.osprey.dof.MutAlignment;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.tools.HashCalculator;
import java.util.HashMap;
import java.util.Map;

public class MutAlignmentCache {
    private final Map<Key, MutAlignment> cache = new HashMap<Key, MutAlignment>();

    public synchronized MutAlignment get(ResidueTemplate src, ResidueTemplate dst) {
        return this.cache.computeIfAbsent(new Key(src, dst), key -> new MutAlignment(src, dst));
    }

    private static class Key {
        final ResidueTemplate src;
        final ResidueTemplate dst;

        Key(ResidueTemplate src, ResidueTemplate dst) {
            this.src = src;
            this.dst = dst;
        }

        public int hashCode() {
            return HashCalculator.combineHashes(System.identityHashCode(this.src), System.identityHashCode(this.dst));
        }

        public boolean equals(Object other) {
            return other instanceof Key && this.equals((Key)other);
        }

        public boolean equals(Key other) {
            return this.src == other.src && this.dst == other.dst;
        }
    }
}

