/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.MoveableStrand;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.RigidBodyMotion;
import edu.duke.cs.osprey.tools.RotationMatrix;
import edu.duke.cs.osprey.tools.VectorAlgebra;

public class StrandRotation
extends DegreeOfFreedom {
    MoveableStrand strand;
    int angleNum;

    public StrandRotation(MoveableStrand strand, int angleNum) {
        this.strand = strand;
        this.angleNum = angleNum;
    }

    @Override
    public void apply(double paramVal) {
        double[] rotationCenter = VectorAlgebra.add(this.strand.initCenter, this.strand.curTrans);
        this.strand.curAngles[this.angleNum] = paramVal;
        RotationMatrix oldMatrix = this.strand.curRotMatrix;
        this.strand.updateRotMatrixFromAngles();
        RotationMatrix newMatrix = this.strand.curRotMatrix;
        RotationMatrix changeMatrix = newMatrix.multiply(oldMatrix.transpose());
        RigidBodyMotion motion = new RigidBodyMotion(rotationCenter, changeMatrix, rotationCenter);
        for (Residue res : this.strand.res) {
            motion.transform(res.coords);
        }
    }

    public MoveableStrand getMoveableStrand() {
        return this.strand;
    }

    @Override
    public DOFBlock getBlock() {
        return this.strand;
    }

    @Override
    public String getName() {
        return "STRROT" + this.strand.res.get(0).getPDBResNumber() + "." + this.angleNum;
    }
}

