/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.MoveableStrand;
import edu.duke.cs.osprey.structure.Residue;

public class StrandTranslation
extends DegreeOfFreedom {
    MoveableStrand strand;
    int coordNum;

    public StrandTranslation(MoveableStrand strand, int coordNum) {
        this.strand = strand;
        this.coordNum = coordNum;
    }

    @Override
    public void apply(double paramVal) {
        double motion = paramVal - this.strand.curTrans[this.coordNum];
        for (Residue res : this.strand.res) {
            int numAtoms = res.atoms.size();
            for (int atomNum = 0; atomNum < numAtoms; ++atomNum) {
                int n = 3 * atomNum + this.coordNum;
                res.coords[n] = res.coords[n] + motion;
            }
        }
        this.strand.curTrans[this.coordNum] = paramVal;
    }

    public MoveableStrand getMoveableStrand() {
        return this.strand;
    }

    @Override
    public DOFBlock getBlock() {
        return this.strand;
    }

    @Override
    public String getName() {
        return "STRTRANS" + this.strand.res.get(0).getPDBResNumber() + "." + this.coordNum;
    }
}

