/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper;

import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.FileTools;
import edu.duke.cs.osprey.tools.Protractor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;

public class RamachandranChecker {
    double[][][] tables;
    static double denCutoff = 0.02f;

    private RamachandranChecker() {
    }

    public static RamachandranChecker getInstance() {
        return RamachandranCheckerHolder.INSTANCE;
    }

    public void readInputFiles(String glyText, String proText, String generalText, String preproText) {
        this.tables = new double[4][180][180];
        String[] texts = new String[]{glyText, proText, generalText, preproText};
        for (int a = 0; a < 4; ++a) {
            Iterator<String> lines = FileTools.parseLines(texts[a]).iterator();
            for (int phiBin = 0; phiBin < 180; ++phiBin) {
                for (int psiBin = 0; psiBin < 180; ++psiBin) {
                    String line = lines.next();
                    if (line.startsWith("#")) continue;
                    StringTokenizer st = new StringTokenizer(line, " ");
                    st.nextToken();
                    st.nextToken();
                    this.tables[a][phiBin][psiBin] = Double.valueOf(st.nextToken());
                }
            }
        }
    }

    public boolean[] checkByAAType(Residue res) {
        boolean[] ans = new boolean[3];
        double[] phiPsi = RamachandranChecker.getPhiPsi(res);
        if (phiPsi == null) {
            Arrays.fill(ans, true);
            return ans;
        }
        for (int a = 0; a < 3; ++a) {
            ans[a] = this.checkAngles(phiPsi[0], phiPsi[1], a);
        }
        return ans;
    }

    public boolean checkPrePro(Residue res) {
        double[] phiPsi = RamachandranChecker.getPhiPsi(res);
        if (phiPsi == null) {
            return true;
        }
        return this.checkAngles(phiPsi[0], phiPsi[1], 3);
    }

    public static double[] getPhiPsi(Residue res) {
        double[] ans = new double[2];
        if (res.indexInMolecule == 0 || res.indexInMolecule == res.molec.residues.size() - 1) {
            return null;
        }
        Residue prevRes = (Residue)res.molec.residues.get(res.indexInMolecule - 1);
        Residue nextRes = (Residue)res.molec.residues.get(res.indexInMolecule + 1);
        double[] CLast = prevRes.getCoordsByAtomName("C");
        double[] NCur = res.getCoordsByAtomName("N");
        double[] CACur = res.getCoordsByAtomName("CA");
        double[] CCur = res.getCoordsByAtomName("C");
        double[] NNext = nextRes.getCoordsByAtomName("N");
        if (CLast == null || NCur == null || CACur == null || CCur == null || NNext == null) {
            return null;
        }
        ans[0] = Protractor.measureDihedral(new double[][]{CLast, NCur, CACur, CCur});
        ans[1] = Protractor.measureDihedral(new double[][]{NCur, CACur, CCur, NNext});
        return ans;
    }

    public boolean checkAngles(double phi, double psi, int plotNum) {
        int psiBin;
        int phiBin = (int)(((phi = this.getInRange(phi)) + 180.0) / 2.0);
        double den = this.tables[plotNum][phiBin][psiBin = (int)(((psi = this.getInRange(psi)) + 180.0) / 2.0)];
        return den > denCutoff;
    }

    double getInRange(double angle) {
        while (angle >= 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    private static class RamachandranCheckerHolder {
        private static final RamachandranChecker INSTANCE = new RamachandranChecker();

        private RamachandranCheckerHolder() {
        }
    }
}

