/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper.perts;

import edu.duke.cs.osprey.dof.deeper.perts.Perturbation;
import edu.duke.cs.osprey.dof.deeper.perts.PerturbationBlock;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.Protractor;
import edu.duke.cs.osprey.tools.RigidBodyMotion;
import edu.duke.cs.osprey.tools.RotationMatrix;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.util.ArrayList;

public class Backrub
extends Perturbation {
    static final double thetaSmallScale = (double)0.7f;

    public Backrub(ArrayList<Residue> resDirectlyAffected) {
        super(resDirectlyAffected);
    }

    @Override
    public boolean doPerturbationMotion(double paramVal) {
        RigidBodyMotion[] rotations = this.calcTransRot(paramVal);
        this.applyBackrubLikeMotion(rotations);
        return true;
    }

    public RigidBodyMotion[] calcTransRot(double param) {
        double[][] x = new double[3][];
        for (int a = 0; a < 3; ++a) {
            x[a] = ((Residue)this.resDirectlyAffected.get(a)).getCoordsByAtomName("CA");
        }
        double[] oldO1Coord = ((Residue)this.resDirectlyAffected.get(0)).getCoordsByAtomName("O");
        double[] oldO2Coord = ((Residue)this.resDirectlyAffected.get(1)).getCoordsByAtomName("O");
        double[] rotax = VectorAlgebra.subtract(x[2], x[0]);
        RotationMatrix rmPrimary = new RotationMatrix(rotax[0], rotax[1], rotax[2], param, false);
        RigidBodyMotion primaryRot = new RigidBodyMotion(x[0], rmPrimary, x[0]);
        double[] newMidCACoord = (double[])x[1].clone();
        primaryRot.transform(newMidCACoord);
        double[] newO1Coord = (double[])oldO1Coord.clone();
        primaryRot.transform(newO1Coord);
        double[] newO2Coord = (double[])oldO2Coord.clone();
        primaryRot.transform(newO2Coord);
        double theta = this.getSmallRotAngle(newO1Coord, newMidCACoord, x[0], oldO1Coord);
        if (Math.signum(theta *= (double)0.7f) == Math.signum(param)) {
            theta = -theta;
        }
        rotax = VectorAlgebra.subtract(x[1], x[0]);
        RotationMatrix firstSmallRot = new RotationMatrix(rotax[0], rotax[1], rotax[2], theta, false);
        RotationMatrix firstPepRM = firstSmallRot.multiply(rmPrimary);
        RigidBodyMotion firstPepRot = new RigidBodyMotion(x[0], firstPepRM, x[0]);
        theta = this.getSmallRotAngle(newO2Coord, newMidCACoord, x[2], oldO2Coord);
        if (Math.signum(theta *= (double)0.7f) == Math.signum(param)) {
            theta = -theta;
        }
        rotax = VectorAlgebra.subtract(x[2], x[1]);
        RotationMatrix secondSmallRot = new RotationMatrix(rotax[0], rotax[1], rotax[2], theta, false);
        RotationMatrix secondPepRM = secondSmallRot.multiply(rmPrimary);
        RigidBodyMotion secondPepRot = new RigidBodyMotion(x[2], secondPepRM, x[2]);
        return new RigidBodyMotion[]{firstPepRot, secondPepRot};
    }

    private double getSmallRotAngle(double[] pp1, double[] pp2, double[] a3, double[] a4) {
        double[] pp3 = this.projectPointLine(a3, pp2, pp1);
        double[] pp4 = this.projectPointPlane(a3, pp2, pp3, a4);
        double[] closestPoint = this.getClosestPoint(pp3, pp1, pp4);
        return Protractor.getAngleDegrees(pp1, pp3, closestPoint);
    }

    public double[] projectPointLine(double[] l1, double[] l2, double[] p3) {
        double[] c = new double[3];
        double d12sq = VectorAlgebra.normsq(VectorAlgebra.subtract(l1, l2));
        double u = (p3[0] - l1[0]) * (l2[0] - l1[0]) + (p3[1] - l1[1]) * (l2[1] - l1[1]) + (p3[2] - l1[2]) * (l2[2] - l1[2]);
        c[0] = l1[0] + (u /= d12sq) * (l2[0] - l1[0]);
        c[1] = l1[1] + u * (l2[1] - l1[1]);
        c[2] = l1[2] + u * (l2[2] - l1[2]);
        return c;
    }

    public double[] projectPointPlane(double[] l1, double[] l2, double[] c3, double[] p4) {
        double[] l = new double[3];
        for (int i = 0; i < 3; ++i) {
            l[i] = l2[i] - l1[i];
        }
        double d = 0.0;
        for (int i = 0; i < 3; ++i) {
            d += l[i] * c3[i];
        }
        double t1 = 0.0;
        for (int i = 0; i < 3; ++i) {
            t1 += l[i] * p4[i];
        }
        t1 -= d;
        double t2 = 0.0;
        for (int i = 0; i < 3; ++i) {
            t2 += l[i] * l[i];
        }
        double t = t1 / t2;
        double[] r = new double[3];
        for (int i = 0; i < 3; ++i) {
            r[i] = p4[i] - t * l[i];
        }
        return r;
    }

    public double[] getClosestPoint(double[] c, double[] p1, double[] q1) {
        double r = VectorAlgebra.distance(c, p1);
        double[] t = new double[3];
        for (int i = 0; i < 3; ++i) {
            t[i] = q1[i] - c[i];
        }
        double d = 0.0;
        for (int i = 0; i < 3; ++i) {
            d += t[i] * t[i];
        }
        d = Math.sqrt(d);
        double[] a = new double[3];
        for (int i = 0; i < 3; ++i) {
            a[i] = c[i] + r * (t[i] / d);
        }
        return a;
    }

    @Override
    public Perturbation copyForNewMolecule(Molecule mol, PerturbationBlock block) {
        Backrub br = new Backrub(Residue.equivalentInMolec(this.resDirectlyAffected, mol));
        br.curParamVal = this.curParamVal;
        br.indexInBlock = this.indexInBlock;
        br.block = block;
        return br;
    }
}

