/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper.perts;

import java.io.Serializable;

public class SturmSolver
implements Serializable {
    final int PRINT_LEVEL = 0;
    final int MAX_ORDER = 16;
    final int MAXPOW = 32;
    final double SMALL_ENOUGH = 1.0E-18;
    double RELERROR;
    int MAXIT;
    int MAX_ITER_SECANT;

    SturmSolver(double tol_secant, int max_iter_sturm, int max_iter_secant) {
        this.RELERROR = tol_secant;
        this.MAXIT = max_iter_sturm;
        this.MAX_ITER_SECANT = max_iter_secant;
    }

    public int solve_sturm(int order, double[] poly_coeffs, double[] roots) {
        int i;
        poly[] sseq = new poly[32];
        for (int a = 0; a < 32; ++a) {
            sseq[a] = new poly(this);
        }
        int atmin = 0;
        int atmax = 0;
        for (i = order; i >= 0; --i) {
            sseq[0].coef[i] = poly_coeffs[i];
        }
        int np = this.buildsturm(order, sseq);
        int[] at = new int[]{atmin, atmax};
        int nroots = this.numroots(np, sseq, at);
        atmin = at[0];
        atmax = at[1];
        if (nroots == 0) {
            return 0;
        }
        double min = -1.0;
        int nchanges = this.numchanges(np, sseq, min);
        for (i = 0; nchanges != atmin && i != 32; ++i) {
            nchanges = this.numchanges(np, sseq, min *= 10.0);
        }
        if (nchanges != atmin) {
            System.out.printf("Sturm solver: unable to bracket all negative roots\n", new Object[0]);
            atmin = nchanges;
        }
        double max = 1.0;
        nchanges = this.numchanges(np, sseq, max);
        for (i = 0; nchanges != atmax && i != 32; ++i) {
            nchanges = this.numchanges(np, sseq, max *= 10.0);
        }
        if (nchanges != atmax) {
            System.out.printf("Sturm solver: unable to bracket all positive roots\n", new Object[0]);
            atmax = nchanges;
        }
        nroots = atmin - atmax;
        this.sbisect(np, sseq, min, max, atmin, atmax, roots);
        return nroots;
    }

    double hyper_tan(double a, double x) {
        double ax = a * x;
        double exp_x1 = Math.exp(ax);
        double exp_x2 = Math.exp(-ax);
        if (exp_x1 == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (exp_x2 == Double.POSITIVE_INFINITY) {
            return -1.0;
        }
        return (exp_x1 - exp_x2) / (exp_x1 + exp_x2);
    }

    public int modp(poly u, poly v, poly r) {
        int k;
        int nr = 0;
        int end = u.ord;
        int uc = 0;
        while (uc <= end) {
            r.coef[nr++] = u.coef[uc++];
        }
        if (v.coef[v.ord] < 0.0) {
            for (k = u.ord - v.ord - 1; k >= 0; k -= 2) {
                r.coef[k] = -r.coef[k];
            }
            for (k = u.ord - v.ord; k >= 0; --k) {
                for (j = v.ord + k - 1; j >= k; --j) {
                    r.coef[j] = -r.coef[j] - r.coef[v.ord + k] * v.coef[j - k];
                }
            }
        } else {
            for (k = u.ord - v.ord; k >= 0; --k) {
                for (j = v.ord + k - 1; j >= k; --j) {
                    int n = j;
                    r.coef[n] = r.coef[n] - r.coef[v.ord + k] * v.coef[j - k];
                }
            }
        }
        for (k = v.ord - 1; k >= 0 && Math.abs(r.coef[k]) < 1.0E-18; --k) {
            r.coef[k] = 0.0;
        }
        r.ord = k < 0 ? 0 : k;
        return r.ord;
    }

    int buildsturm(int ord, poly[] sseq) {
        sseq[0].ord = ord;
        sseq[1].ord = ord - 1;
        double f = Math.abs(sseq[0].coef[ord] * (double)ord);
        int fp = 0;
        int fc = 1;
        for (int i = 1; i <= ord; ++i) {
            sseq[1].coef[fp++] = sseq[0].coef[fc++] * (double)i / f;
        }
        int sp = 2;
        while (this.modp(sseq[sp - 2], sseq[sp - 1], sseq[sp]) != 0) {
            f = -Math.abs(sseq[sp].coef[sseq[sp].ord]);
            fp = sseq[sp].ord;
            while (fp >= 0) {
                int n = fp--;
                sseq[sp].coef[n] = sseq[sp].coef[n] / f;
            }
            ++sp;
        }
        sseq[sp].coef[0] = -sseq[sp].coef[0];
        return sp;
    }

    int numroots(int np, poly[] sseq, int[] at) {
        double f;
        int s;
        int atneginf = 0;
        int atposinf = 0;
        double lf = sseq[0].coef[sseq[0].ord];
        for (s = 1; s <= np; ++s) {
            f = sseq[s].coef[sseq[s].ord];
            if (lf == 0.0 || lf * f < 0.0) {
                ++atposinf;
            }
            lf = f;
        }
        lf = (sseq[0].ord & 1) != 0 ? -sseq[0].coef[sseq[0].ord] : sseq[0].coef[sseq[0].ord];
        for (s = 1; s <= np; ++s) {
            f = (sseq[s].ord & 1) != 0 ? -sseq[s].coef[sseq[s].ord] : sseq[s].coef[sseq[s].ord];
            if (lf == 0.0 || lf * f < 0.0) {
                ++atneginf;
            }
            lf = f;
        }
        at[0] = atneginf;
        at[1] = atposinf;
        return atneginf - atposinf;
    }

    int numchanges(int np, poly[] sseq, double a) {
        int changes = 0;
        double lf = this.evalpoly(sseq[0].ord, sseq[0].coef, a);
        for (int s = 1; s <= np; ++s) {
            double f = this.evalpoly(sseq[s].ord, sseq[s].coef, a);
            if (lf == 0.0 || lf * f < 0.0) {
                ++changes;
            }
            lf = f;
        }
        return changes;
    }

    void sbisect(int np, poly[] sseq, double min, double max, int atmin, int atmax, double[] roots) {
        int its;
        double mid = 0.0;
        int n1 = 0;
        int n2 = 0;
        int nroot = atmin - atmax;
        if (nroot == 1) {
            int its2;
            if (this.modrf(sseq[0].ord, sseq[0].coef, min, max, roots)) {
                return;
            }
            for (its2 = 0; its2 < this.MAXIT; ++its2) {
                mid = (min + max) / 2.0;
                int atmid = this.numchanges(np, sseq, mid);
                if (Math.abs(mid) > this.RELERROR) {
                    if (Math.abs((max - min) / mid) < this.RELERROR) {
                        roots[0] = mid;
                        return;
                    }
                } else if (Math.abs(max - min) < this.RELERROR) {
                    roots[0] = mid;
                    return;
                }
                if (atmin - atmid == 0) {
                    min = mid;
                    continue;
                }
                max = mid;
            }
            if (its2 == this.MAXIT) {
                System.err.printf("sbisect: overflow min %f max %fdiff %e nroot %d n1 %d n2 %d\n", min, max, max - min, nroot, n1, n2);
                roots[0] = mid;
            }
            return;
        }
        for (its = 0; its < this.MAXIT; ++its) {
            mid = (min + max) / 2.0;
            int atmid = this.numchanges(np, sseq, mid);
            n1 = atmin - atmid;
            n2 = atmid - atmax;
            if (n1 != 0 && n2 != 0) {
                this.sbisect(np, sseq, min, mid, atmin, atmid, roots);
                double[] rootsn1 = new double[roots.length - n1];
                this.sbisect(np, sseq, mid, max, atmid, atmax, rootsn1);
                System.arraycopy(rootsn1, 0, roots, n1, rootsn1.length);
                break;
            }
            if (n1 == 0) {
                min = mid;
                continue;
            }
            max = mid;
        }
        if (its == this.MAXIT) {
            for (n1 = atmax; n1 < atmin; ++n1) {
                roots[n1 - atmax] = mid;
            }
        }
    }

    double evalpoly(int ord, double[] coef, double x) {
        double f = coef[ord];
        for (int fp = ord - 1; fp >= 0; --fp) {
            f = x * f + coef[fp];
        }
        return f;
    }

    boolean modrf(int ord, double[] coef, double a, double b, double[] val) {
        int fp;
        double fb = coef[ord];
        double fa = coef[ord];
        for (fp = ord - 1; fp >= 0; --fp) {
            fa = a * fa + coef[fp];
            fb = b * fb + coef[fp];
        }
        if (fa * fb > 0.0) {
            return false;
        }
        double lfx = fa;
        for (int its = 0; its < this.MAX_ITER_SECANT; ++its) {
            double x = (fb * a - fa * b) / (fb - fa);
            if (x < a || x > b) {
                x = 0.5 * (a + b);
            }
            double fx = coef[ord];
            for (fp = ord - 1; fp >= 0; --fp) {
                fx = x * fx + coef[fp];
            }
            if (Math.abs(x) > this.RELERROR) {
                if (Math.abs(fx / x) < this.RELERROR) {
                    val[0] = x;
                    return true;
                }
            } else if (Math.abs(fx) < this.RELERROR) {
                val[0] = x;
                return true;
            }
            if (fa * fx < 0.0) {
                b = x;
                fb = fx;
                if (lfx * fx > 0.0) {
                    fa /= 2.0;
                }
            } else {
                a = x;
                fa = fx;
                if (lfx * fx > 0.0) {
                    fb /= 2.0;
                }
            }
            lfx = fx;
        }
        return false;
    }

    private class poly {
        int ord;
        double[] coef = new double[17];

        private poly(SturmSolver sturmSolver) {
        }
    }
}

