/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.ReferenceEnergies;
import edu.duke.cs.osprey.ematrix.TermECalculator;
import edu.duke.cs.osprey.ematrix.epic.EPICMatrix;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.handlempi.MPIMaster;
import edu.duke.cs.osprey.handlempi.MPISlaveTask;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class EnergyMatrixCalculator {
    ConfSpace searchSpace;
    ArrayList<Residue> shellResidues;
    boolean doEPIC;
    PruningMatrix pruneMat = null;
    EPICSettings epicSettings = null;
    boolean useERef = false;
    boolean addResEntropy = false;
    private EnergyMatrix emat = null;
    private EPICMatrix epicMat = null;

    public EnergyMatrixCalculator(ConfSpace s, ArrayList<Residue> sr, boolean useERef, boolean addResEntropy) {
        this.searchSpace = s;
        this.shellResidues = sr;
        this.doEPIC = false;
        this.useERef = useERef;
        this.addResEntropy = addResEntropy;
    }

    public EnergyMatrixCalculator(ConfSpace s, ArrayList<Residue> sr, PruningMatrix pr, EPICSettings es) {
        this.searchSpace = s;
        this.shellResidues = sr;
        this.doEPIC = true;
        this.pruneMat = pr;
        this.epicSettings = es;
    }

    public EnergyMatrixCalculator(ConfSpace confSpace, ArrayList<Residue> shellResidues, boolean doEPIC, PruningMatrix prm, EPICSettings es, boolean addResEntropy, EnergyMatrix emat) {
        this.searchSpace = confSpace;
        this.shellResidues = shellResidues;
        this.doEPIC = doEPIC;
        this.pruneMat = prm;
        this.epicSettings = es;
        this.addResEntropy = addResEntropy;
        this.emat = emat;
    }

    public void addEnergyTerms(boolean doIntra, int ... posNums) {
        TermECalculator hotECalc = new TermECalculator(this.searchSpace, this.shellResidues, this.doEPIC, doIntra, this.pruneMat, this.epicSettings, this.addResEntropy, posNums);
        Object hotEnergies = hotECalc.doCalculation();
        this.storeEnergy(hotEnergies, posNums);
    }

    public void calcPEM() {
        System.out.println();
        if (this.doEPIC) {
            System.out.println("BEGINNING EPIC MATRIX PRECOMPUTATION");
        } else {
            System.out.println("BEGINNING ENERGY MATRIX PRECOMPUTATION");
        }
        System.out.println();
        this.initMatrix();
        if (EnvironmentVars.useMPI) {
            this.calcPEMDistributed();
        } else {
            this.calcPEMLocally();
        }
        if (this.useERef) {
            System.out.println("COMPUTING REFERENCE ENERGIES");
            this.emat.seteRefMat(new ReferenceEnergies(this.searchSpace));
        }
        System.out.println("ENERGY MATRIX CALCULATION DONE");
    }

    public void calcPEMLocally() {
        for (int res = 0; res < this.searchSpace.numPos; ++res) {
            System.out.println("Starting intra+shell energy calculations for residue " + res);
            TermECalculator oneBodyECalc = new TermECalculator(this.searchSpace, this.shellResidues, this.doEPIC, false, this.pruneMat, this.epicSettings, this.addResEntropy, res);
            Object oneBodyE = oneBodyECalc.doCalculation();
            this.storeEnergy(oneBodyE, res);
            int res2 = 0;
            while (res2 < res) {
                System.out.println("Starting pairwise energy calculations for residues " + res + ", " + res2);
                TermECalculator pairECalc = new TermECalculator(this.searchSpace, this.shellResidues, this.doEPIC, false, this.pruneMat, this.epicSettings, false, res, res2);
                Object pairE = pairECalc.doCalculation();
                this.storeEnergy(pairE, res, res2++);
            }
        }
    }

    public void calcPEMDistributed() {
        MPIMaster mm = MPIMaster.getInstance();
        ArrayList<MPISlaveTask> tasks = new ArrayList<MPISlaveTask>();
        for (int res = 0; res < this.searchSpace.numPos; ++res) {
            tasks.add(new TermECalculator(this.searchSpace, this.shellResidues, this.doEPIC, false, this.pruneMat, this.epicSettings, this.addResEntropy, res));
            int res2 = 0;
            while (res2 < res) {
                tasks.add(new TermECalculator(this.searchSpace, this.shellResidues, this.doEPIC, false, this.pruneMat, this.epicSettings, false, res, res2++));
            }
        }
        ArrayList<Object> calcResults = mm.handleTasks(tasks);
        int resultCount = 0;
        for (int res = 0; res < this.searchSpace.numPos; ++res) {
            this.storeEnergy(calcResults.get(resultCount), res);
            ++resultCount;
            int res2 = 0;
            while (res2 < res) {
                this.storeEnergy(calcResults.get(resultCount), res, res2++);
                ++resultCount;
            }
        }
    }

    private void initMatrix() {
        if (this.doEPIC) {
            this.epicMat = new EPICMatrix(this.searchSpace, this.pruneMat.getPruningInterval());
        } else {
            this.emat = new EnergyMatrix(this.searchSpace, Double.POSITIVE_INFINITY);
        }
    }

    private void storeEnergy(Object calcResult, int ... res) {
        if (this.doEPIC) {
            if (res.length == 1) {
                this.epicMat.setOneBody(res[0], (ArrayList)calcResult);
            } else {
                this.epicMat.setPairwise(res[0], res[1], (ArrayList)calcResult);
            }
        } else if (res.length == 1) {
            this.emat.setOneBody(res[0], (ArrayList)calcResult);
        } else if (res.length == 2) {
            this.emat.setPairwise(res[0], res[1], (ArrayList)calcResult);
        } else if (res.length > 2) {
            Integer[] pos = new Integer[res.length];
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = new Integer(res[i]);
            }
            HashMap nBody2E = (HashMap)calcResult;
            for (ArrayList rc : nBody2E.keySet()) {
                double nbE = (Double)nBody2E.get(rc);
                double pwE = 0.0;
                for (int i = 0; i < pos.length; ++i) {
                    for (int j = i + 1; j < pos.length; ++j) {
                        pwE += this.emat.getPairwise(pos[i], (Integer)rc.get(i), pos[j], (Integer)rc.get(j)).doubleValue();
                    }
                }
                RCTuple nBody = new RCTuple(new ArrayList<Integer>(Arrays.asList(pos)), new ArrayList<Integer>(rc));
                this.emat.setHigherOrder(nBody, nbE - pwE);
            }
        }
    }

    public EnergyMatrix getEMatrix() {
        if (this.emat == null) {
            throw new RuntimeException("ERROR: Energy matrix is null after calculation");
        }
        return this.emat;
    }

    public EPICMatrix getEPICMatrix() {
        if (this.epicMat == null) {
            throw new RuntimeException("ERROR: EPIC matrix is null after calculation");
        }
        return this.epicMat;
    }
}

