/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.epic.EPICEnergyFunction;
import edu.duke.cs.osprey.ematrix.epic.EPICFitter;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.ematrix.epic.EPoly;
import edu.duke.cs.osprey.ematrix.epic.FitParams;
import edu.duke.cs.osprey.ematrix.epic.NewEPICMatrix;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.minimization.CCDMinimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.minimization.MoleculeObjectiveFunction;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.util.ArrayList;

public class NewEPICMatrixCalculator {
    SimpleConfSpace searchSpace;
    ConfEnergyCalculator confECalc;
    PruningMatrix pruneMat;
    EPICSettings epicSettings;
    private NewEPICMatrix epicMat = null;
    static boolean SAPEKeepStandalone = false;

    public NewEPICMatrixCalculator(SimpleConfSpace confSpace, ConfEnergyCalculator confECalc, PruningMatrix pruneMat, EPICSettings epicSettings) {
        this.searchSpace = confSpace;
        this.confECalc = confECalc;
        this.pruneMat = pruneMat;
        this.epicSettings = epicSettings;
    }

    public void calcPEM() {
        System.out.println();
        System.out.println("BEGINNING EPIC MATRIX PRECOMPUTATION");
        System.out.println();
        this.initMatrix();
        for (int pos = 0; pos < this.searchSpace.getNumPos(); ++pos) {
            System.out.println("Starting intra+shell energy calculations for residue " + pos);
            for (int rc = 0; rc < this.searchSpace.getNumResConfs(pos); ++rc) {
                EPoly singlePoly = this.makeEPoly(new RCTuple(pos, rc));
                this.epicMat.setOneBody(pos, rc, singlePoly);
            }
            for (int pos2 = 0; pos2 < pos; ++pos2) {
                System.out.println("Starting pairwise energy calculations for residues " + pos + ", " + pos2);
                for (int rc = 0; rc < this.searchSpace.getNumResConfs(pos); ++rc) {
                    for (int rc2 = 0; rc2 < this.searchSpace.getNumResConfs(pos2); ++rc2) {
                        EPoly pairPoly = this.makeEPoly(new RCTuple(pos, rc, pos2, rc2));
                        this.epicMat.setPairwise(pos, rc, pos2, rc2, pairPoly);
                    }
                }
            }
        }
        System.out.println("EPIC MATRIX CALCULATION DONE");
    }

    private void initMatrix() {
        this.epicMat = new NewEPICMatrix(this.searchSpace, this.pruneMat.getPruningInterval());
    }

    public NewEPICMatrix getEPICMatrix() {
        if (this.epicMat == null) {
            throw new RuntimeException("ERROR: EPIC matrix is null after calculation");
        }
        return this.epicMat;
    }

    public EPoly makeEPoly(RCTuple RCs2) {
        DoubleMatrix1D bestDOFVals;
        SimpleConfSpace.ResidueConf rc2;
        SimpleConfSpace.ResidueConf rc1;
        if (RCs2.pos.size() == 2 && (rc1 = this.searchSpace.positions.get((int)RCs2.pos.get((int)0).intValue()).resConfs.get(RCs2.RCs.get(0))).isParametricallyIncompatibleWith(rc2 = this.searchSpace.positions.get((int)RCs2.pos.get((int)1).intValue()).resConfs.get(RCs2.RCs.get(1)))) {
            return null;
        }
        if (this.pruneMat.isPruned(RCs2)) {
            return null;
        }
        MoleculeModifierAndScorer mof = new MoleculeModifierAndScorer(this.makeObjectiveFunction(RCs2));
        if (mof.getNumDOFs() > 0) {
            CCDMinimizer ccdMin = new CCDMinimizer(mof, true);
            bestDOFVals = ccdMin.minimize().dofValues;
        } else {
            bestDOFVals = DoubleFactory1D.dense.make(0);
        }
        double minEnergy = mof.getValue(bestDOFVals);
        EPoly epicFit = this.compEPICFit(mof, minEnergy, bestDOFVals, RCs2);
        EnergyFunction.Tools.cleanIfNeeded(mof.getEfunc());
        return epicFit;
    }

    private MoleculeObjectiveFunction makeObjectiveFunction(RCTuple RCs2) {
        switch (RCs2.size()) {
            case 1: {
                return this.confECalc.makeIntraShellObjFcn(RCs2.pos.get(0), RCs2.RCs.get(0));
            }
            case 2: {
                return this.confECalc.makePairwiseObjFcn(RCs2.pos.get(0), RCs2.RCs.get(0), RCs2.pos.get(1), RCs2.RCs.get(1));
            }
        }
        throw new RuntimeException("ERROR: Can't calculate EPIC term for RCTuple " + RCs2.stringListing());
    }

    private EPoly compEPICFit(MoleculeModifierAndScorer mof, double minEnergy, DoubleMatrix1D bestDOFVals, RCTuple RCList) {
        EPICFitter fitter = new EPICFitter(mof, this.epicSettings, bestDOFVals, minEnergy);
        EPoly bestFit = null;
        if (mof.getNumDOFs() > 0) {
            FitParams curFitParams = FitParams.quadratic(mof.getNumDOFs(), false);
            double bestResid = Double.POSITIVE_INFINITY;
            int bestBound = -1;
            ArrayList<EPoly> series = new ArrayList<EPoly>();
            int boundCount = 0;
            while (bestResid > this.epicSettings.EPICGoalResid && curFitParams != null) {
                block10: {
                    EPoly curSeries;
                    System.out.println("FIT NUMBER " + boundCount + ": " + curFitParams.getDescription());
                    try {
                        curSeries = fitter.doFit(curFitParams);
                    }
                    catch (Exception e) {
                        System.err.println("Fit failed: " + e.getMessage());
                        e.printStackTrace();
                        series.add(null);
                        curFitParams = fitter.raiseFitOrder(curFitParams);
                        break block10;
                    }
                    double meanResid = fitter.crossValidateSeries(curSeries, curFitParams);
                    series.add(curSeries);
                    if (curFitParams.order == 2 && curFitParams.PCOrder <= 2 && curFitParams.SAPECutoff == 0.0) {
                        fitter.PCTemplate = curSeries;
                    }
                    if (meanResid < bestResid && this.checkStaysPositive(curSeries, mof)) {
                        bestResid = meanResid;
                        bestBound = boundCount;
                    }
                    curFitParams = fitter.raiseFitOrder(curFitParams);
                }
                ++boundCount;
            }
            if (bestBound == -1) {
                throw new RuntimeException("ERROR: No EPIC fit found without serious errors (e.g. significant error at minimum)");
            }
            if (bestResid > this.epicSettings.EPICGoalResid) {
                System.out.println("Failed to reach goal residual.");
            }
            System.out.println("Best residual: " + bestResid + " for bound number " + bestBound);
            this.printFitTests(fitter, RCList, minEnergy, mof, bestDOFVals, series);
            bestFit = series.get(bestBound);
        } else {
            bestFit = fitter.blank();
        }
        bestFit.setMinE(minEnergy);
        if (!SAPEKeepStandalone) {
            bestFit.deleteMOFStandalone();
        }
        return bestFit;
    }

    private void printFitTests(EPICFitter fitter, RCTuple RCList, double minEnergy, MoleculeModifierAndScorer mof, DoubleMatrix1D bestDOFVals, ArrayList<EPoly> series) {
        int numDOFs = fitter.numDOFs;
        System.out.println("RCs: " + RCList.stringListing());
        System.out.println("Minimum energy: " + minEnergy);
        double[] testScales = new double[]{0.01, 0.5, 5.0, 100.0};
        int samplesPerScale = 3;
        double[] relMax = new double[numDOFs];
        double[] relMin = new double[numDOFs];
        DoubleMatrix1D[] constr = mof.getConstraints();
        for (int dof = 0; dof < numDOFs; ++dof) {
            relMax[dof] = constr[1].get(dof) - bestDOFVals.get(dof);
            relMin[dof] = constr[0].get(dof) - bestDOFVals.get(dof);
        }
        for (double scale : testScales) {
            for (int s = 0; s < samplesPerScale; ++s) {
                double[] dx = new double[numDOFs];
                DoubleMatrix1D sampAbs = DoubleFactory1D.dense.make(numDOFs);
                for (int dof = 0; dof < numDOFs; ++dof) {
                    double top = Math.min(relMax[dof], scale);
                    double bottom = Math.max(relMin[dof], -scale);
                    dx[dof] = bottom + Math.random() * (top - bottom);
                    sampAbs.set(dof, bestDOFVals.get(dof) + dx[dof]);
                }
                double trueVal = mof.getValue(sampAbs) - minEnergy;
                System.out.print("TEST: scale=" + scale + " dx=");
                for (int dof = 0; dof < numDOFs; ++dof) {
                    System.out.print(dx[dof] + " ");
                }
                System.out.print("TRUE=" + trueVal + " FIT=");
                for (EPoly b : series) {
                    if (b == null) continue;
                    System.out.print(b.evaluate(sampAbs, false, false) + " ");
                }
                System.out.println();
            }
        }
    }

    private boolean checkStaysPositive(EPoly term, MoleculeModifierAndScorer mof) {
        ArrayList<EPoly> termList = new ArrayList<EPoly>();
        termList.add(term);
        EPICEnergyFunction epicEF = new EPICEnergyFunction(termList, false);
        MoleculeModifierAndScorer ofEPIC = new MoleculeModifierAndScorer((EnergyFunction)epicEF, mof.getConstraints(), mof.getMolec(), mof.getDOFs());
        CCDMinimizer emin = new CCDMinimizer(ofEPIC, true);
        DoubleMatrix1D lowPoint = emin.minimize().dofValues;
        double lowPointTrueE = mof.getValue(lowPoint) - term.getMinE();
        double lowPointEPICE = ofEPIC.getValue(lowPoint);
        double tol = 0.1;
        if (lowPointEPICE < lowPointTrueE - tol) {
            System.out.println("Rejecting fit because of low minimum for EPIC term, " + lowPointEPICE + ".  Corresponding true E: " + lowPointTrueE);
            return false;
        }
        if (lowPointEPICE < -tol) {
            System.out.println("Warning: low minimum for EPIC term, " + lowPointEPICE + ".  Corresponding true E: " + lowPointTrueE);
        }
        epicEF.unassignSharedMolec();
        return true;
    }
}

