/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.ParameterizedMoleculeCopy;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.EnergyFunctionGenerator;
import edu.duke.cs.osprey.energy.FFInterGen;
import edu.duke.cs.osprey.energy.GpuEnergyFunctionGenerator;
import edu.duke.cs.osprey.energy.forcefield.BigForcefieldEnergy;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldInteractions;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.gpu.BufferTools;
import edu.duke.cs.osprey.gpu.cuda.GpuStreamPool;
import edu.duke.cs.osprey.gpu.cuda.Gpus;
import edu.duke.cs.osprey.minimization.CudaCCDMinimizer;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.minimization.SimpleCCDMinimizer;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.util.List;

@Deprecated
public abstract class SimpleEnergyCalculator {
    public final ForcefieldParams ffparams;
    public ConfSpace confSpace;
    public List<Residue> shellResidues;

    protected SimpleEnergyCalculator(ForcefieldParams ffparams, ConfSpace confSpace, List<Residue> shellResidues) {
        this.ffparams = ffparams;
        this.confSpace = confSpace;
        this.shellResidues = shellResidues;
    }

    public abstract EnergyFunctionGenerator getEnergyFunctionGenerator();

    public EnergyFunction makeSingleEfunc(int pos) {
        return this.makeSingleEfunc(pos, null);
    }

    public abstract EnergyFunction makeSingleEfunc(int var1, Molecule var2);

    public Minimizer.Result calcSingle(int pos, int rc) {
        return this.calcSingle(pos, rc, ParameterizedMoleculeCopy.makeNoCopy(this.confSpace));
    }

    public abstract Minimizer.Result calcSingle(int var1, int var2, ParameterizedMoleculeCopy var3);

    public EnergyFunction makePairEfunc(int pos1, int pos2) {
        return this.makePairEfunc(pos1, pos2, null);
    }

    public abstract EnergyFunction makePairEfunc(int var1, int var2, Molecule var3);

    public Minimizer.Result calcPair(int pos1, int rc1, int pos2, int rc2) {
        return this.calcPair(pos1, rc1, pos2, rc2, ParameterizedMoleculeCopy.makeNoCopy(this.confSpace));
    }

    public abstract Minimizer.Result calcPair(int var1, int var2, int var3, int var4, ParameterizedMoleculeCopy var5);

    @Deprecated
    public static class Cuda
    extends SimpleEnergyCalculator {
        private GpuStreamPool pool;
        private GpuEnergyFunctionGenerator efuncs;

        public static boolean isSupported() {
            return !Gpus.get().getGpus().isEmpty();
        }

        public Cuda(GpuStreamPool pool, ForcefieldParams ffparams, ConfSpace confSpace, List<Residue> shellResidues) {
            super(ffparams, confSpace, shellResidues);
            this.pool = pool;
            this.efuncs = new GpuEnergyFunctionGenerator(ffparams, pool);
        }

        private BufferTools.Type getBufType(boolean isMinimizing) {
            if (isMinimizing) {
                return BufferTools.Type.Direct;
            }
            return BufferTools.Type.Normal;
        }

        @Override
        public EnergyFunctionGenerator getEnergyFunctionGenerator() {
            return this.efuncs;
        }

        @Override
        public BigForcefieldEnergy makeSingleEfunc(int pos, Molecule mol) {
            return this.makeSingleEfunc(pos, mol, this.getBufType(false));
        }

        public BigForcefieldEnergy makeSingleEfunc(int pos, Molecule mol, BufferTools.Type bufType) {
            ForcefieldInteractions ffinteractions = FFInterGen.makeIntraAndShell(this.confSpace, pos, this.shellResidues, mol);
            return new BigForcefieldEnergy(this.ffparams, ffinteractions, bufType);
        }

        @Override
        public BigForcefieldEnergy makePairEfunc(int pos1, int pos2, Molecule mol) {
            return this.makePairEfunc(pos1, pos2, mol, this.getBufType(false));
        }

        private BigForcefieldEnergy makePairEfunc(int pos1, int pos2, Molecule mol, BufferTools.Type bufType) {
            ForcefieldInteractions ffinteractions = FFInterGen.makeResPair(this.confSpace, pos1, pos2, mol);
            return new BigForcefieldEnergy(this.ffparams, ffinteractions, bufType);
        }

        @Override
        public Minimizer.Result calcSingle(int pos, int rc, ParameterizedMoleculeCopy pmol) {
            RCTuple tuple = new RCTuple(pos, rc);
            boolean isMinimizing = MoleculeModifierAndScorer.hasMinimizableDofs(this.confSpace, tuple);
            BigForcefieldEnergy efunc = this.makeSingleEfunc(pos, pmol.getCopiedMolecule(), this.getBufType(isMinimizing));
            return this.calc(efunc, tuple, pmol);
        }

        @Override
        public Minimizer.Result calcPair(int pos1, int rc1, int pos2, int rc2, ParameterizedMoleculeCopy pmol) {
            RCTuple tuple = new RCTuple(pos1, rc1, pos2, rc2);
            boolean isMinimizing = MoleculeModifierAndScorer.hasMinimizableDofs(this.confSpace, tuple);
            BigForcefieldEnergy efunc = this.makePairEfunc(pos1, pos2, pmol.getCopiedMolecule(), this.getBufType(isMinimizing));
            return this.calc(efunc, tuple, pmol);
        }

        public Minimizer.Result calc(EnergyFunction efunc, RCTuple tuple, ParameterizedMoleculeCopy pmol) {
            MoleculeModifierAndScorer mof = new MoleculeModifierAndScorer(efunc, this.confSpace, tuple, pmol);
            if (mof.getNumDOFs() > 0) {
                try (CudaCCDMinimizer minimizer = new CudaCCDMinimizer(this.pool, mof);){
                    Minimizer.Result result = minimizer.minimize();
                    return result;
                }
            }
            return new Minimizer.Result(null, efunc.getEnergy());
        }
    }

    public static class Cpu
    extends SimpleEnergyCalculator {
        private EnergyFunctionGenerator efuncs;

        public Cpu(ForcefieldParams ffparams, ConfSpace confSpace, List<Residue> shellResidues) {
            super(ffparams, confSpace, shellResidues);
            this.efuncs = new EnergyFunctionGenerator(ffparams);
        }

        @Override
        public EnergyFunctionGenerator getEnergyFunctionGenerator() {
            return this.efuncs;
        }

        @Override
        public EnergyFunction makeSingleEfunc(int pos, Molecule mol) {
            return this.efuncs.interactionEnergy(FFInterGen.makeIntraAndShell(this.confSpace, pos, this.shellResidues, mol));
        }

        @Override
        public EnergyFunction makePairEfunc(int pos1, int pos2, Molecule mol) {
            return this.efuncs.interactionEnergy(FFInterGen.makeResPair(this.confSpace, pos1, pos2, mol));
        }

        @Override
        public Minimizer.Result calcSingle(int pos, int rc, ParameterizedMoleculeCopy pmol) {
            return this.calc(this.makeSingleEfunc(pos, pmol.getCopiedMolecule()), new RCTuple(pos, rc), pmol);
        }

        @Override
        public Minimizer.Result calcPair(int pos1, int rc1, int pos2, int rc2, ParameterizedMoleculeCopy pmol) {
            return this.calc(this.makePairEfunc(pos1, pos2, pmol.getCopiedMolecule()), new RCTuple(pos1, rc1, pos2, rc2), pmol);
        }

        public Minimizer.Result calc(EnergyFunction efunc, RCTuple tuple, ParameterizedMoleculeCopy pmol) {
            MoleculeModifierAndScorer mof = new MoleculeModifierAndScorer(efunc, this.confSpace, tuple, pmol);
            if (mof.getNumDOFs() > 0) {
                return new SimpleCCDMinimizer(mof).minimize();
            }
            return new Minimizer.Result(null, efunc.getEnergy());
        }
    }
}

