/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.epic;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.ematrix.epic.EPoly;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.structure.Molecule;
import java.util.ArrayList;
import java.util.List;

public class EPICEnergyFunction
implements EnergyFunction.NeedsInit,
EnergyFunction.DecomposableByDof {
    private static final long serialVersionUID = -6797584391009212938L;
    DoubleMatrix1D curDOFVals = null;
    boolean useSharedMolec = true;
    boolean includeMinE = false;
    ArrayList<EPoly> terms;
    ArrayList<ArrayList<Integer>> termDOFs;

    public EPICEnergyFunction(ArrayList<EPoly> terms, boolean includeMinE) {
        this.terms = terms;
        this.includeMinE = includeMinE;
    }

    @Override
    public void init(Molecule molec, List<DegreeOfFreedom> DOFs, DoubleMatrix1D DOFVector) {
        this.curDOFVals = DOFVector;
        this.termDOFs = new ArrayList();
        for (EPoly term : this.terms) {
            ArrayList<Integer> singleTermDOFs = new ArrayList<Integer>();
            for (String dofName : term.DOFNames) {
                int indexOfDOF = -1;
                for (int DOFNum = 0; DOFNum < DOFs.size(); ++DOFNum) {
                    if (!dofName.equalsIgnoreCase(DOFs.get(DOFNum).getName())) continue;
                    indexOfDOF = DOFNum;
                    break;
                }
                if (indexOfDOF == -1) {
                    throw new RuntimeException("ERROR: Degree of freedom in EPoly term not found in conf reference DOFs");
                }
                singleTermDOFs.add(indexOfDOF);
            }
            this.termDOFs.add(singleTermDOFs);
        }
        if (this.useSharedMolec) {
            for (EPoly term : this.terms) {
                if (term.sapeTerm == null) continue;
                term.sapeTerm.assignSharedMolecule(molec);
            }
        }
    }

    public void unassignSharedMolec() {
        for (EPoly term : this.terms) {
            if (term.sapeTerm == null) continue;
            term.sapeTerm.sharedMolecEnergyFunction = null;
        }
    }

    @Override
    public double getEnergy() {
        if (this.curDOFVals == null) {
            throw new RuntimeException("ERROR: Trying to evaluate an EPICEnergyFunction before assigning it to a vector of DOF values");
        }
        double E = 0.0;
        for (int termNum = 0; termNum < this.terms.size(); ++termNum) {
            EPoly term = this.terms.get(termNum);
            DoubleMatrix1D DOFValsForTerm = DoubleFactory1D.dense.make(term.numDOFs);
            for (int DOFCount = 0; DOFCount < term.numDOFs; ++DOFCount) {
                DOFValsForTerm.set(DOFCount, this.curDOFVals.get(this.termDOFs.get(termNum).get(DOFCount).intValue()));
            }
            double termVal = term.evaluate(DOFValsForTerm, this.includeMinE, this.useSharedMolec);
            E += termVal;
        }
        return E;
    }

    public ArrayList<Double> allTermValues() {
        ArrayList<Double> ans = new ArrayList<Double>();
        if (this.curDOFVals == null) {
            throw new RuntimeException("ERROR: Trying to evaluate an EPICEnergyFunction before assigning it to a vector of DOF values");
        }
        for (int termNum = 0; termNum < this.terms.size(); ++termNum) {
            EPoly term = this.terms.get(termNum);
            DoubleMatrix1D DOFValsForTerm = DoubleFactory1D.dense.make(term.numDOFs);
            for (int DOFCount = 0; DOFCount < term.numDOFs; ++DOFCount) {
                DOFValsForTerm.set(DOFCount, this.curDOFVals.get(this.termDOFs.get(termNum).get(DOFCount).intValue()));
            }
            double termVal = term.evaluate(DOFValsForTerm, this.includeMinE, this.useSharedMolec);
            ans.add(termVal);
        }
        return ans;
    }

    public void printAllTermValues() {
        for (double termVal : this.allTermValues()) {
            System.out.println(termVal);
        }
    }

    @Override
    public List<EnergyFunction> decomposeByDof(Molecule molec, List<DegreeOfFreedom> DOFs) {
        ArrayList<EnergyFunction> ans = new ArrayList<EnergyFunction>();
        for (DegreeOfFreedom dof : DOFs) {
            String dofName = dof.getName();
            ArrayList<EPoly> dofTerms = new ArrayList<EPoly>();
            for (EPoly term : this.terms) {
                if (!term.DOFNames.contains(dofName)) continue;
                dofTerms.add(term);
            }
            EPICEnergyFunction partial = new EPICEnergyFunction(dofTerms, this.includeMinE);
            partial.init(molec, DOFs, this.curDOFVals);
            ans.add(partial);
        }
        return ans;
    }
}

