/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.epic;

import edu.duke.cs.osprey.ematrix.epic.SeriesFitter;
import java.io.Serializable;

public class FitParams
implements Serializable {
    static FitParams CLASH = new FitParams();
    public int numDims;
    public int order;
    public double PCFac;
    public int PCOrder;
    public boolean includeConst;
    public double SAPECutoff;
    public int numPCParams = -1;

    public FitParams() {
    }

    public FitParams(int numDims, int order, double PCFac, int PCOrder, boolean includeConst, double explicitVDWCutoff) {
        this.numDims = numDims;
        this.order = order;
        this.PCFac = PCFac;
        this.PCOrder = PCOrder;
        this.includeConst = includeConst;
        this.SAPECutoff = explicitVDWCutoff;
    }

    public static FitParams quadratic(int nd, boolean includeConst) {
        return new FitParams(nd, 2, 0.0, 2, includeConst, 0.0);
    }

    public boolean increaseOrder(boolean useSVE) {
        if (this.order == 2) {
            if (useSVE && this.SAPECutoff < 3.0) {
                this.SAPECutoff = 3.0;
                return true;
            }
            this.order = 4;
            return true;
        }
        if (this.order == 4) {
            if (useSVE && this.SAPECutoff < 4.0) {
                this.SAPECutoff = 4.0;
                return true;
            }
            this.order = 6;
            return true;
        }
        System.err.println("Warning: Cannot increase order further");
        return false;
    }

    public int numSamplesNeeded() {
        return 10 * this.numParams();
    }

    public int numParams() {
        int ans = SeriesFitter.getNumParams(this.numDims, this.includeConst, this.order);
        if (this.PCOrder > this.order) {
            if (this.numPCParams == -1) {
                throw new Error("Tried to call fitParams.numParams() on PC fit withoutprecomputing numPCParams!");
            }
            ans += this.numPCParams;
        }
        return ans;
    }

    public String getDescription() {
        if (this == CLASH) {
            return "CLASH";
        }
        String description = "FIT ORDER: " + this.order;
        if (this.PCOrder > this.order) {
            description = description + " PCORDER=" + this.PCOrder + " FAC=" + this.PCFac;
        }
        if (this.SAPECutoff > 0.0) {
            description = description + " EXPLICITVDWCUTOFF=" + this.SAPECutoff;
        }
        if (this.includeConst) {
            description = description + " INCLUDECONST";
        }
        return description;
    }

    public int compareTo(FitParams fp) {
        if (this.PCOrder > this.order || fp.PCOrder > fp.order) {
            throw new RuntimeException("ERROR: FitParams order comparison doesn't support PC");
        }
        if (this.order > fp.order) {
            return 1;
        }
        if (this.order < fp.order) {
            return -1;
        }
        return Double.valueOf(this.SAPECutoff).compareTo(fp.SAPECutoff);
    }
}

