/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.ParametricMolecule;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyPartition;
import edu.duke.cs.osprey.energy.ResInterGen;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.energy.approximation.ApproximatorMatrix;
import edu.duke.cs.osprey.energy.approximation.ResidueInteractionsApproximator;
import edu.duke.cs.osprey.minimization.MoleculeObjectiveFunction;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.Progress;
import edu.duke.cs.osprey.tools.TimeTools;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class ConfEnergyCalculator {
    public final SimpleConfSpace confSpace;
    public final EnergyCalculator ecalc;
    public final EnergyPartition epart;
    public final SimpleReferenceEnergies eref;
    public final boolean addResEntropy;
    public final ApproximatorMatrix amat;
    public final double approximationErrorBudget;
    public final boolean addShellInters;
    public final TaskExecutor tasks;
    protected final AtomicLong numCalculations = new AtomicLong(0L);
    protected final AtomicLong numConfDBReads = new AtomicLong(0L);

    protected ConfEnergyCalculator(SimpleConfSpace confSpace, TaskExecutor tasks) {
        this.confSpace = confSpace;
        this.ecalc = null;
        this.epart = null;
        this.eref = null;
        this.addResEntropy = false;
        this.amat = null;
        this.approximationErrorBudget = Double.NaN;
        this.addShellInters = false;
        this.tasks = tasks;
    }

    protected ConfEnergyCalculator(SimpleConfSpace confSpace, EnergyCalculator ecalc, EnergyPartition epart, SimpleReferenceEnergies eref, boolean addResEntropy, ApproximatorMatrix amat, double approximationErrorBudget, boolean addShellInters) {
        this.confSpace = confSpace;
        this.ecalc = ecalc;
        this.epart = epart;
        this.eref = eref;
        this.addResEntropy = addResEntropy;
        this.amat = amat;
        this.approximationErrorBudget = approximationErrorBudget;
        this.addShellInters = addShellInters;
        this.tasks = ecalc.tasks;
    }

    protected ConfEnergyCalculator(ConfEnergyCalculator other) {
        this(other, other.ecalc);
    }

    public ConfEnergyCalculator(ConfEnergyCalculator other, EnergyCalculator ecalc) {
        this(other.confSpace, ecalc, other.epart, other.eref, other.addResEntropy, other.amat, other.approximationErrorBudget, other.addShellInters);
    }

    protected ConfEnergyCalculator(TaskExecutor tasks, boolean addShellInters) {
        this.confSpace = null;
        this.ecalc = null;
        this.epart = null;
        this.eref = null;
        this.addResEntropy = false;
        this.amat = null;
        this.approximationErrorBudget = 0.0;
        this.addShellInters = addShellInters;
        this.tasks = tasks;
    }

    public ConfSpaceIteration confSpaceIteration() {
        return this.confSpace;
    }

    public long getNumRequests() {
        return this.numCalculations.get() + this.numConfDBReads.get();
    }

    public long getNumCalculations() {
        return this.numCalculations.get();
    }

    public long getNumConfDBReads() {
        return this.numConfDBReads.get();
    }

    public void resetCounters() {
        this.numCalculations.set(0L);
        this.numConfDBReads.set(0L);
    }

    public ResidueInteractions makeFragInters(RCTuple frag) {
        if (this.addShellInters) {
            return EnergyPartition.makeAll(this.confSpace, this.eref, this.addResEntropy, frag);
        }
        return EnergyPartition.makeFragment(this.confSpace, this.eref, this.addResEntropy, frag);
    }

    public ResidueInteractions makeShellInters() {
        return EnergyPartition.makeShell(this.confSpace);
    }

    public ResidueInteractions makeSingleInters(int pos, int rc) {
        return this.epart.makeSingle(this.confSpace, this.eref, this.addResEntropy, pos, rc);
    }

    public ResidueInteractions makePairInters(int pos1, int rc1, int pos2, int rc2) {
        return this.epart.makePair(this.confSpace, this.eref, this.addResEntropy, pos1, rc1, pos2, rc2);
    }

    public ResidueInteractions makeTupleInters(RCTuple tuple) {
        return this.epart.makeTuple(this.confSpace, this.eref, this.addResEntropy, tuple);
    }

    public ResidueInteractions makeTripleCorrectionInters(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        return this.epart.makeTripleCorrection(this.confSpace, this.eref, this.addResEntropy, pos1, rc1, pos2, rc2, pos3, rc3);
    }

    public ResidueInteractions makeQuadCorrectionInters(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4, int rc4) {
        return this.epart.makeQuadCorrection(this.confSpace, this.eref, this.addResEntropy, pos1, rc1, pos2, rc2, pos3, rc3, pos4, rc4);
    }

    public EnergyCalculator.EnergiedParametricMolecule calcIntraEnergy(int pos, int rc) {
        ResidueInteractions inters = ResInterGen.of(this.confSpace).addIntra(pos).make();
        return this.calcEnergy(new RCTuple(pos, rc), inters);
    }

    public EnergyCalculator.EnergiedParametricMolecule calcSingleEnergy(int pos, int rc) {
        return this.calcSingleEnergy(new RCTuple(pos, rc));
    }

    public EnergyCalculator.EnergiedParametricMolecule calcSingleEnergy(RCTuple frag) {
        return this.calcEnergy(frag, this.epart.makeSingle(this.confSpace, this.eref, this.addResEntropy, frag.pos.get(0), frag.RCs.get(0)));
    }

    public EnergyCalculator.EnergiedParametricMolecule calcPairEnergy(int pos1, int rc1, int pos2, int rc2) {
        return this.calcPairEnergy(new RCTuple(pos1, rc1, pos2, rc2));
    }

    public EnergyCalculator.EnergiedParametricMolecule calcPairEnergy(RCTuple frag) {
        return this.calcEnergy(frag, this.epart.makePair(this.confSpace, this.eref, this.addResEntropy, frag.pos.get(0), frag.RCs.get(0), frag.pos.get(1), frag.RCs.get(1)));
    }

    public EnergyCalculator.EnergiedParametricMolecule calcTupleEnergy(RCTuple frag) {
        return this.calcEnergy(frag, this.epart.makeTuple(this.confSpace, this.eref, this.addResEntropy, frag));
    }

    public EnergyCalculator.EnergiedParametricMolecule calcShellEnergy(RCTuple frag) {
        return this.calcEnergy(frag, this.makeShellInters());
    }

    public EnergyCalculator.EnergiedParametricMolecule calcEnergy(RCTuple frag) {
        return this.calcEnergy(frag, this.makeFragInters(frag));
    }

    public EnergyCalculator.EnergiedParametricMolecule calcEnergy(RCTuple frag, ResidueInteractions inters) {
        this.numCalculations.incrementAndGet();
        ParametricMolecule pmol = this.confSpace.makeMolecule(frag);
        ResidueInteractionsApproximator approximator = null;
        if (this.amat != null) {
            approximator = this.amat.get(frag, inters, this.approximationErrorBudget);
        }
        return this.ecalc.calcEnergy(pmol, inters, approximator);
    }

    public void calcEnergyAsync(RCTuple frag, ResidueInteractions inters, TaskExecutor.TaskListener<EnergyCalculator.EnergiedParametricMolecule> listener) {
        this.tasks.submit(() -> this.calcEnergy(frag, inters), listener);
    }

    public void calcEnergyAsync(RCTuple frag, TaskExecutor.TaskListener<EnergyCalculator.EnergiedParametricMolecule> listener) {
        this.tasks.submit(() -> this.calcEnergy(frag), listener);
    }

    public double calcEnergy(RCTuple frag, ConfDB.ConfTable table) {
        return this.calcEnergy(frag, this.makeFragInters(frag), table);
    }

    public double calcEnergy(RCTuple frag, ResidueInteractions inters, ConfDB.ConfTable table) {
        if (table == null) {
            return this.calcEnergy((RCTuple)frag, (ResidueInteractions)inters).energy;
        }
        int[] conf = Conf.make(this.confSpace, frag);
        ConfDB.Conf dbconf = table.get(conf);
        if (dbconf != null && dbconf.upper != null) {
            this.numConfDBReads.incrementAndGet();
            return dbconf.upper.energy;
        }
        double energy = this.calcEnergy((RCTuple)frag, (ResidueInteractions)inters).energy;
        table.setUpperBound(conf, energy, TimeTools.getTimestampNs());
        table.flush();
        return energy;
    }

    public void calcEnergyAsync(RCTuple frag, ConfDB.ConfTable table, TaskExecutor.TaskListener<Double> listener) {
        this.tasks.submit(() -> this.calcEnergy(frag, table), listener);
    }

    public void calcEnergyAsync(RCTuple frag, ResidueInteractions inters, ConfDB.ConfTable table, TaskExecutor.TaskListener<Double> listener) {
        this.tasks.submit(() -> this.calcEnergy(frag, inters, table), listener);
    }

    public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf) {
        return new ConfSearch.EnergiedConf(conf, this.calcEnergy((RCTuple)new RCTuple((int[])conf.getAssignments())).energy);
    }

    public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf, ConfDB.ConfTable table) {
        return this.calcEnergy(conf, table, () -> this.calcEnergy(conf));
    }

    public void calcEnergyAsync(ConfSearch.ScoredConf conf, TaskExecutor.TaskListener<ConfSearch.EnergiedConf> listener) {
        this.tasks.submit(() -> this.calcEnergy(conf), listener);
    }

    public void calcEnergyAsync(ConfSearch.ScoredConf conf, ConfDB.ConfTable table, TaskExecutor.TaskListener<ConfSearch.EnergiedConf> listener) {
        this.calcEnergyAsync(conf, table, () -> this.calcEnergy(conf), listener);
    }

    public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf, ResidueInteractions inters) {
        return new ConfSearch.EnergiedConf(conf, this.calcEnergy((RCTuple)new RCTuple((int[])conf.getAssignments()), (ResidueInteractions)inters).energy);
    }

    public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf, ResidueInteractions inters, ConfDB.ConfTable table) {
        return this.calcEnergy(conf, table, () -> this.calcEnergy(conf, inters));
    }

    public void calcEnergyAsync(ConfSearch.ScoredConf conf, ResidueInteractions inters, TaskExecutor.TaskListener<ConfSearch.EnergiedConf> listener) {
        this.tasks.submit(() -> this.calcEnergy(conf), listener);
    }

    public void calcEnergyAsync(ConfSearch.ScoredConf conf, ResidueInteractions inters, ConfDB.ConfTable table, TaskExecutor.TaskListener<ConfSearch.EnergiedConf> listener) {
        this.calcEnergyAsync(conf, table, () -> this.calcEnergy(conf, inters), listener);
    }

    protected ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf, ConfDB.ConfTable table, Supplier<ConfSearch.EnergiedConf> supplier) {
        if (table == null) {
            return supplier.get();
        }
        ConfSearch.EnergiedConf econf = table.getEnergied(conf);
        if (econf != null) {
            this.numConfDBReads.incrementAndGet();
            return econf;
        }
        econf = supplier.get();
        table.setBounds(econf, TimeTools.getTimestampNs());
        table.flush();
        return econf;
    }

    private void calcEnergyAsync(ConfSearch.ScoredConf conf, ConfDB.ConfTable table, Supplier<ConfSearch.EnergiedConf> supplier, TaskExecutor.TaskListener<ConfSearch.EnergiedConf> listener) {
        this.tasks.submit(() -> this.calcEnergy(conf, table, supplier), listener);
    }

    public List<ConfSearch.EnergiedConf> calcAllEnergies(List<ConfSearch.ScoredConf> confs) {
        return this.calcAllEnergies(confs, false);
    }

    public List<ConfSearch.EnergiedConf> calcAllEnergies(List<ConfSearch.ScoredConf> confs, ConfDB.ConfTable table) {
        return this.calcAllEnergies(confs, false, table);
    }

    public List<ConfSearch.EnergiedConf> calcAllEnergies(List<ConfSearch.ScoredConf> confs, boolean reportProgress) {
        return this.calcAllEnergies(confs, reportProgress, null);
    }

    public List<ConfSearch.EnergiedConf> calcAllEnergies(List<ConfSearch.ScoredConf> confs, boolean reportProgress, ConfDB.ConfTable table) {
        ArrayList<ConfSearch.EnergiedConf> econfs = new ArrayList<ConfSearch.EnergiedConf>(confs.size());
        for (int i = 0; i < confs.size(); ++i) {
            econfs.add(null);
        }
        Progress progress2 = reportProgress ? new Progress(confs.size()) : null;
        for (int i = 0; i < confs.size(); ++i) {
            int fi = i;
            this.calcEnergyAsync(confs.get(i), table, (ConfSearch.EnergiedConf econf) -> {
                econfs.set(fi, (ConfSearch.EnergiedConf)econf);
                if (progress2 != null) {
                    progress2.incrementProgress();
                }
            });
        }
        this.tasks.waitForFinish();
        return econfs;
    }

    public MoleculeObjectiveFunction makeIntraShellObjFcn(int pos, int rc) {
        ParametricMolecule bpmol = this.confSpace.makeMolecule(new RCTuple(pos, rc));
        ResidueInteractions inters = EnergyPartition.Traditional.makeSingle(this.confSpace, this.eref, this.addResEntropy, pos, rc);
        return this.ecalc.makeEnergyObjFcn(bpmol, inters);
    }

    public MoleculeObjectiveFunction makePairwiseObjFcn(int pos1, int rc1, int pos2, int rc2) {
        ParametricMolecule bpmol = this.confSpace.makeMolecule(new RCTuple(pos1, rc1, pos2, rc2));
        ResidueInteractions inters = EnergyPartition.Traditional.makePair(this.confSpace, this.eref, this.addResEntropy, pos1, rc1, pos2, rc2);
        return this.ecalc.makeEnergyObjFcn(bpmol, inters);
    }

    public static class Builder {
        private SimpleConfSpace confSpace;
        private EnergyCalculator ecalc;
        private EnergyPartition epart = EnergyPartition.Traditional;
        private SimpleReferenceEnergies eref = null;
        private boolean addResEntropy = false;
        private ApproximatorMatrix amat = null;
        private double approximationErrorBudget = 0.01;
        private boolean addShellInters = false;

        public Builder(SimpleConfSpace confSpace, EnergyCalculator ecalc) {
            this.confSpace = confSpace;
            this.ecalc = ecalc;
        }

        public Builder setEnergyPartition(EnergyPartition val) {
            this.epart = val;
            return this;
        }

        public Builder setReferenceEnergies(SimpleReferenceEnergies val) {
            this.eref = val;
            return this;
        }

        public Builder addResEntropy(boolean val) {
            this.addResEntropy = val;
            return this;
        }

        public Builder setApproximatorMatrix(ApproximatorMatrix val) {
            this.amat = val;
            return this;
        }

        public Builder setApproximationErrorBudget(double val) {
            this.approximationErrorBudget = val;
            return this;
        }

        public Builder setAddShellInters(boolean val) {
            this.addShellInters = val;
            return this;
        }

        public ConfEnergyCalculator build() {
            return new ConfEnergyCalculator(this.confSpace, this.ecalc, this.epart, this.eref, this.addResEntropy, this.amat, this.approximationErrorBudget, this.addShellInters);
        }
    }
}

