/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.tools.AutoCleanable;
import java.io.Serializable;
import java.util.List;

public interface EnergyFunction
extends Serializable,
AutoCleanable {
    public double getEnergy();

    @Override
    default public void clean() {
        Tools.cleanIfNeeded(this);
    }

    public static class Tools {
        public static void cleanIfNeeded(EnergyFunction efunc) {
            if (efunc != null && efunc instanceof NeedsCleanup) {
                ((NeedsCleanup)efunc).cleanWithoutCrashing();
            }
        }
    }

    public static interface ExplicitChemicalChanges
    extends EnergyFunction {
        public int handleChemicalChanges();
    }

    public static interface NeedsCleanup
    extends EnergyFunction,
    AutoCleanable {
    }

    public static interface NeedsInit
    extends EnergyFunction {
        public void init(Molecule var1, List<DegreeOfFreedom> var2, DoubleMatrix1D var3);
    }

    public static interface DecomposableByDof
    extends EnergyFunction {
        public List<EnergyFunction> decomposeByDof(Molecule var1, List<DegreeOfFreedom> var2);
    }
}

