/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.energy.ResInterGen;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.tools.MathTools;

public enum EnergyPartition {
    Traditional{

        @Override
        public ResidueInteractions makeSingle(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, int pos, int rc) {
            double offset = 0.0;
            if (eref != null) {
                offset += eref.getOffset(confSpace, pos, rc);
            }
            if (addResEntropy) {
                offset += 1.getResEntropy(confSpace, pos, rc);
            }
            return ResInterGen.of(confSpace).addIntra(pos, 1.0, offset).addShell(pos).make();
        }

        @Override
        public ResidueInteractions makePair(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, int pos1, int rc1, int pos2, int rc2) {
            return ResInterGen.of(confSpace).addInter(pos1, pos2).make();
        }

        @Override
        public ResidueInteractions makeTuple(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, RCTuple tuple) {
            return ResInterGen.of(confSpace).addInters(tuple).make();
        }

        @Override
        public ResidueInteractions makeTripleCorrection(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
            double weight = 1.0 / (double)MathTools.numTriplesPerPair(confSpace.positions.size());
            double offset = 0.0;
            return ResInterGen.of(confSpace).addInter(pos1, pos2, weight, offset).addInter(pos1, pos3, weight, offset).addInter(pos2, pos3, weight, offset).make();
        }

        @Override
        public double offsetTripleEnergy(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, EnergyMatrix emat) {
            double weight = 1.0 / (double)MathTools.numTriplesPerPair(emat.getNumPos());
            return weight * (emat.getPairwise(pos1, rc1, pos2, rc2) + emat.getPairwise(pos1, rc1, pos3, rc3) + emat.getPairwise(pos2, rc2, pos3, rc3));
        }

        @Override
        public ResidueInteractions makeQuadCorrection(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4, int rc4) {
            double weight = 1.0 / (double)MathTools.numQuadsPerPair(confSpace.positions.size());
            double offset = 0.0;
            return ResInterGen.of(confSpace).addInter(pos1, pos2, weight, offset).addInter(pos1, pos3, weight, offset).addInter(pos1, pos4, weight, offset).addInter(pos2, pos3, weight, offset).addInter(pos2, pos4, weight, offset).addInter(pos3, pos4, weight, offset).make();
        }

        @Override
        public double offsetQuadEnergy(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4, int rc4, EnergyMatrix emat) {
            double weight = 1.0 / (double)MathTools.numQuadsPerPair(emat.getNumPos());
            return weight * (emat.getPairwise(pos1, rc1, pos2, rc2) + emat.getPairwise(pos1, rc1, pos3, rc3) + emat.getPairwise(pos1, rc1, pos4, rc4) + emat.getPairwise(pos2, rc2, pos3, rc3) + emat.getPairwise(pos2, rc2, pos4, rc4) + emat.getPairwise(pos3, rc3, pos4, rc4));
        }
    }
    ,
    AllOnPairs{

        @Override
        public ResidueInteractions makeSingle(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, int pos, int rc) {
            if (confSpace.positions.size() == 1) {
                return Traditional.makeSingle(confSpace, eref, addResEntropy, pos, rc);
            }
            return ResInterGen.of(confSpace).make();
        }

        @Override
        public ResidueInteractions makePair(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, int pos1, int rc1, int pos2, int rc2) {
            double offset1 = 0.0;
            double offset2 = 0.0;
            if (eref != null) {
                offset1 += eref.getOffset(confSpace, pos1, rc1);
                offset2 += eref.getOffset(confSpace, pos2, rc2);
            }
            if (addResEntropy) {
                offset1 += 2.getResEntropy(confSpace, pos1, rc1);
                offset2 += 2.getResEntropy(confSpace, pos2, rc2);
            }
            double weight = 1.0 / (double)(confSpace.positions.size() - 1);
            return ResInterGen.of(confSpace).addInter(pos1, pos2).addIntra(pos1, weight, offset1).addIntra(pos2, weight, offset2).addShell(pos1, weight, 0.0).addShell(pos2, weight, 0.0).make();
        }

        @Override
        public ResidueInteractions makeTuple(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, RCTuple tuple) {
            if (tuple.size() == 1) {
                return this.makeSingle(confSpace, eref, addResEntropy, tuple.pos.get(0), tuple.RCs.get(0));
            }
            double weight = (double)(tuple.size() - 1) / (double)(confSpace.positions.size() - 1);
            return ResInterGen.of(confSpace).addIntras(tuple, weight, (pos, rc) -> {
                double offset = 0.0;
                if (eref != null) {
                    offset += eref.getOffset(confSpace, pos, rc);
                }
                if (addResEntropy) {
                    offset += 2.getResEntropy(confSpace, pos, rc);
                }
                return offset;
            }).addInters(tuple).addShell(tuple, weight, (pos, rc, shellResNum) -> 0.0).make();
        }

        @Override
        public ResidueInteractions makeTripleCorrection(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
            double offset1 = 0.0;
            double offset2 = 0.0;
            double offset3 = 0.0;
            if (eref != null) {
                offset1 += eref.getOffset(confSpace, pos1, rc1);
                offset2 += eref.getOffset(confSpace, pos2, rc2);
                offset3 += eref.getOffset(confSpace, pos3, rc3);
            }
            if (addResEntropy) {
                offset1 += 2.getResEntropy(confSpace, pos1, rc1);
                offset2 += 2.getResEntropy(confSpace, pos2, rc2);
                offset3 += 2.getResEntropy(confSpace, pos3, rc3);
            }
            double singleWeight = 1.0 / (double)MathTools.numTriplesPerSingle(confSpace.positions.size());
            double pairWeight = 1.0 / (double)MathTools.numTriplesPerPair(confSpace.positions.size());
            return ResInterGen.of(confSpace).addIntra(pos1, singleWeight, offset1).addIntra(pos2, singleWeight, offset2).addIntra(pos3, singleWeight, offset3).addInter(pos1, pos2, pairWeight, 0.0).addInter(pos1, pos3, pairWeight, 0.0).addInter(pos2, pos3, pairWeight, 0.0).addShell(pos1, singleWeight, 0.0).addShell(pos2, singleWeight, 0.0).addShell(pos3, singleWeight, 0.0).make();
        }

        @Override
        public double offsetTripleEnergy(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, EnergyMatrix emat) {
            double weight = 1.0 / (double)MathTools.numTriplesPerPair(emat.getNumPos());
            return weight * (emat.getPairwise(pos1, rc1, pos2, rc2) + emat.getPairwise(pos1, rc1, pos3, rc3) + emat.getPairwise(pos2, rc2, pos3, rc3));
        }

        @Override
        public ResidueInteractions makeQuadCorrection(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4, int rc4) {
            double offset1 = 0.0;
            double offset2 = 0.0;
            double offset3 = 0.0;
            double offset4 = 0.0;
            if (eref != null) {
                offset1 += eref.getOffset(confSpace, pos1, rc1);
                offset2 += eref.getOffset(confSpace, pos2, rc2);
                offset3 += eref.getOffset(confSpace, pos3, rc3);
                offset4 += eref.getOffset(confSpace, pos4, rc4);
            }
            if (addResEntropy) {
                offset1 += 2.getResEntropy(confSpace, pos1, rc1);
                offset2 += 2.getResEntropy(confSpace, pos2, rc2);
                offset3 += 2.getResEntropy(confSpace, pos3, rc3);
                offset4 += 2.getResEntropy(confSpace, pos4, rc4);
            }
            double singleWeight = 1.0 / (double)MathTools.numQuadsPerSingle(confSpace.positions.size());
            double pairWeight = 1.0 / (double)MathTools.numQuadsPerPair(confSpace.positions.size());
            return ResInterGen.of(confSpace).addIntra(pos1, singleWeight, offset1).addIntra(pos2, singleWeight, offset2).addIntra(pos3, singleWeight, offset3).addIntra(pos4, singleWeight, offset4).addInter(pos1, pos2, pairWeight, 0.0).addInter(pos1, pos3, pairWeight, 0.0).addInter(pos1, pos4, pairWeight, 0.0).addInter(pos2, pos3, pairWeight, 0.0).addInter(pos2, pos4, pairWeight, 0.0).addInter(pos3, pos4, pairWeight, 0.0).addShell(pos1, singleWeight, 0.0).addShell(pos2, singleWeight, 0.0).addShell(pos3, singleWeight, 0.0).addShell(pos4, singleWeight, 0.0).make();
        }

        @Override
        public double offsetQuadEnergy(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4, int rc4, EnergyMatrix emat) {
            double weight = 1.0 / (double)MathTools.numQuadsPerPair(emat.getNumPos());
            return weight * (emat.getPairwise(pos1, rc1, pos2, rc2) + emat.getPairwise(pos1, rc1, pos3, rc3) + emat.getPairwise(pos1, rc1, pos4, rc4) + emat.getPairwise(pos2, rc2, pos3, rc3) + emat.getPairwise(pos2, rc2, pos4, rc4) + emat.getPairwise(pos3, rc3, pos4, rc4));
        }
    };


    public abstract ResidueInteractions makeSingle(SimpleConfSpace var1, SimpleReferenceEnergies var2, boolean var3, int var4, int var5);

    public abstract ResidueInteractions makePair(SimpleConfSpace var1, SimpleReferenceEnergies var2, boolean var3, int var4, int var5, int var6, int var7);

    public abstract ResidueInteractions makeTuple(SimpleConfSpace var1, SimpleReferenceEnergies var2, boolean var3, RCTuple var4);

    public abstract ResidueInteractions makeTripleCorrection(SimpleConfSpace var1, SimpleReferenceEnergies var2, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract double offsetTripleEnergy(int var1, int var2, int var3, int var4, int var5, int var6, EnergyMatrix var7);

    public abstract ResidueInteractions makeQuadCorrection(SimpleConfSpace var1, SimpleReferenceEnergies var2, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public abstract double offsetQuadEnergy(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, EnergyMatrix var9);

    public static ResidueInteractions makeFragment(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, RCTuple frag) {
        return ResInterGen.of(confSpace).addIntras(frag, 1.0, (pos, rc) -> {
            double offset = 0.0;
            if (eref != null) {
                offset += eref.getOffset(confSpace, pos, rc);
            }
            if (addResEntropy) {
                offset += EnergyPartition.getResEntropy(confSpace, pos, rc);
            }
            return offset;
        }).addInters(frag).addShell(frag).make();
    }

    public static ResidueInteractions makeShell(SimpleConfSpace confSpace) {
        return ResInterGen.of(confSpace).addShellIntras().addShellInters().make();
    }

    public static ResidueInteractions makeAll(SimpleConfSpace confSpace, SimpleReferenceEnergies eref, boolean addResEntropy, RCTuple frag) {
        ResidueInteractions inters = EnergyPartition.makeFragment(confSpace, eref, addResEntropy, frag);
        inters.addAll(EnergyPartition.makeShell(confSpace));
        return inters;
    }

    public static double getResEntropy(SimpleConfSpace confSpace, int pos, int rc) {
        ResidueTemplate template = confSpace.positions.get((int)pos).resConfs.get((int)rc).template;
        return confSpace.positions.get((int)pos).strand.templateLib.getResEntropy(template.name);
    }
}

