/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.control.ParamSet;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import java.io.File;
import java.util.ArrayList;

public class LigandResEnergies {
    ArrayList<Residue> ligandRes;
    ArrayList<Residue> targetRes;

    public LigandResEnergies(ParamSet params) {
        Molecule mol = new Strand.Builder((Molecule)PDBIO.readFile((File)params.getFile((String)"pdbName"))).build().mol;
        String[] ligandTermini = new String[]{params.getValue("ligandStart"), params.getValue("ligandEnd")};
        String[] targetTermini = new String[]{params.getValue("targetStart"), params.getValue("targetEnd")};
        this.ligandRes = mol.resListFromTermini(ligandTermini, null);
        this.targetRes = mol.resListFromTermini(targetTermini, null);
    }

    public void printEnergies() {
        System.out.println("PRINTING LIGAND RESIDUE ENERGIES");
        System.out.println("RES ENERGY");
        for (Residue res : this.ligandRes) {
            double E = this.calcLigandResEnergy(res);
            System.out.println(res.getPDBResNumber() + " " + E);
        }
    }

    public double calcLigandResEnergy(Residue res) {
        double E = 0.0;
        for (Residue tres : this.targetRes) {
            EnergyFunction pairEFunc = EnvironmentVars.curEFcnGenerator.resPairEnergy(res, tres);
            double pairE = pairEFunc.getEnergy();
            E += pairE;
        }
        return E;
    }
}

