/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.compiled;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.compiled.AssignedCoords;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.PosInter;
import edu.duke.cs.osprey.energy.compiled.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.EnergyCalculator;
import edu.duke.cs.osprey.gpu.Precision;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.minimization.SimpleCCDMinimizer;
import java.util.List;
import java.util.Set;

public class CPUConfEnergyCalculator
implements ConfEnergyCalculator {
    public final ConfSpace confSpace;

    public CPUConfEnergyCalculator(ConfSpace confSpace) {
        this.confSpace = confSpace;
    }

    @Override
    public void close() {
    }

    @Override
    public ConfSpace confSpace() {
        return this.confSpace;
    }

    @Override
    public Precision precision() {
        return Precision.Float64;
    }

    @Override
    public ConfEnergyCalculator.EnergiedCoords calc(int[] conf, List<PosInter> inters) {
        AssignedCoords coords = this.confSpace.makeCoords(conf);
        double energy = this.calcEnergy(coords, inters);
        return new ConfEnergyCalculator.EnergiedCoords(coords, energy);
    }

    public double calcEnergy(AssignedCoords coords, List<PosInter> inters) {
        double energy = 0.0;
        for (PosInter inter : inters) {
            for (EnergyCalculator ecalc : this.confSpace.ecalcs) {
                energy += ecalc.calcEnergy(coords, inter);
            }
            energy += inter.weight * inter.offset;
        }
        return energy;
    }

    public double calcSubEnergy(AssignedCoords coords, List<PosInter> inters, Set<Integer> posIndices) {
        double energy = 0.0;
        for (PosInter inter : inters) {
            if (!inter.isIncludedIn(posIndices)) continue;
            for (EnergyCalculator ecalc : this.confSpace.ecalcs) {
                energy += ecalc.calcEnergy(coords, inter);
            }
            energy += inter.weight * inter.offset;
        }
        return energy;
    }

    @Override
    public ConfEnergyCalculator.EnergiedCoords minimize(int[] conf, final List<PosInter> inters) {
        final AssignedCoords coords = this.confSpace.makeCoords(conf);
        ObjectiveFunction f = new ObjectiveFunction(){

            @Override
            public int getNumDOFs() {
                return coords.dofs.size();
            }

            @Override
            public DoubleMatrix1D[] getConstraints() {
                int n = coords.dofs.size();
                DoubleMatrix1D mins = DoubleFactory1D.dense.make(n);
                DoubleMatrix1D maxs = DoubleFactory1D.dense.make(n);
                for (int d = 0; d < n; ++d) {
                    mins.set(d, coords.dofs.get(d).min());
                    maxs.set(d, coords.dofs.get(d).max());
                }
                return new DoubleMatrix1D[]{mins, maxs};
            }

            @Override
            public void setDOFs(DoubleMatrix1D x) {
                int n = coords.dofs.size();
                for (int d = 0; d < n; ++d) {
                    coords.dofs.get(d).set(x.get(d));
                }
            }

            @Override
            public void setDOF(int dof, double val) {
                coords.dofs.get(dof).set(val);
            }

            @Override
            public double getValue(DoubleMatrix1D x) {
                this.setDOFs(x);
                return CPUConfEnergyCalculator.this.calcEnergy(coords, (List<PosInter>)inters);
            }

            @Override
            public double getValForDOF(int dof, double val) {
                this.setDOF(dof, val);
                return CPUConfEnergyCalculator.this.calcSubEnergy(coords, inters, coords.dofs.get(dof).modifiedPosIndices());
            }

            @Override
            public double getInitStepSize(int dof) {
                return coords.dofs.get(dof).initialStepSize();
            }
        };
        Minimizer.Result result = new SimpleCCDMinimizer(f).minimizeFromCenter();
        return new ConfEnergyCalculator.EnergiedCoords(coords, result.energy, result.dofValues);
    }
}

