/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.compiled;

import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.compiled.AssignedCoords;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.PosInter;
import edu.duke.cs.osprey.energy.compiled.CPUConfEnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.CudaConfEnergyCalculator;
import edu.duke.cs.osprey.gpu.Precision;
import java.util.List;

public interface ConfEnergyCalculator
extends AutoCloseable {
    @Override
    public void close();

    public ConfSpace confSpace();

    public Precision precision();

    public EnergiedCoords calc(int[] var1, List<PosInter> var2);

    public EnergiedCoords minimize(int[] var1, List<PosInter> var2);

    default public double calcEnergy(int[] conf, List<PosInter> inters) {
        return this.calc((int[])conf, inters).energy;
    }

    default public double minimizeEnergy(int[] conf, List<PosInter> inters) {
        return this.minimize((int[])conf, inters).energy;
    }

    default public void minimizeEnergies(List<MinimizationJob> jobs) {
        for (MinimizationJob job : jobs) {
            job.energy = this.minimizeEnergy(job.conf, job.inters);
        }
    }

    default public int maxBatchSize() {
        return 1;
    }

    default public double calcOrMinimizeEnergy(int[] conf, List<PosInter> inters, boolean minimize2) {
        if (minimize2) {
            return this.minimizeEnergy(conf, inters);
        }
        return this.calcEnergy(conf, inters);
    }

    default public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf, List<PosInter> inters) {
        return new ConfSearch.EnergiedConf(conf, this.calcEnergy(conf.getAssignments(), inters));
    }

    default public ConfSearch.EnergiedConf minimizeEnergy(ConfSearch.ScoredConf conf, List<PosInter> inters) {
        return new ConfSearch.EnergiedConf(conf, this.minimizeEnergy(conf.getAssignments(), inters));
    }

    public static ConfEnergyCalculator makeBest(ConfSpace confSpace, Precision precision) {
        if (CudaConfEnergyCalculator.isSupported()) {
            return new CudaConfEnergyCalculator(confSpace, precision);
        }
        return new CPUConfEnergyCalculator(confSpace);
    }

    public static ConfEnergyCalculator makeBest(ConfSpace confSpace) {
        return ConfEnergyCalculator.makeBest(confSpace, Precision.Float64);
    }

    public static class EnergiedCoords {
        public final AssignedCoords coords;
        public final double energy;
        public final DoubleMatrix1D dofValues;

        public EnergiedCoords(AssignedCoords coords, double energy, DoubleMatrix1D dofValues) {
            this.coords = coords;
            this.energy = energy;
            this.dofValues = dofValues;
        }

        public EnergiedCoords(AssignedCoords coords, double energy) {
            this(coords, energy, null);
        }
    }

    public static class MinimizationJob {
        public final int[] conf;
        public final List<PosInter> inters;
        public double energy;

        public MinimizationJob(int[] conf, List<PosInter> inters) {
            this.conf = conf;
            this.inters = inters;
            this.energy = Double.NaN;
        }
    }
}

