/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.compiled;

import edu.duke.cs.osprey.tools.HashCalculator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class ForcefieldDebugger {
    public static final ForcefieldDebugger instance = new ForcefieldDebugger();
    private Map<AtomPair, Internal> internals = new HashMap<AtomPair, Internal>();
    private Map<AtomPair, Interaction> interactions = new HashMap<AtomPair, Interaction>();

    public void addInternal(String idA, String idB, String type, double energy) {
        this.internals.computeIfAbsent(new AtomPair(idA, idB), key -> new Internal((AtomPair)key)).add(type, energy);
    }

    public void addInteractionCoords(AtomPair atomPair, String type, Coords coords) {
        this.interactions.computeIfAbsent(atomPair, key -> new Interaction(atomPair)).addCoords(type, coords);
    }

    public void addInteractionEnergy(AtomPair atomPair, String type, double energy) {
        this.interactions.computeIfAbsent(atomPair, key -> new Interaction(atomPair)).addEnergy(type, energy);
    }

    public void clear() {
        this.internals.clear();
        this.interactions.clear();
    }

    public void dump(File file) {
        try (FileWriter out = new FileWriter(file);){
            Consumer<String> write = val -> {
                try {
                    out.write((String)val);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            };
            write.accept(String.format("Internals: %d\n", this.internals.size()));
            this.forEachOrdered(this.internals, (key, internal) -> {
                if (internal.energies.values().stream().anyMatch(v -> v != 0.0)) {
                    write.accept(String.format("%8s - %-8s", key.min(), key.max()));
                    this.forEachOrdered(internal.energies, (type, energy) -> write.accept(String.format(" %8s %7.4f", type, energy)));
                    write.accept("\n");
                }
            });
            write.accept(String.format("Interactions: %d\n", this.interactions.size()));
            this.forEachOrdered(this.interactions, (key, inter) -> {
                if (inter.energies.values().stream().anyMatch(v -> v != 0.0)) {
                    write.accept(String.format("%8s - %-8s", key.min(), key.max()));
                    this.forEachOrdered(inter.coords, (type, coords) -> write.accept(String.format(" %8s (%.3f,%.3f,%.3f) (%.3f,%.3f,%.3f) r=%10.6f", type, coords.a.x, coords.a.y, coords.a.z, coords.b.x, coords.b.y, coords.b.z, coords.r)));
                    this.forEachOrdered(inter.energies, (type, energy) -> write.accept(String.format(" %8s e=%7.4f", type, energy)));
                    write.accept("\n");
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private <K extends Comparable<K>, V> void forEachOrdered(Map<K, V> map, BiConsumer<K, V> block) {
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> block.accept((Comparable)entry.getKey(), entry.getValue()));
    }

    public static class AtomPair
    implements Comparable<AtomPair> {
        final String a;
        final String b;

        public AtomPair(String a, String b) {
            this.a = a;
            this.b = b;
        }

        String min() {
            return this.a.compareTo(this.b) <= 0 ? this.a : this.b;
        }

        String max() {
            return this.a.compareTo(this.b) <= 0 ? this.b : this.a;
        }

        public int hashCode() {
            return HashCalculator.combineHashesCommutative(this.a.hashCode(), this.b.hashCode());
        }

        public boolean equals(Object other) {
            return other instanceof AtomPair && this.equals((AtomPair)other);
        }

        public boolean equals(AtomPair other) {
            return this.a.equals(other.a) && this.b.equals(other.b) || this.a.equals(other.b) && this.b.equals(other.a);
        }

        public String toString() {
            return String.format("%s-%s", this.min(), this.max());
        }

        @Override
        public int compareTo(AtomPair other) {
            return this.toString().compareTo(other.toString());
        }
    }

    private static class Internal {
        final AtomPair key;
        final Map<String, Double> energies = new HashMap<String, Double>();

        Internal(AtomPair key) {
            this.key = key;
        }

        void add(String type, double energy) {
            if (this.energies.containsKey(type)) {
                throw new IllegalArgumentException(String.format("already have internal energy for %s, %s", this.key, type));
            }
            this.energies.put(type, energy);
        }
    }

    private static class Interaction {
        final AtomPair atomPair;
        final Map<String, Coords> coords = new HashMap<String, Coords>();
        final Map<String, Double> energies = new HashMap<String, Double>();

        Interaction(AtomPair atomPair) {
            this.atomPair = atomPair;
        }

        void addCoords(String type, Coords coords) {
            if (this.coords.containsKey(type)) {
                throw new IllegalArgumentException(String.format("already have interaction coords for %s, %s, can't add more", this.atomPair, type));
            }
            this.coords.put(type, coords);
        }

        void addEnergy(String type, double energy) {
            if (this.energies.containsKey(type)) {
                throw new IllegalArgumentException(String.format("already have interaction energy for %s, %s = %f, can't add %f", this.atomPair, type, this.energies.get(type), energy));
            }
            this.energies.put(type, energy);
        }
    }

    public static class Coords {
        public final Vector3d a;
        public final Vector3d b;
        public final double r;

        public Coords(Vector3d a, Vector3d b, double r) {
            this.a = new Vector3d((Vector3dc)a);
            this.b = new Vector3d((Vector3dc)b);
            this.r = r;
        }

        public Coords(double x1, double y1, double z1, double x2, double y2, double z2, double r) {
            this.a = new Vector3d(x1, y1, z1);
            this.b = new Vector3d(x2, y2, z2);
            this.r = r;
        }
    }
}

