/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.forcefield.EEF1;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldInteractions;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.gpu.BufferTools;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.AtomNeighbors;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BigForcefieldEnergy
implements EnergyFunction.DecomposableByDof,
EnergyFunction.ExplicitChemicalChanges {
    private static final long serialVersionUID = 5242606861996508290L;
    private ParamInfo pinfo;
    private ForcefieldInteractions interactions;
    private BufferTools.Type bufferType;
    private Groups groups;
    private int groupsSequenceNumber;
    private int[] atomOffsets;
    private DoubleBuffer coords;
    private IntBuffer atomFlags;
    private DoubleBuffer precomputed;
    private Subset fullSubset;
    private Map<Residue, Subset> subsetCache;

    public BigForcefieldEnergy(ForcefieldParams params, ForcefieldInteractions interactions) {
        this(params, interactions, BufferTools.Type.Normal);
    }

    public BigForcefieldEnergy(ForcefieldParams params, ForcefieldInteractions interactions, BufferTools.Type bufferType) {
        this.pinfo = new ParamInfo(params);
        this.interactions = interactions;
        this.bufferType = bufferType;
        this.groups = new Groups(interactions.size());
        for (int i = 0; i < interactions.size(); ++i) {
            this.groups.addPair(i, new GroupPair(this.pinfo, ((ForcefieldInteractions.AtomGroup[])interactions.get(i))[0], ((ForcefieldInteractions.AtomGroup[])interactions.get(i))[1]));
        }
        this.build();
        this.fullSubset = new Subset(interactions, false);
        this.subsetCache = new HashMap<Residue, Subset>();
    }

    private void build() {
        this.groupsSequenceNumber = this.groups.handleChemicalChanges();
        int numAtoms = 0;
        this.atomOffsets = new int[this.groups.getNumGroups()];
        for (int i = 0; i < this.groups.getNumGroups(); ++i) {
            ForcefieldInteractions.AtomGroup group = this.groups.get(i);
            this.atomOffsets[i] = numAtoms;
            numAtoms += group.getAtoms().size();
        }
        this.coords = this.makeOrResizeBuffer(this.coords, numAtoms * 3);
        int numAtomPairs = 0;
        for (int groupPairIndex = 0; groupPairIndex < this.groups.getNumGroupPairs(); ++groupPairIndex) {
            numAtomPairs += this.groups.getPair(groupPairIndex).getNumAtomPairs();
        }
        long bufferSize = (long)numAtomPairs * 9L;
        if (bufferSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many atom pairs, can't allocate large enough buffer");
        }
        this.atomFlags = this.makeOrResizeBuffer(this.atomFlags, numAtomPairs * 2);
        this.precomputed = this.makeOrResizeBuffer(this.precomputed, numAtomPairs * 9);
        int atomPairOffset = 0;
        for (AtomNeighbors.Type type : Arrays.asList(AtomNeighbors.Type.BONDED14, AtomNeighbors.Type.NONBONDED)) {
            for (int groupPairIndex = 0; groupPairIndex < this.interactions.size(); ++groupPairIndex) {
                GroupPair groupPair = this.groups.getPair(groupPairIndex);
                GroupPair.Entry entry = groupPair.get(type);
                int group1Index = this.groups.getGroup1Index(groupPairIndex);
                int group2Index = this.groups.getGroup2Index(groupPairIndex);
                entry.atomPairOffset = atomPairOffset;
                atomPairOffset += entry.atomPairs.size();
                for (int atomPairIndex = 0; atomPairIndex < entry.atomPairs.size(); ++atomPairIndex) {
                    int[] atomIndices = entry.atomPairs.get(atomPairIndex);
                    int atom1Index = this.getGlobalAtomIndex(group1Index, atomIndices[0]);
                    int atom2Index = this.getGlobalAtomIndex(group2Index, atomIndices[1]);
                    this.atomFlags.put(this.packFlags(atom1Index, entry.isHydrogen1(atomPairIndex)));
                    this.atomFlags.put(this.packFlags(atom2Index, entry.isHydrogen2(atomPairIndex)));
                }
                this.precomputed.put(entry.precomputed);
            }
        }
        assert (this.atomFlags.position() == numAtomPairs * 2);
        assert (this.precomputed.position() == numAtomPairs * 9);
        this.atomFlags.flip();
        this.precomputed.flip();
    }

    private DoubleBuffer makeOrResizeBuffer(DoubleBuffer buf, int size) {
        if (buf == null || buf.capacity() < size) {
            buf = this.bufferType.makeDouble(size);
        } else {
            buf.clear();
        }
        assert (buf.capacity() >= size);
        return buf;
    }

    private IntBuffer makeOrResizeBuffer(IntBuffer buf, int size) {
        if (buf == null || buf.capacity() < size) {
            buf = this.bufferType.makeInt(size);
        } else {
            buf.clear();
        }
        assert (buf.capacity() >= size);
        return buf;
    }

    public ParamInfo getParams() {
        return this.pinfo;
    }

    public ForcefieldInteractions getInteractions() {
        return this.interactions;
    }

    public DoubleBuffer getCoords() {
        return this.coords;
    }

    public int getAtomOffset(Residue res) {
        return this.getAtomOffset(this.interactions.getResidueAtomGroup(res));
    }

    public int getAtomOffset(ForcefieldInteractions.AtomGroup group) {
        Integer groupIndex = this.groups.getGroupIndex(group);
        if (groupIndex == null) {
            throw new IllegalArgumentException("group not found");
        }
        return this.getGlobalAtomIndex(groupIndex, 0);
    }

    public IntBuffer getAtomFlags() {
        return this.atomFlags;
    }

    public DoubleBuffer getPrecomputed() {
        return this.precomputed;
    }

    public Subset getFullSubset() {
        return this.fullSubset;
    }

    @Override
    public int handleChemicalChanges() {
        return this.fullSubset.handleChemicalChanges();
    }

    private int handleChemicalChangesInternal() {
        int seq = this.groups.handleChemicalChanges();
        if (seq != this.groupsSequenceNumber) {
            this.groupsSequenceNumber = seq;
            this.build();
        }
        return seq;
    }

    public void updateCoords() {
        this.handleChemicalChanges();
        this.coords.rewind();
        for (int i = 0; i < this.groups.getNumGroups(); ++i) {
            ForcefieldInteractions.AtomGroup group = this.groups.get(i);
            this.coords.put(group.getCoords());
        }
    }

    @Override
    public double getEnergy() {
        return this.fullSubset.getEnergy();
    }

    @Override
    public List<EnergyFunction> decomposeByDof(Molecule m, List<DegreeOfFreedom> dofs) {
        ArrayList<EnergyFunction> efuncs = new ArrayList<EnergyFunction>();
        for (DegreeOfFreedom dof : dofs) {
            Residue res = dof.getResidue();
            if (res == null) {
                efuncs.add(this);
                continue;
            }
            Subset efunc = this.subsetCache.get(res);
            if (efunc == null) {
                efunc = new Subset(this.interactions.makeSubsetByResidue(res));
                this.subsetCache.put(res, efunc);
            }
            efuncs.add(efunc);
        }
        return efuncs;
    }

    private static void calcVdw(ForcefieldParams.NBParams nbparams1, ForcefieldParams.NBParams nbparams2, double Amult, double Bmult, VdwParams vdwparams) {
        double epsilon = Math.sqrt(nbparams1.epsilon * nbparams2.epsilon);
        double radiusSum = nbparams1.r + nbparams2.r;
        vdwparams.Bij = radiusSum * radiusSum;
        vdwparams.Bij = vdwparams.Bij * vdwparams.Bij * vdwparams.Bij;
        vdwparams.Aij = vdwparams.Bij * vdwparams.Bij;
        vdwparams.Aij *= epsilon * Amult;
        vdwparams.Bij *= epsilon * Bmult;
    }

    private int getGlobalAtomIndex(int groupIndex, int atomIndexInGroup) {
        return this.atomOffsets[groupIndex] + atomIndexInGroup;
    }

    private int packFlags(int atomIndex, boolean isHydrogen) {
        if (atomIndex == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Really?? We have billions of atoms??");
        }
        ++atomIndex;
        if (isHydrogen) {
            return atomIndex;
        }
        return -atomIndex;
    }

    private int unpackAtomIndex(int flags) {
        assert (flags != 0);
        return Math.abs(flags) - 1;
    }

    private boolean unpackIsHydrogen(int flags) {
        assert (flags != 0);
        return flags > 0;
    }

    public static class ParamInfo {
        public static boolean printWarnings = true;
        private static final double coulombConstant = 332.0;
        private static final double solvCutoff = 9.0;
        public final ForcefieldParams params;
        public final double Bmult;
        public final double Amult;
        public final double solvCoeff;
        public final double coulombFactor;
        public final double scaledCoulombFactor;
        public final double solvationCutoff2;
        public final boolean useDistDependentDielectric;
        public final boolean useHElectrostatics;
        public final boolean useHVdw;
        public final boolean useEEF1;

        public ParamInfo(ForcefieldParams params) {
            this.params = params;
            double vdw2 = params.vdwMultiplier * params.vdwMultiplier;
            this.Bmult = vdw2 * vdw2 * vdw2;
            this.Amult = this.Bmult * this.Bmult;
            this.solvCoeff = 2.0 / (Math.PI * 4 * Math.sqrt(Math.PI)) * params.solvScale;
            this.coulombFactor = 332.0 / params.dielectric;
            this.scaledCoulombFactor = this.coulombFactor * params.forcefld.coulombScaling;
            this.solvationCutoff2 = 81.0;
            this.useDistDependentDielectric = params.distDepDielect;
            this.useHElectrostatics = params.hElect;
            this.useHVdw = params.hVDW;
            this.useEEF1 = params.solvationForcefield == ForcefieldParams.SolvationForcefield.EEF1;
        }
    }

    private class Groups {
        private List<ForcefieldInteractions.AtomGroup> groups = new ArrayList<ForcefieldInteractions.AtomGroup>();
        private int sequenceNumber = 0;
        private Map<Integer, Integer> groupIndicesById = new HashMap<Integer, Integer>();
        private int[] groupIndicesByPair;
        private GroupPair[] pairs;
        private Map<Integer, Integer> pairIndicesByIds;

        public Groups(int numPairs) {
            this.groupIndicesByPair = new int[numPairs * 2];
            this.pairs = new GroupPair[numPairs];
            this.pairIndicesByIds = new HashMap<Integer, Integer>();
        }

        public void addPair(int pairIndex, GroupPair pair) {
            boolean wasAdded;
            this.groupIndicesByPair[pairIndex * 2 + 0] = this.addOrGetGroupIndex(pair.group1);
            this.groupIndicesByPair[pairIndex * 2 + 1] = this.addOrGetGroupIndex(pair.group2);
            this.pairs[pairIndex] = pair;
            boolean bl = wasAdded = this.pairIndicesByIds.put(this.makePairKey(pair.group1, pair.group2), pairIndex) == null;
            if (!wasAdded) {
                throw new IllegalArgumentException("group pair was already added, can't add again");
            }
        }

        public int getNumGroupPairs() {
            return this.pairs.length;
        }

        public GroupPair getPair(int pairIndex) {
            return this.pairs[pairIndex];
        }

        public GroupPair getPair(ForcefieldInteractions.AtomGroup[] groupPair) {
            int key = this.makePairKey(groupPair[0], groupPair[1]);
            Integer pairIndex = this.pairIndicesByIds.get(key);
            if (pairIndex == null) {
                throw new IllegalArgumentException("group pair not found in this forcefield");
            }
            return this.getPair(pairIndex);
        }

        private int makePairKey(ForcefieldInteractions.AtomGroup group1, ForcefieldInteractions.AtomGroup group2) {
            this.checkId(group1.getId());
            this.checkId(group2.getId());
            return group1.getId() << 16 | group2.getId();
        }

        private void checkId(int id) {
            if (id < 0 | id > Short.MAX_VALUE) {
                throw new IllegalArgumentException("group id " + id + " out of range [0,32767]");
            }
        }

        public Integer getGroupIndex(ForcefieldInteractions.AtomGroup group) {
            return this.groupIndicesById.get(group.getId());
        }

        private int addOrGetGroupIndex(ForcefieldInteractions.AtomGroup group) {
            Integer groupIndex = this.getGroupIndex(group);
            if (groupIndex != null) {
                return groupIndex;
            }
            groupIndex = this.groups.size();
            this.groups.add(group);
            this.groupIndicesById.put(group.getId(), groupIndex);
            return groupIndex;
        }

        public int getNumGroups() {
            return this.groups.size();
        }

        public ForcefieldInteractions.AtomGroup get(int index) {
            return this.groups.get(index);
        }

        public int handleChemicalChanges() {
            boolean hasChange = false;
            for (GroupPair pair : this.pairs) {
                hasChange |= pair.handleChemicalChanges(BigForcefieldEnergy.this.pinfo);
            }
            if (hasChange) {
                ++this.sequenceNumber;
            }
            return this.sequenceNumber;
        }

        public int getGroup1Index(int pairIndex) {
            return this.groupIndicesByPair[pairIndex * 2 + 0];
        }

        public int getGroup2Index(int pairIndex) {
            return this.groupIndicesByPair[pairIndex * 2 + 1];
        }

        public List<GroupPair> match(ForcefieldInteractions interactions) {
            ArrayList<GroupPair> groupPairs = new ArrayList<GroupPair>();
            for (int groupPairIndex = 0; groupPairIndex < interactions.size(); ++groupPairIndex) {
                groupPairs.add(this.getPair((ForcefieldInteractions.AtomGroup[])interactions.get(groupPairIndex)));
            }
            return groupPairs;
        }
    }

    private static class GroupPair {
        private ForcefieldInteractions.AtomGroup group1;
        private ForcefieldInteractions.AtomGroup group2;
        private int sequenceNumber1;
        private int sequenceNumber2;
        private Map<AtomNeighbors.Type, Entry> entries;
        private double internalSolvEnergy;

        public GroupPair(ParamInfo pinfo, ForcefieldInteractions.AtomGroup group1, ForcefieldInteractions.AtomGroup group2) {
            this.group1 = group1;
            this.group2 = group2;
            this.entries = new EnumMap<AtomNeighbors.Type, Entry>(AtomNeighbors.Type.class);
            this.build(pinfo);
        }

        public Entry get(AtomNeighbors.Type type) {
            return this.entries.get((Object)type);
        }

        public int getNumAtomPairs() {
            int count = 0;
            for (Entry entry : this.entries.values()) {
                count += entry.atomPairs.size();
            }
            return count;
        }

        public double getInternalSolvationEnergy() {
            return this.internalSolvEnergy;
        }

        public boolean handleChemicalChanges(ParamInfo pinfo) {
            if (this.group1.getSequenceNumber() == this.sequenceNumber1 && this.group2.getSequenceNumber() == this.sequenceNumber2) {
                return false;
            }
            this.build(pinfo);
            return true;
        }

        public void build(ParamInfo pinfo) {
            this.entries.clear();
            for (AtomNeighbors.Type type : Arrays.asList(AtomNeighbors.Type.BONDED14, AtomNeighbors.Type.NONBONDED)) {
                this.entries.put(type, this.build(pinfo, type));
            }
            this.internalSolvEnergy = 0.0;
            if (pinfo.useEEF1) {
                EEF1.SolvParams solvparams = new EEF1.SolvParams();
                if (this.group1 == this.group2) {
                    for (Atom atom : this.group1.getAtoms()) {
                        if (atom.isHydrogen()) continue;
                        pinfo.params.eef1parms.getSolvationParametersOrDefaults(atom, solvparams);
                        this.internalSolvEnergy += solvparams.dGref;
                    }
                }
                this.internalSolvEnergy *= pinfo.params.solvScale;
            }
            this.sequenceNumber1 = this.group1.getSequenceNumber();
            this.sequenceNumber2 = this.group2.getSequenceNumber();
        }

        private Entry build(ParamInfo pinfo, AtomNeighbors.Type type) {
            List<int[]> atomPairs = AtomNeighbors.getPairIndicesByType(this.group1.getAtoms(), this.group2.getAtoms(), this.group1 == this.group2, type);
            ForcefieldParams.NBParams nbparams1 = new ForcefieldParams.NBParams();
            ForcefieldParams.NBParams nbparams2 = new ForcefieldParams.NBParams();
            VdwParams vdwparams = new VdwParams();
            EEF1.SolvParams solvparams1 = new EEF1.SolvParams();
            EEF1.SolvParams solvparams2 = new EEF1.SolvParams();
            Entry entry = new Entry(atomPairs);
            for (int i = 0; i < atomPairs.size(); ++i) {
                int[] atomIndices = atomPairs.get(i);
                Atom atom1 = this.group1.getAtoms().get(atomIndices[0]);
                Atom atom2 = this.group2.getAtoms().get(atomIndices[1]);
                entry.addFlags(i, atom1.isHydrogen(), atom2.isHydrogen());
                pinfo.params.getNonBondedParametersOrThrow(atom1, type, nbparams1);
                pinfo.params.getNonBondedParametersOrThrow(atom2, type, nbparams2);
                BigForcefieldEnergy.calcVdw(nbparams1, nbparams2, pinfo.Amult, pinfo.Bmult, vdwparams);
                if (type == AtomNeighbors.Type.BONDED14) {
                    vdwparams.Aij *= pinfo.params.forcefld.Aij14Factor;
                    vdwparams.Bij *= pinfo.params.forcefld.Bij14Factor;
                } else if (type == AtomNeighbors.Type.NONBONDED) {
                    vdwparams.Bij *= 2.0;
                }
                if (!atom1.isHydrogen() && !atom2.isHydrogen()) {
                    pinfo.params.eef1parms.getSolvationParametersOrDefaults(atom1, solvparams1);
                    pinfo.params.eef1parms.getSolvationParametersOrDefaults(atom2, solvparams2);
                    double alpha1 = pinfo.solvCoeff * solvparams1.dGfree * solvparams2.volume / solvparams1.lambda;
                    double alpha2 = pinfo.solvCoeff * solvparams2.dGfree * solvparams1.volume / solvparams2.lambda;
                    entry.addPrecomputed(i, vdwparams.Aij, vdwparams.Bij, atom1.charge * atom2.charge, solvparams1.lambda, solvparams1.radius, alpha1, solvparams2.lambda, solvparams2.radius, alpha2);
                    continue;
                }
                entry.addPrecomputed(i, vdwparams.Aij, vdwparams.Bij, atom1.charge * atom2.charge, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            return entry;
        }

        private static class Entry {
            private static final int NumFlagsPerPair = 2;
            private static final int NumPrecomputedPerPair = 9;
            public final List<int[]> atomPairs;
            public final boolean[] flags;
            public final double[] precomputed;
            public int atomPairOffset;

            public Entry(List<int[]> atomPairs) {
                this.atomPairs = atomPairs;
                this.flags = new boolean[atomPairs.size() * 2];
                this.precomputed = new double[atomPairs.size() * 9];
                this.atomPairOffset = -1;
            }

            public void addFlags(int pairIndex, boolean isHydrogen1, boolean isHydrogen2) {
                int i = pairIndex * 2;
                this.flags[i++] = isHydrogen1;
                this.flags[i++] = isHydrogen2;
            }

            public void addPrecomputed(int pairIndex, double Aij, double Bij, double charge, double lambda1, double radius1, double alpha1, double lambda2, double radius2, double alpha2) {
                int i = pairIndex * 9;
                this.precomputed[i++] = Aij;
                this.precomputed[i++] = Bij;
                this.precomputed[i++] = charge;
                this.precomputed[i++] = lambda1;
                this.precomputed[i++] = radius1;
                this.precomputed[i++] = alpha1;
                this.precomputed[i++] = lambda2;
                this.precomputed[i++] = radius2;
                this.precomputed[i++] = alpha2;
            }

            public boolean isHydrogen1(int pairIndex) {
                return this.flags[pairIndex * 2];
            }

            public boolean isHydrogen2(int pairIndex) {
                return this.flags[pairIndex * 2 + 1];
            }
        }
    }

    public class Subset
    implements EnergyFunction.ExplicitChemicalChanges {
        private static final long serialVersionUID = -2038116438543332018L;
        private boolean makeTable;
        private List<GroupPair> groupPairs;
        private int sequenceNumber;
        private int numPairs;
        private int num14Pairs;
        private double internalSolvEnergy;
        private IntBuffer subsetTable;

        public Subset(ForcefieldInteractions interactions) {
            this(interactions, true);
        }

        public Subset(ForcefieldInteractions interactions, boolean makeTable) {
            this.makeTable = makeTable;
            this.groupPairs = BigForcefieldEnergy.this.groups.match(interactions);
            this.build();
        }

        private void build() {
            this.numPairs = 0;
            this.num14Pairs = 0;
            this.internalSolvEnergy = 0.0;
            for (GroupPair pair : this.groupPairs) {
                this.numPairs += pair.getNumAtomPairs();
                this.num14Pairs += pair.get((AtomNeighbors.Type)AtomNeighbors.Type.BONDED14).atomPairs.size();
                this.internalSolvEnergy += pair.getInternalSolvationEnergy();
            }
            if (this.makeTable) {
                this.subsetTable = BigForcefieldEnergy.this.makeOrResizeBuffer(this.subsetTable, this.numPairs);
                for (AtomNeighbors.Type type : Arrays.asList(AtomNeighbors.Type.BONDED14, AtomNeighbors.Type.NONBONDED)) {
                    for (GroupPair pair : this.groupPairs) {
                        GroupPair.Entry entry = pair.get(type);
                        for (int i = 0; i < entry.atomPairs.size(); ++i) {
                            this.subsetTable.put(entry.atomPairOffset + i);
                        }
                    }
                }
                this.subsetTable.flip();
            }
        }

        public IntBuffer getSubsetTable() {
            return this.subsetTable;
        }

        public int getNumAtomPairs() {
            return this.numPairs;
        }

        public int getNum14AtomPairs() {
            return this.num14Pairs;
        }

        public double getInternalSolvationEnergy() {
            return this.internalSolvEnergy;
        }

        public boolean isBroken() {
            for (GroupPair pair : this.groupPairs) {
                if (!pair.group1.isBroken() && !pair.group2.isBroken()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int handleChemicalChanges() {
            int seq = BigForcefieldEnergy.this.handleChemicalChangesInternal();
            if (this.sequenceNumber != seq) {
                this.sequenceNumber = seq;
                this.build();
            }
            return seq;
        }

        @Override
        public double getEnergy() {
            this.handleChemicalChanges();
            BigForcefieldEnergy.this.updateCoords();
            if (this.isBroken()) {
                return Double.POSITIVE_INFINITY;
            }
            IntBuffer subsetTable = this.subsetTable;
            int num14Pairs = this.num14Pairs;
            int numAtomPairs = this.numPairs;
            boolean distDepDielect = BigForcefieldEnergy.this.pinfo.useDistDependentDielectric;
            boolean useHEs = BigForcefieldEnergy.this.pinfo.useHElectrostatics;
            boolean useHVdw = BigForcefieldEnergy.this.pinfo.useHVdw;
            IntBuffer atomFlags = BigForcefieldEnergy.this.atomFlags;
            DoubleBuffer precomputed = BigForcefieldEnergy.this.precomputed;
            double coulombFactor = BigForcefieldEnergy.this.pinfo.coulombFactor;
            double scaledCoulombFactor = BigForcefieldEnergy.this.pinfo.scaledCoulombFactor;
            double solvCutoff2 = BigForcefieldEnergy.this.pinfo.solvationCutoff2;
            double r = 0.0;
            double esEnergy = 0.0;
            double vdwEnergy = 0.0;
            double solvEnergy = this.internalSolvEnergy;
            for (int j = 0; j < numAtomPairs; ++j) {
                boolean inRangeForSolv;
                int i = subsetTable != null ? subsetTable.get(j) : j;
                int i2 = i * 2;
                int i9 = i * 9;
                int atom1Flags = atomFlags.get(i2);
                int atom2Flags = atomFlags.get(i2 + 1);
                int atom1Index = BigForcefieldEnergy.this.unpackAtomIndex(atom1Flags);
                int atom2Index = BigForcefieldEnergy.this.unpackAtomIndex(atom2Flags);
                boolean bothHeavy = !BigForcefieldEnergy.this.unpackIsHydrogen(atom1Flags) && !BigForcefieldEnergy.this.unpackIsHydrogen(atom2Flags);
                int atom1Index3 = atom1Index * 3;
                int atom2Index3 = atom2Index * 3;
                double d = BigForcefieldEnergy.this.coords.get(atom1Index3) - BigForcefieldEnergy.this.coords.get(atom2Index3);
                double r2 = d * d;
                d = BigForcefieldEnergy.this.coords.get(atom1Index3 + 1) - BigForcefieldEnergy.this.coords.get(atom2Index3 + 1);
                r2 += d * d;
                d = BigForcefieldEnergy.this.coords.get(atom1Index3 + 2) - BigForcefieldEnergy.this.coords.get(atom2Index3 + 2);
                boolean bl = inRangeForSolv = (r2 += d * d) < solvCutoff2;
                if (!distDepDielect || bothHeavy && inRangeForSolv) {
                    r = Math.sqrt(r2);
                }
                if (bothHeavy || useHEs) {
                    double charge = precomputed.get(i9 + 2);
                    boolean is14Pair = i < num14Pairs;
                    esEnergy += (is14Pair ? scaledCoulombFactor : coulombFactor) / (distDepDielect ? r2 : r) * charge;
                }
                if (bothHeavy || useHVdw) {
                    double Aij = precomputed.get(i9);
                    double Bij = precomputed.get(i9 + 1);
                    double r6 = r2 * r2 * r2;
                    double r12 = r6 * r6;
                    vdwEnergy += Aij / r12 - Bij / r6;
                }
                if (!BigForcefieldEnergy.this.pinfo.useEEF1 || !bothHeavy || !inRangeForSolv) continue;
                double lambda1 = precomputed.get(i9 + 3);
                double radius1 = precomputed.get(i9 + 4);
                double alpha1 = precomputed.get(i9 + 5);
                double lambda2 = precomputed.get(i9 + 6);
                double radius2 = precomputed.get(i9 + 7);
                double alpha2 = precomputed.get(i9 + 8);
                double Xij = (r - radius1) / lambda1;
                double Xji = (r - radius2) / lambda2;
                solvEnergy -= (alpha1 * Math.exp(-Xij * Xij) + alpha2 * Math.exp(-Xji * Xji)) / r2;
            }
            return esEnergy + vdwEnergy + solvEnergy;
        }
    }

    private static class VdwParams {
        public double Aij;
        public double Bij;

        private VdwParams() {
        }
    }
}

