/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.structure.Residue;
import java.io.Serializable;
import java.util.Arrays;

public class CoordsAndCharges
implements Serializable {
    private static final long serialVersionUID = 3611517841418160913L;
    public double[] data;
    public int res1Start;
    public int res2Start;
    public Residue res1;
    public Residue res2;

    public CoordsAndCharges(Residue res1, Residue res2) {
        boolean isInternal;
        boolean bl = isInternal = res1 == res2;
        if (isInternal) {
            this.data = new double[res1.atoms.size() * 4];
            this.res1Start = 0;
            this.res2Start = 0;
        } else {
            this.data = new double[(res1.atoms.size() + res2.atoms.size()) * 4];
            this.res1Start = 0;
            this.res2Start = res1.atoms.size() * 4;
        }
        this.res1 = res1;
        this.res2 = res2;
        Arrays.fill(this.data, Double.NaN);
        this.updateCharges(this.res1Start, res1);
        this.updateCharges(this.res2Start, res2);
    }

    private void updateCharges(int startIndex, Residue res) {
        for (int i = 0; i < res.atoms.size(); ++i) {
            this.data[startIndex + i * 4 + 3] = res.atoms.get((int)i).charge;
        }
    }

    public void updateCoords() {
        this.updateCoords(this.res1Start, this.res1.coords);
        this.updateCoords(this.res2Start, this.res2.coords);
    }

    private void updateCoords(int startIndex, double[] coords) {
        int ix4 = startIndex - 4;
        int ix3 = -3;
        int n = coords.length / 3;
        for (int i = 0; i < n; ++i) {
            this.data[ix4 += 4] = coords[ix3 += 3];
            this.data[ix4 + 1] = coords[ix3 + 1];
            this.data[ix4 + 2] = coords[ix3 + 2];
        }
    }
}

