/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.energy.forcefield.CoordsAndCharges;
import edu.duke.cs.osprey.energy.forcefield.EEF1;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.AtomNeighbors;
import edu.duke.cs.osprey.structure.Residue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ForcefieldEnergy
implements Serializable {
    private static final long serialVersionUID = 944833567342112297L;
    boolean isInternal;
    Residue res1;
    Residue res2;
    CoordsAndCharges coordsAndCharges;
    ForcefieldParams params;
    public static final boolean debug = false;
    final double constCoulomb = 332.0;
    int numberNonBonded = 0;
    int numberHalfNonBonded = 0;
    int numberSolvated = 0;
    double[] nonBondedTerms;
    double[] halfNonBondedTerms;
    double[] solvationTerms;
    double D2R = Math.PI / 180;
    double R2D = 57.29577951308232;
    double internalSolvEnergy = 0.0;
    final double solvCutoff = 9.0;

    public ForcefieldEnergy(boolean intra, List<Atom> atoms1, List<Atom> atoms2, ForcefieldParams params) {
        this.isInternal = intra;
        this.checkResComposition(intra, atoms1, atoms2);
        this.coordsAndCharges = new CoordsAndCharges(this.res1, this.res2);
        this.params = params;
        this.initializeCalculation(atoms1, atoms2);
    }

    public ForcefieldEnergy(List<Atom[]> atomPairs, ForcefieldParams params) {
        this.res1 = atomPairs.get((int)0)[0].res;
        this.res2 = atomPairs.get((int)0)[1].res;
        this.isInternal = this.res1 == this.res2;
        this.coordsAndCharges = new CoordsAndCharges(this.res1, this.res2);
        for (Atom[] pair : atomPairs) {
            if (pair[0].res == this.res1 && pair[1].res == this.res2) continue;
            throw new RuntimeException("ERROR: Sparse forcefield energy given atom pairs with inconsistent residues");
        }
        this.params = params;
        List<Atom[]> pairs14 = AtomNeighbors.getPairs14(atomPairs);
        List<Atom[]> pairsNonBonded = AtomNeighbors.getPairsNonBonded(atomPairs);
        this.initializeEVCalculation(pairs14, pairsNonBonded);
        if (params.solvationForcefield == ForcefieldParams.SolvationForcefield.EEF1) {
            this.initializeSolvationCalculation(pairs14, pairsNonBonded, this.isInternal);
        }
    }

    void checkResComposition(boolean intra, List<Atom> atoms1, List<Atom> atoms2) {
        if (intra) {
            this.res2 = this.res1 = atoms1.get((int)0).res;
            if (atoms1.size() != atoms2.size()) {
                throw new RuntimeException("ERROR: Atoms for intra-residue energy defined inconsistently");
            }
            for (int atNum = 0; atNum < atoms1.size(); ++atNum) {
                if (atoms1.get(atNum) != atoms2.get(atNum)) {
                    throw new RuntimeException("ERROR: Atoms for intra-residue energy defined inconsistently");
                }
                if (atoms1.get((int)atNum).res == this.res1) continue;
                throw new RuntimeException("ERROR: Can't compute intra-residue energy for list of atoms at different residues");
            }
        } else {
            this.res1 = atoms1.get((int)0).res;
            this.res2 = atoms2.get((int)0).res;
            if (this.res1 == this.res2) {
                throw new RuntimeException("ERROR: Pairwise energy must be for two different residues");
            }
            for (Atom at : atoms1) {
                if (at.res == this.res1) continue;
                throw new RuntimeException("ERROR: Pairwise energy can't have more than one residue on one side");
            }
            for (Atom at : atoms2) {
                if (at.res == this.res2) continue;
                throw new RuntimeException("ERROR: Pairwise energy can't have more than one residue on one side");
            }
        }
        if (!(this.res1.interResBondsMarked && this.res1.intraResBondsMarked && this.res2.interResBondsMarked && this.res2.intraResBondsMarked)) {
            throw new RuntimeException("ERROR: Trying to set up force field energy for a residue whose bonds haven't been marked yet");
        }
    }

    public int getNumTerms() {
        int num = this.numberNonBonded + this.numberHalfNonBonded;
        if (this.params.solvationForcefield == ForcefieldParams.SolvationForcefield.EEF1) {
            num += this.numberSolvated;
        }
        return num;
    }

    public void initializeCalculation(List<Atom> atoms1, List<Atom> atoms2) {
        List<Atom[]> pairs14 = AtomNeighbors.getPairs14(atoms1, atoms2, this.res1 == this.res2);
        List<Atom[]> pairsNonBonded = AtomNeighbors.getPairsNonBonded(atoms1, atoms2, this.res1 == this.res2);
        this.initializeEVCalculation(pairs14, pairsNonBonded);
        if (this.params.solvationForcefield == ForcefieldParams.SolvationForcefield.EEF1) {
            this.initializeSolvationCalculation(pairs14, pairsNonBonded, this.res1 == this.res2);
        }
    }

    private void initializeEVCalculation(List<Atom[]> pairs14, List<Atom[]> pairsNonBonded) {
        boolean isHydrogen2;
        boolean isHydrogen1;
        int atomType1;
        int atom1;
        ForcefieldParams.NBParams nbparams = new ForcefieldParams.NBParams();
        double Bmult = this.params.vdwMultiplier * this.params.vdwMultiplier;
        Bmult = Bmult * Bmult * Bmult;
        double Amult = Bmult * Bmult;
        int number14Connections = pairs14.size();
        this.halfNonBondedTerms = new double[number14Connections * 5];
        this.numberHalfNonBonded = 0;
        for (int i = 0; i < number14Connections; ++i) {
            atom1 = pairs14.get((int)i)[0].indexInRes;
            int atom4 = pairs14.get((int)i)[1].indexInRes;
            atomType1 = this.res1.atoms.get((int)atom1).type;
            int atomType4 = this.res2.atoms.get((int)atom4).type;
            isHydrogen1 = this.res1.atoms.get((int)atom1).elementType.equalsIgnoreCase("H");
            isHydrogen2 = this.res2.atoms.get((int)atom4).elementType.equalsIgnoreCase("H");
            double epsilonProduct = 0.0;
            double ri = 0.0;
            double rj = 0.0;
            if (!this.params.getNonBondedParameters(this.res1.atoms.get(atom1), nbparams)) {
                System.out.println("WARNING: Could not find nb parameters for " + atom1 + " type: " + this.res1.atoms.get((int)atom1).forceFieldType);
                continue;
            }
            if ((this.params.forcefld == ForcefieldParams.Forcefield.CHARMM19 || this.params.forcefld == ForcefieldParams.Forcefield.CHARMM19NEUTRAL) && pairs14.get((int)i)[0].elementType.equalsIgnoreCase("C")) {
                epsilonProduct = 0.1;
                ri = 1.9;
            } else {
                epsilonProduct = nbparams.epsilon;
                ri = nbparams.r;
            }
            if (!this.params.getNonBondedParameters(this.res2.atoms.get(atom4), nbparams)) {
                System.out.println("WARNING: Could not find nb parameters for " + atom4 + " type: " + this.res2.atoms.get((int)atom1).forceFieldType);
                continue;
            }
            if ((this.params.forcefld == ForcefieldParams.Forcefield.CHARMM19 || this.params.forcefld == ForcefieldParams.Forcefield.CHARMM19NEUTRAL) && pairs14.get((int)i)[0].elementType.equalsIgnoreCase("C")) {
                epsilonProduct *= 0.1;
                rj = 1.9;
            } else {
                epsilonProduct *= nbparams.epsilon;
                rj = nbparams.r;
            }
            epsilonProduct = Math.sqrt(epsilonProduct);
            double Bij = (ri + rj) * (ri + rj);
            Bij = Bij * Bij * Bij;
            double Aij = Bij * Bij;
            switch (this.params.forcefld) {
                case AMBER: {
                    Aij *= epsilonProduct * 0.5;
                    Bij *= epsilonProduct;
                    break;
                }
                case CHARMM19: 
                case CHARMM19NEUTRAL: {
                    Aij *= epsilonProduct;
                    Bij *= epsilonProduct * 2.0;
                    break;
                }
                default: {
                    throw new Error("Don't know how to handle FF " + String.valueOf((Object)this.params.forcefld));
                }
            }
            this.halfNonBondedTerms[5 * i] = atom1;
            this.halfNonBondedTerms[5 * i + 1] = atom4;
            this.halfNonBondedTerms[5 * i + 2] = isHydrogen1 || isHydrogen2 ? 1.0 : 0.0;
            this.halfNonBondedTerms[5 * i + 3] = Aij * Amult;
            this.halfNonBondedTerms[5 * i + 4] = Bij * Bmult;
            ++this.numberHalfNonBonded;
        }
        double[] smallerArray = new double[this.numberHalfNonBonded * 5];
        System.arraycopy(this.halfNonBondedTerms, 0, smallerArray, 0, this.numberHalfNonBonded * 5);
        this.halfNonBondedTerms = smallerArray;
        int numberNonBondedConnections = pairsNonBonded.size();
        this.nonBondedTerms = new double[numberNonBondedConnections * 5];
        this.numberNonBonded = 0;
        for (int i = 0; i < numberNonBondedConnections; ++i) {
            atom1 = pairsNonBonded.get((int)i)[0].indexInRes;
            int atom2 = pairsNonBonded.get((int)i)[1].indexInRes;
            atomType1 = this.res1.atoms.get((int)atom1).type;
            int atomType2 = this.res2.atoms.get((int)atom2).type;
            isHydrogen1 = this.res1.atoms.get((int)atom1).elementType.equalsIgnoreCase("H");
            isHydrogen2 = this.res2.atoms.get((int)atom2).elementType.equalsIgnoreCase("H");
            if (!this.params.getNonBondedParameters(this.res1.atoms.get(atom1), nbparams)) {
                System.out.println("WARNING: Could not find nb parameters for (at1) " + atom1 + " type: " + this.res1.atoms.get((int)atom1).forceFieldType);
                continue;
            }
            double epsilonProduct = nbparams.epsilon;
            double ri = nbparams.r;
            if (!this.params.getNonBondedParameters(this.res2.atoms.get(atom2), nbparams)) {
                System.out.println("WARNING: Could not find nb parameters for (at2) " + atom2 + " type: " + this.res2.atoms.get((int)atom2).forceFieldType);
                continue;
            }
            epsilonProduct *= nbparams.epsilon;
            double rj = nbparams.r;
            epsilonProduct = Math.sqrt(epsilonProduct);
            double Bij = (ri + rj) * (ri + rj);
            Bij = Bij * Bij * Bij;
            double Aij = Bij * Bij * epsilonProduct;
            this.nonBondedTerms[5 * i] = atom1;
            this.nonBondedTerms[5 * i + 1] = atom2;
            this.nonBondedTerms[5 * i + 2] = isHydrogen1 || isHydrogen2 ? 1.0 : 0.0;
            this.nonBondedTerms[5 * i + 3] = Aij * Amult;
            this.nonBondedTerms[5 * i + 4] = (Bij *= epsilonProduct * 2.0) * Bmult;
            ++this.numberNonBonded;
        }
        smallerArray = new double[this.numberNonBonded * 5];
        System.arraycopy(this.nonBondedTerms, 0, smallerArray, 0, this.numberNonBonded * 5);
        this.nonBondedTerms = smallerArray;
    }

    private void initializeSolvationCalculation(List<Atom[]> pairs14, List<Atom[]> pairsNonBonded, boolean includeIntra) {
        ArrayList<Atom[]> pairs = new ArrayList<Atom[]>();
        for (Atom[] pair : pairs14) {
            if (pair[0].isHydrogen() || pair[1].isHydrogen()) continue;
            pairs.add(pair);
        }
        for (Atom[] pair : pairsNonBonded) {
            if (pair[0].isHydrogen() || pair[1].isHydrogen()) continue;
            pairs.add(pair);
        }
        double solvCoeff = 2.0 / (Math.PI * 4 * Math.sqrt(Math.PI));
        double[] solvationTerms1 = this.listSolvationTerms(this.res1.atoms, true);
        double[] solvationTerms2 = this.listSolvationTerms(this.res2.atoms, true);
        this.numberSolvated = pairs.size();
        this.solvationTerms = new double[8 * this.numberSolvated];
        for (int k = 0; k < this.numberSolvated; ++k) {
            Atom ati = ((Atom[])pairs.get(k))[0];
            Atom atj = ((Atom[])pairs.get(k))[1];
            int atomi = ati.indexInRes;
            int atomj = atj.indexInRes;
            int ix6 = 6 * atomi;
            int jx6 = 6 * atomj;
            int kx8 = k * 8;
            double dGiFree = solvationTerms1[ix6 + 2];
            double Vi = solvationTerms1[ix6 + 3];
            double Li = solvationTerms1[ix6 + 4];
            double vdWi = solvationTerms1[ix6 + 5];
            double dGjFree = solvationTerms2[jx6 + 2];
            double Vj = solvationTerms2[jx6 + 3];
            double Lj = solvationTerms2[jx6 + 4];
            double vdWj = solvationTerms2[jx6 + 5];
            double alpha_i = solvCoeff * dGiFree * Vj / Li;
            double alpha_j = solvCoeff * dGjFree * Vi / Lj;
            this.solvationTerms[kx8 + 0] = atomi;
            this.solvationTerms[kx8 + 1] = Li;
            this.solvationTerms[kx8 + 2] = vdWi;
            this.solvationTerms[kx8 + 3] = alpha_i;
            this.solvationTerms[kx8 + 4] = atomj;
            this.solvationTerms[kx8 + 5] = Lj;
            this.solvationTerms[kx8 + 6] = vdWj;
            this.solvationTerms[kx8 + 7] = alpha_j;
        }
        this.internalSolvEnergy = 0.0;
        if (includeIntra) {
            for (int i = 0; i < this.res1.atoms.size(); ++i) {
                this.internalSolvEnergy += solvationTerms1[i * 6 + 1];
            }
        }
    }

    private double[] listSolvationTerms(List<Atom> atomList, boolean fullLength) {
        double[] termList = new double[atomList.size() * 6];
        EEF1.SolvParams solvparams = new EEF1.SolvParams();
        int ix6 = -6;
        int numTerms = 0;
        for (int i = 0; i < atomList.size(); ++i) {
            int atom1 = atomList.get((int)i).indexInRes;
            if (!atomList.get((int)i).elementType.equalsIgnoreCase("H")) {
                ix6 += 6;
                if (!this.params.eef1parms.getSolvationParameters(atomList.get(i), solvparams)) {
                    termList[ix6] = atom1;
                    termList[ix6 + 1] = 0.0;
                    termList[ix6 + 2] = 0.0;
                    termList[ix6 + 3] = 0.0;
                    termList[ix6 + 4] = 1.0;
                    termList[ix6 + 5] = 0.0;
                    ++numTerms;
                    continue;
                }
                termList[ix6] = atom1;
                termList[ix6 + 1] = solvparams.dGref;
                termList[ix6 + 2] = solvparams.dGfree;
                termList[ix6 + 3] = solvparams.volume;
                termList[ix6 + 4] = solvparams.lambda;
                termList[ix6 + 5] = solvparams.radius;
                ++numTerms;
                continue;
            }
            if (!fullLength) continue;
            ix6 += 6;
        }
        if (fullLength) {
            return termList;
        }
        double[] smallerArray = new double[numTerms * 6];
        System.arraycopy(termList, 0, smallerArray, 0, numTerms * 6);
        return smallerArray;
    }

    public double calculateTotalEnergy() {
        double rij12;
        double rij6;
        double tmpCoulFact;
        double rij;
        double rij2;
        double chargej;
        double chargei;
        double rijz;
        double rijy;
        double rijx;
        int atomjx4;
        int atomix4;
        double Bij;
        double Aij;
        int atomj;
        int atomi;
        boolean isHeavy;
        boolean isHydrogen;
        int i;
        this.coordsAndCharges.updateCoords();
        double esEnergy = 0.0;
        double vdwEnergy = 0.0;
        int numberHalfNonBonded = this.numberHalfNonBonded;
        double[] halfNonBondedTerms = this.halfNonBondedTerms;
        int numberNonBonded = this.numberNonBonded;
        double[] nonBondedTerms = this.nonBondedTerms;
        double[] data = this.coordsAndCharges.data;
        int res1Start = this.coordsAndCharges.res1Start;
        int res2Start = this.coordsAndCharges.res2Start;
        boolean useHydrogenEs = this.params.hElect;
        boolean useHydrogenVdw = this.params.hVDW;
        boolean distDepDielect = this.params.distDepDielect;
        boolean isInternal = this.isInternal;
        double solvCutoff2 = this.solvCutoff * this.solvCutoff;
        int numberSolvated = this.numberSolvated;
        double[] solvationTerms = this.solvationTerms;
        boolean useHydrogenNeither = !useHydrogenEs && !useHydrogenVdw;
        double coulombFactor = switch (this.params.forcefld) {
            case ForcefieldParams.Forcefield.AMBER -> 276.6666666666667 / this.params.dielectric;
            case ForcefieldParams.Forcefield.CHARMM19, ForcefieldParams.Forcefield.CHARMM19NEUTRAL -> 132.8 / this.params.dielectric;
            default -> throw new Error("FORCEFIELD NOT RECOGNIZED!!!");
        };
        int ix5 = -5;
        for (i = 0; i < numberHalfNonBonded; ++i) {
            boolean bl = isHydrogen = halfNonBondedTerms[(ix5 += 5) + 2] == 1.0;
            if (isHydrogen && useHydrogenNeither) continue;
            isHeavy = !isHydrogen;
            atomi = (int)halfNonBondedTerms[ix5];
            atomj = (int)halfNonBondedTerms[ix5 + 1];
            Aij = halfNonBondedTerms[ix5 + 3];
            Bij = halfNonBondedTerms[ix5 + 4];
            atomix4 = atomi * 4;
            atomjx4 = atomj * 4;
            rijx = data[res1Start + atomix4] - data[res2Start + atomjx4];
            rijy = data[res1Start + atomix4 + 1] - data[res2Start + atomjx4 + 1];
            rijz = data[res1Start + atomix4 + 2] - data[res2Start + atomjx4 + 2];
            chargei = data[res1Start + atomix4 + 3];
            chargej = data[res2Start + atomjx4 + 3];
            rij2 = rijx * rijx + rijy * rijy + rijz * rijz;
            if (isHeavy || useHydrogenEs) {
                rij = Math.sqrt(rij2);
                tmpCoulFact = coulombFactor;
                if (distDepDielect) {
                    tmpCoulFact /= rij;
                }
                esEnergy += chargei * chargej * tmpCoulFact / rij;
            }
            if (!isHeavy && !useHydrogenVdw) continue;
            rij6 = rij2 * rij2 * rij2;
            rij12 = rij6 * rij6;
            vdwEnergy += Aij / rij12 - Bij / rij6;
        }
        coulombFactor = 332.0 / this.params.dielectric;
        ix5 = -5;
        for (i = 0; i < numberNonBonded; ++i) {
            boolean bl = isHydrogen = nonBondedTerms[(ix5 += 5) + 2] == 1.0;
            if (isHydrogen && useHydrogenNeither) continue;
            isHeavy = !isHydrogen;
            atomi = (int)nonBondedTerms[ix5];
            atomj = (int)nonBondedTerms[ix5 + 1];
            Aij = nonBondedTerms[ix5 + 3];
            Bij = nonBondedTerms[ix5 + 4];
            atomix4 = atomi * 4;
            atomjx4 = atomj * 4;
            rijx = data[res1Start + atomix4] - data[res2Start + atomjx4];
            rijy = data[res1Start + atomix4 + 1] - data[res2Start + atomjx4 + 1];
            rijz = data[res1Start + atomix4 + 2] - data[res2Start + atomjx4 + 2];
            chargei = data[res1Start + atomix4 + 3];
            chargej = data[res2Start + atomjx4 + 3];
            rij2 = rijx * rijx + rijy * rijy + rijz * rijz;
            if (isHeavy || useHydrogenEs) {
                rij = Math.sqrt(rij2);
                tmpCoulFact = coulombFactor;
                if (distDepDielect) {
                    tmpCoulFact /= rij;
                }
                esEnergy += chargei * chargej * tmpCoulFact / rij;
            }
            if (!isHeavy && !useHydrogenVdw) continue;
            rij6 = rij2 * rij2 * rij2;
            rij12 = rij6 * rij6;
            vdwEnergy += Aij / rij12 - Bij / rij6;
        }
        if (this.params.solvationForcefield != ForcefieldParams.SolvationForcefield.EEF1) {
            return this.checkEnergy(esEnergy + vdwEnergy);
        }
        double solvEnergy = 0.0;
        if (isInternal) {
            solvEnergy += this.internalSolvEnergy;
        }
        int ix8 = -8;
        for (int i2 = 0; i2 < numberSolvated; ++i2) {
            atomi = (int)solvationTerms[ix8 += 8];
            atomix4 = atomi * 4;
            rijy = data[res1Start + atomix4 + 1] - data[res2Start + atomjx4 + 1];
            rijz = data[res1Start + atomix4 + 2] - data[res2Start + atomjx4 + 2];
            if (!((rij2 = (rijx = data[res1Start + atomix4] - data[res2Start + (atomjx4 = (atomj = (int)solvationTerms[ix8 + 4]) * 4)]) * rijx + rijy * rijy + rijz * rijz) < solvCutoff2)) continue;
            double lambda_i = solvationTerms[ix8 + 1];
            double vdWr_i = solvationTerms[ix8 + 2];
            double alpha_i = solvationTerms[ix8 + 3];
            double lambda_j = solvationTerms[ix8 + 5];
            double vdWr_j = solvationTerms[ix8 + 6];
            double alpha_j = solvationTerms[ix8 + 7];
            rij = Math.sqrt(rij2);
            double Xij = (rij - vdWr_i) / lambda_i;
            double Xji = (rij - vdWr_j) / lambda_j;
            solvEnergy -= (alpha_i * Math.exp(-Xij * Xij) + alpha_j * Math.exp(-Xji * Xji)) / rij2;
        }
        return this.checkEnergy(esEnergy + vdwEnergy + (solvEnergy *= this.params.solvScale));
    }

    private double checkEnergy(double energy) {
        if (Double.isNaN(energy)) {
            for (double a : this.res1.coords) {
                if (Double.isNaN(a)) {
                    throw new RuntimeException("ERROR: NaN coordinates provided to ForcefieldEnergy");
                }
                if (!Double.isInfinite(a)) continue;
                throw new RuntimeException("ERROR: Infinite coordinates provided to ForcefieldEnergy");
            }
            for (double a : this.res2.coords) {
                if (Double.isNaN(a)) {
                    throw new RuntimeException("ERROR: NaN coordinates provided to ForcefieldEnergy");
                }
                if (!Double.isInfinite(a)) continue;
                throw new RuntimeException("ERROR: Infinite coordinates provided to ForcefieldEnergy");
            }
            throw new RuntimeException("ERROR: NaN returned by ForcefieldEnergy.  No NaN or infinite coordinates.");
        }
        return energy;
    }
}

