/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.forcefield.BigForcefieldEnergy;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldInteractions;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.gpu.BufferTools;
import edu.duke.cs.osprey.gpu.ForcefieldKernel;
import edu.duke.cs.osprey.gpu.cuda.GpuStream;
import edu.duke.cs.osprey.gpu.cuda.GpuStreamPool;
import edu.duke.cs.osprey.gpu.cuda.kernels.ForcefieldKernelCuda;
import edu.duke.cs.osprey.gpu.opencl.GpuQueue;
import edu.duke.cs.osprey.gpu.opencl.GpuQueuePool;
import edu.duke.cs.osprey.gpu.opencl.kernels.ForcefieldKernelOpenCL;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GpuForcefieldEnergy
implements EnergyFunction.DecomposableByDof,
EnergyFunction.NeedsCleanup,
EnergyFunction.ExplicitChemicalChanges {
    private static final long serialVersionUID = -9142317985561910731L;
    private BigForcefieldEnergy ffenergy;
    private BigForcefieldEnergy.Subset ffsubset;
    private GpuQueuePool openclQueuePool;
    private GpuQueue openclQueue;
    private GpuStreamPool cudaStreamPool;
    private GpuStream cudaStream;
    private KernelBuilder kernelBuilder;
    private Map<Residue, GpuForcefieldEnergy> efuncCache;

    public GpuForcefieldEnergy(ForcefieldParams ffparams, ForcefieldInteractions interactions, GpuQueuePool queuePool) {
        this.ffenergy = new BigForcefieldEnergy(ffparams, interactions, BufferTools.Type.Direct);
        this.ffsubset = this.ffenergy.getFullSubset();
        this.openclQueuePool = queuePool;
        this.openclQueue = queuePool.checkout();
        this.cudaStreamPool = null;
        this.cudaStream = null;
        this.kernelBuilder = new KernelBuilder();
        this.efuncCache = new HashMap<Residue, GpuForcefieldEnergy>();
    }

    public GpuForcefieldEnergy(ForcefieldParams ffparams, ForcefieldInteractions interactions, GpuStreamPool streamPool) {
        this.ffenergy = new BigForcefieldEnergy(ffparams, interactions, BufferTools.Type.Direct);
        this.ffsubset = this.ffenergy.getFullSubset();
        this.openclQueuePool = null;
        this.openclQueue = null;
        this.cudaStreamPool = streamPool;
        this.cudaStream = streamPool.checkout();
        this.kernelBuilder = new KernelBuilder();
        this.efuncCache = new HashMap<Residue, GpuForcefieldEnergy>();
    }

    public GpuForcefieldEnergy(GpuForcefieldEnergy parent, ForcefieldInteractions interactions) {
        BigForcefieldEnergy bigForcefieldEnergy = this.ffenergy = parent.ffenergy;
        Objects.requireNonNull(bigForcefieldEnergy);
        this.ffsubset = bigForcefieldEnergy.new BigForcefieldEnergy.Subset(interactions);
        if (parent.openclQueue != null) {
            this.openclQueuePool = null;
            this.openclQueue = parent.openclQueue;
            this.cudaStreamPool = null;
            this.cudaStream = null;
        } else {
            this.openclQueuePool = null;
            this.openclQueue = null;
            this.cudaStreamPool = null;
            this.cudaStream = parent.cudaStream;
        }
        this.kernelBuilder = parent.kernelBuilder;
        this.efuncCache = null;
    }

    public ForcefieldKernel getKernel() {
        return this.kernelBuilder.get(this.handleChemicalChanges());
    }

    public BigForcefieldEnergy.Subset getSubset() {
        return this.ffsubset;
    }

    @Override
    public int handleChemicalChanges() {
        return this.ffsubset.handleChemicalChanges();
    }

    @Override
    public double getEnergy() {
        if (this.ffsubset.isBroken()) {
            return Double.POSITIVE_INFINITY;
        }
        ForcefieldKernel kernel = this.getKernel();
        kernel.setSubset(this.getSubset());
        kernel.uploadCoordsAsync();
        kernel.runAsync();
        return kernel.downloadEnergySync();
    }

    @Override
    public void clean() {
        this.kernelBuilder.cleanup();
        this.kernelBuilder = null;
        if (this.openclQueuePool != null) {
            this.openclQueuePool.release(this.openclQueue);
        }
        if (this.cudaStreamPool != null) {
            this.cudaStreamPool.release(this.cudaStream);
        }
        if (this.efuncCache != null) {
            for (GpuForcefieldEnergy efunc : this.efuncCache.values()) {
                efunc.clean();
            }
            this.efuncCache.clear();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.kernelBuilder != null) {
                System.err.println("WARNING: " + this.getClass().getName() + " was garbage collected, but not cleaned up. Attempting cleanup now");
                this.clean();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public List<EnergyFunction> decomposeByDof(Molecule m, List<DegreeOfFreedom> dofs) {
        ArrayList<EnergyFunction> efuncs = new ArrayList<EnergyFunction>();
        for (DegreeOfFreedom dof : dofs) {
            Residue res = dof.getResidue();
            if (res == null) {
                efuncs.add(this);
                continue;
            }
            GpuForcefieldEnergy efunc = this.efuncCache.get(res);
            if (efunc == null) {
                efunc = new GpuForcefieldEnergy(this, this.ffenergy.getInteractions().makeSubsetByResidue(res));
                this.efuncCache.put(res, efunc);
            }
            efuncs.add(efunc);
        }
        return efuncs;
    }

    private class KernelBuilder {
        private int subsetSequenceNumber = -1;
        private ForcefieldKernel kernel = null;

        public ForcefieldKernel get(int expectedSequenceNumber) {
            if (this.kernel != null && expectedSequenceNumber != this.subsetSequenceNumber) {
                this.kernel.cleanup();
                this.kernel = null;
            }
            if (this.kernel == null) {
                try {
                    if (GpuForcefieldEnergy.this.openclQueue != null) {
                        this.kernel = new ForcefieldKernelOpenCL(GpuForcefieldEnergy.this.openclQueue, GpuForcefieldEnergy.this.ffenergy);
                    } else if (GpuForcefieldEnergy.this.cudaStream != null) {
                        this.kernel = new ForcefieldKernelCuda(GpuForcefieldEnergy.this.cudaStream, GpuForcefieldEnergy.this.ffenergy);
                    } else {
                        throw new Error("bad gpu queue/context configuration, this is a bug");
                    }
                    this.subsetSequenceNumber = this.kernel.getForcefield().getFullSubset().handleChemicalChanges();
                }
                catch (IOException ex) {
                    throw new Error("can't initialize gpu kernel", ex);
                }
            }
            return this.kernel;
        }

        public void cleanup() {
            if (this.kernel != null) {
                this.kernel.cleanup();
                this.kernel = null;
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.kernel != null) {
                    System.err.println("WARNING: " + this.getClass().getName() + " was garbage collected, but not cleaned up. Attempting cleanup now");
                    this.cleanup();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

