/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldEnergy;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Residue;

public class ResPairEnergy
implements EnergyFunction {
    Residue res1;
    Residue res2;
    ResidueTemplate templ1 = null;
    ResidueTemplate templ2 = null;
    ForcefieldParams ffParams;
    ForcefieldEnergy ffEnergy;

    public ResPairEnergy(Residue res1, Residue res2, ForcefieldParams ffParams) {
        this.res1 = res1;
        this.res2 = res2;
        this.ffParams = ffParams;
        this.templ1 = res1.template;
        this.templ2 = res2.template;
        this.initFFE();
    }

    @Override
    public double getEnergy() {
        if (this.res1.template != this.templ1 || this.res2.template != this.templ2) {
            this.initFFE();
        }
        if (!this.res1.confProblems.isEmpty() || !this.res2.confProblems.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.ffEnergy.calculateTotalEnergy();
    }

    void initFFE() {
        this.ffEnergy = new ForcefieldEnergy(false, this.res1.atoms, this.res2.atoms, this.ffParams);
        this.templ1 = this.res1.template;
        this.templ2 = this.res2.template;
    }

    public Residue getRes1() {
        return this.res1;
    }

    public Residue getRes2() {
        return this.res2;
    }

    public ForcefieldParams getFFParams() {
        return this.ffParams;
    }

    public ForcefieldEnergy getFFEnergy() {
        return this.ffEnergy;
    }
}

