/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ewakstar;

import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.seq.RTs;
import edu.duke.cs.osprey.astar.seq.SeqAStarTree;
import edu.duke.cs.osprey.astar.seq.nodes.SeqAStarNode;
import edu.duke.cs.osprey.astar.seq.order.SequentialSeqAStarOrder;
import edu.duke.cs.osprey.astar.seq.scoring.NOPSeqAStarScorer;
import edu.duke.cs.osprey.astar.seq.scoring.SeqAStarScorer;
import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.FragmentEnergies;
import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.confspace.StrandFlex;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.ematrix.SimplerEnergyMatrixCalculator;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.ewakstar.EWAKStar;
import edu.duke.cs.osprey.ewakstar.EWAKStarBBKStar;
import edu.duke.cs.osprey.ewakstar.EwakstarLimitedSequenceTrie;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.tools.HashCalculator;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.MathTools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EwakstarDoer {
    public final Double numEWAKStarSeqs;
    public final int numCPUs;
    public final double eW;
    public final boolean printToConsole;
    public final boolean seqFilterOnly;
    public final File logFile;
    public final int orderOfMag;
    public final double pfEw;
    public final int numPfConfs;
    public final int numTopOverallSeqs;
    public final boolean useWtBenchmark;
    public final double epsilon;
    public final State state;
    public final SeqSpace seqSpace;
    public String mutableType;
    public int numMutable;
    public boolean useExact;
    public EwakstarDoer ewakstarDoerP;
    public EwakstarDoer ewakstarDoerL;
    public EwakstarDoer ewakstarDoerPL;
    public final boolean useSMA;
    public final int smaNodes;
    public final boolean printPDBs;
    public List<SequenceInfo> infos = new ArrayList<SequenceInfo>();
    private final Map<StateConfs.Key, StateConfs> stateConfsCache = new HashMap<StateConfs.Key, StateConfs>();

    private EwakstarDoer(boolean printPDBs, boolean useSMA, int smaNodes, State state, double eW, String mutableType, int numMutable, int numCPUs, boolean printToConsole, boolean seqFilterOnly, File logFile, Double numEWAKStarSeqs, boolean useWtBenchmark, int orderOfMag, double pfEw, int numPfConfs, double epsilon, int numTopOverallSeqs) {
        if (mutableType.equals("exact") || mutableType.equals("max")) {
            this.numMutable = numMutable;
        } else if (mutableType.equals("all")) {
            this.numMutable = state.confSpace.mutablePositions.size();
        }
        if (mutableType.equals("max")) {
            this.useExact = false;
        }
        this.printPDBs = printPDBs;
        this.useSMA = useSMA;
        this.smaNodes = smaNodes;
        this.epsilon = epsilon;
        this.numEWAKStarSeqs = numEWAKStarSeqs;
        this.orderOfMag = orderOfMag;
        this.pfEw = pfEw;
        this.numPfConfs = numPfConfs;
        this.numTopOverallSeqs = numTopOverallSeqs;
        this.useWtBenchmark = useWtBenchmark;
        this.seqFilterOnly = seqFilterOnly;
        this.numCPUs = numCPUs;
        this.mutableType = mutableType;
        this.eW = eW;
        this.numMutable = numMutable;
        this.printToConsole = printToConsole;
        this.logFile = logFile;
        this.state = state;
        this.seqSpace = state.confSpace.seqSpace;
        this.log("sequence space has %s sequences\n%s", Log.formatBig(new RTs(this.seqSpace).getNumSequences()), this.seqSpace);
    }

    /*
     * WARNING - void declaration
     */
    public Set<Sequence> run(State PL) {
        void var17_23;
        this.ewakstarDoerPL = this;
        this.stateConfsCache.clear();
        long startEWAKStarTime = System.currentTimeMillis();
        System.out.println("Performing EWAK*");
        BigDecimal totalConfs = BigDecimal.ONE;
        for (int i = 0; i < PL.confSpace.positions.size(); ++i) {
            BigDecimal newConfs = new BigDecimal(PL.confSpace.positions.get((int)i).resConfs.size());
            totalConfs = totalConfs.multiply(newConfs);
        }
        this.state.checkConfig();
        List<SequenceInfo> bestPLSeqs = this.extractPLSeqsByLB(this.numEWAKStarSeqs, this.orderOfMag, PL);
        long intermediateStopTime = System.currentTimeMillis();
        long timeTakenSoFar = intermediateStopTime - startEWAKStarTime;
        this.setupUnboundStates();
        long intermediateStartTime = System.currentTimeMillis();
        HashSet<Sequence> filteredSeqsP = new HashSet<Sequence>();
        HashSet<Sequence> filteredSeqsL = new HashSet<Sequence>();
        HashSet<String> filteredSeqsPL = new HashSet<String>();
        for (SequenceInfo sequenceInfo : bestPLSeqs) {
            filteredSeqsP.add(sequenceInfo.sequence.filter(this.ewakstarDoerP.seqSpace));
            filteredSeqsL.add(sequenceInfo.sequence.filter(this.ewakstarDoerL.seqSpace));
            filteredSeqsPL.add(sequenceInfo.sequence.toString());
        }
        EwakstarLimitedSequenceTrie elstP = new EwakstarLimitedSequenceTrie(this.ewakstarDoerP.seqSpace);
        if (filteredSeqsP.size() != 1) {
            for (Sequence sequence : filteredSeqsP) {
                elstP.addSeq(sequence.toString());
            }
        }
        EwakstarLimitedSequenceTrie ewakstarLimitedSequenceTrie = new EwakstarLimitedSequenceTrie(this.ewakstarDoerL.seqSpace);
        if (filteredSeqsL.size() != 1) {
            for (Sequence s : filteredSeqsL) {
                ewakstarLimitedSequenceTrie.addSeq(s.toString());
            }
        }
        Object var17_21 = null;
        List<SequenceInfo> bestLSeqs = null;
        this.stateConfsCache.clear();
        if (this.ewakstarDoerP.state.confSpace.mutablePositions.size() != 0) {
            List<SequenceInfo> list = this.ewakstarDoerP.extractUnboundSeqsByLB(this.orderOfMag, filteredSeqsP, elstP);
        }
        this.stateConfsCache.clear();
        if (this.ewakstarDoerL.state.confSpace.mutablePositions.size() != 0) {
            bestLSeqs = this.ewakstarDoerL.extractUnboundSeqsByLB(this.orderOfMag, filteredSeqsL, ewakstarLimitedSequenceTrie);
        }
        HashSet<Sequence> newPSeqs = new HashSet<Sequence>();
        HashSet<Sequence> newLSeqs = new HashSet<Sequence>();
        if (var17_23 != null) {
            for (SequenceInfo si : var17_23) {
                newPSeqs.add(si.sequence);
            }
        }
        if (bestLSeqs != null) {
            for (SequenceInfo si : bestLSeqs) {
                newLSeqs.add(si.sequence);
            }
        }
        Set<Sequence> fullSeqs = this.combineSeqs(newPSeqs, newLSeqs, filteredSeqsPL);
        this.log("The original conformation space size is: %6.3e", totalConfs);
        if (!this.seqFilterOnly) {
            EwakstarLimitedSequenceTrie elstPL = new EwakstarLimitedSequenceTrie(this.ewakstarDoerPL.seqSpace);
            if (fullSeqs.size() != 0) {
                for (Sequence s : fullSeqs) {
                    elstPL.addSeq(s.toString());
                }
            }
            this.runEWAKStarBBKStar(elstPL, this.ewakstarDoerPL.state, this.ewakstarDoerP.state, this.ewakstarDoerL.state);
        }
        if (this.seqFilterOnly) {
            this.writeSeqsToFile(fullSeqs);
            System.out.println("Number of sequences filtered down to " + fullSeqs.size() + " from " + Log.formatBig(new RTs(this.seqSpace).getNumSequences()));
            long stopEWAKStarTime = System.currentTimeMillis() - intermediateStartTime + timeTakenSoFar;
            System.out.println("Total OSPREY/EWAK* time (not including energy matrix time): " + String.format("%d sec", TimeUnit.MILLISECONDS.toSeconds(stopEWAKStarTime)));
            return fullSeqs;
        }
        System.out.println("Number of sequences filtered down to " + fullSeqs.size() + " from " + Log.formatBig(new RTs(this.seqSpace).getNumSequences()));
        long stopEWAKStarTime = System.currentTimeMillis() - intermediateStartTime + timeTakenSoFar;
        System.out.println("Total OSPREY/EWAK* time (not including energy matrix time): " + String.format("%d sec", TimeUnit.MILLISECONDS.toSeconds(stopEWAKStarTime)));
        return null;
    }

    private void runEWAKStarBBKStar(EwakstarLimitedSequenceTrie plTrie, State PL, State P, State L) {
        EWAKStar.Settings ewakstarSettings = new EWAKStar.Settings.Builder().setEw(this.pfEw).setUseExact(this.useExact).setNumMutations(this.numMutable).setEpsilon(this.epsilon).setMaxNumConfs(this.numPfConfs).setNumTopOverallSeqs(this.numTopOverallSeqs).addScoreConsoleWriter().setWTBenchmark(this.useWtBenchmark).setPrintPDBs(this.printPDBs).addScoreFileWriter(new File("ewakStar.results.txt")).build();
        EWAKStarBBKStar.Settings bbkstarSettings = new EWAKStarBBKStar.Settings.Builder().setNumBestSequences(this.numTopOverallSeqs).setAllowedSeqs(plTrie).build();
        Results results2 = new Results();
        results2.bbkstar = new EWAKStarBBKStar(P, L, PL, ewakstarSettings, bbkstarSettings, null);
        for (EWAKStarBBKStar.ConfSpaceInfo info2 : results2.bbkstar.confSpaceInfos()) {
            if (info2.id.equals("protein")) {
                info2.confEcalcMinimized = P.confEcalc;
                info2.confTreeFactoryMinimized = P.confTreeFactoryMin;
                info2.confTreeFactoryRigid = P.confTreeFactoryRigid;
                continue;
            }
            if (info2.id.equals("ligand")) {
                info2.confEcalcMinimized = L.confEcalc;
                info2.confTreeFactoryMinimized = L.confTreeFactoryMin;
                info2.confTreeFactoryRigid = L.confTreeFactoryRigid;
                continue;
            }
            info2.confEcalcMinimized = PL.confEcalc;
            info2.confTreeFactoryMinimized = PL.confTreeFactoryMin;
            info2.confTreeFactoryRigid = PL.confTreeFactoryRigid;
        }
        results2.sequences = results2.bbkstar.run();
    }

    private void writeSeqsToFile(Set<Sequence> seqs) {
        File newFile = new File("ewakStar.filteredSeqs.txt");
        boolean started = false;
        for (Sequence s : seqs) {
            boolean append;
            String curSeq = s.toString();
            if (!started) {
                started = true;
                append = false;
            } else {
                append = true;
            }
            try (FileWriter out = new FileWriter(newFile, append);){
                out.write(curSeq);
                out.write("\n");
            }
            catch (IOException ex) {
                System.err.println("writing to file failed: " + String.valueOf(newFile));
                ex.printStackTrace(System.err);
                System.err.println(curSeq);
            }
        }
    }

    public Set<Sequence> combineSeqs(Set<Sequence> P, Set<Sequence> L, Set<String> PL) {
        HashSet<Sequence> newPL = new HashSet<Sequence>();
        BigInteger totalConfs = BigInteger.ZERO;
        if (P.size() != 0 && L.size() != 0) {
            for (Sequence sP : P) {
                for (Sequence sL : L) {
                    ArrayList<String> resTypes = new ArrayList<String>();
                    for (String p : this.ewakstarDoerPL.seqSpace.getResNums()) {
                        if (this.ewakstarDoerP.seqSpace.getResNums().contains(p)) {
                            resTypes.add(sP.get((String)p).name);
                            continue;
                        }
                        resTypes.add(sL.get((String)p).name);
                    }
                    Sequence newSeq = this.ewakstarDoerPL.seqSpace.makeSequence(resTypes);
                    if (!PL.contains(newSeq.toString())) continue;
                    newPL.add(newSeq);
                    totalConfs = totalConfs.add(this.getNumConfsForSeq(newSeq, this.ewakstarDoerPL.state.confSpace));
                }
            }
        } else if (P.size() != 0) {
            for (Sequence sP : P) {
                ArrayList<String> resTypes = new ArrayList<String>();
                for (String p : this.ewakstarDoerPL.seqSpace.getResNums()) {
                    if (!this.ewakstarDoerP.seqSpace.getResNums().contains(p)) continue;
                    resTypes.add(sP.get((String)p).name);
                }
                Sequence newSeq = this.ewakstarDoerPL.seqSpace.makeSequence(resTypes);
                if (!PL.contains(newSeq.toString())) continue;
                newPL.add(newSeq);
                totalConfs = totalConfs.add(this.getNumConfsForSeq(newSeq, this.ewakstarDoerPL.state.confSpace));
            }
        } else if (L.size() != 0) {
            for (Sequence sL : L) {
                ArrayList<String> resTypes = new ArrayList<String>();
                for (String p : this.ewakstarDoerPL.seqSpace.getResNums()) {
                    if (!this.ewakstarDoerL.seqSpace.getResNums().contains(p)) continue;
                    resTypes.add(sL.get((String)p).name);
                }
                Sequence newSeq = this.ewakstarDoerPL.seqSpace.makeSequence(resTypes);
                if (!PL.contains(newSeq.toString())) continue;
                newPL.add(newSeq);
                totalConfs = totalConfs.add(this.getNumConfsForSeq(newSeq, this.ewakstarDoerPL.state.confSpace));
            }
        }
        this.log("The remaining conformation space size is: %6.3e", totalConfs.doubleValue());
        return newPL;
    }

    public void setupUnboundStates() {
        Strand protein = this.state.confSpace.strands.get(0);
        Strand ligand = this.state.confSpace.strands.get(1);
        State P = new State("P", new SimpleConfSpace.Builder().addStrand(protein, new StrandFlex[0]).build());
        State L = new State("L", new SimpleConfSpace.Builder().addStrand(ligand, new StrandFlex[0]).build());
        this.ewakstarDoerP = new Builder().addState(P).setEw(this.eW).setNumCpus(this.numCPUs).setMutableType("all").build();
        this.ewakstarDoerL = new Builder().addState(L).setEw(this.eW).setNumCpus(this.numCPUs).setMutableType("all").build();
        ForcefieldParams ffparams = new ForcefieldParams();
        EnergyCalculator ecalcP = new EnergyCalculator.Builder(P.confSpace, ffparams).setParallelism(Parallelism.makeCpu(this.ewakstarDoerP.numCPUs)).build();
        EnergyCalculator rigidEcalcP = new EnergyCalculator.Builder(P.confSpace, ffparams).setIsMinimizing(false).setParallelism(Parallelism.makeCpu(this.ewakstarDoerP.numCPUs)).build();
        SimpleReferenceEnergies erefP = new SimplerEnergyMatrixCalculator.Builder(P.confSpace, ecalcP).build().calcReferenceEnergies();
        SimpleReferenceEnergies rigidErefP = new SimplerEnergyMatrixCalculator.Builder(P.confSpace, rigidEcalcP).build().calcReferenceEnergies();
        P.confEcalc = new ConfEnergyCalculator.Builder(P.confSpace, ecalcP).setReferenceEnergies(erefP).build();
        P.confRigidEcalc = new ConfEnergyCalculator.Builder(P.confSpace, rigidEcalcP).setReferenceEnergies(rigidErefP).build();
        P.emat = new SimplerEnergyMatrixCalculator.Builder(P.confEcalc).setCacheFile(new File(String.format("ewakstar.%s.emat", P.name))).build().calcEnergyMatrix();
        P.fragmentEnergies = P.emat;
        P.ematRigid = new SimplerEnergyMatrixCalculator.Builder(P.confRigidEcalc).setCacheFile(new File(String.format("ewakstar.%s.ematRigid", P.name))).build().calcEnergyMatrix();
        if (this.useSMA) {
            P.confTreeFactoryMin = rcs -> new ConfAStarTree.Builder(P.emat, (RCs)rcs).setMaxNumNodes(this.smaNodes).setTraditional().build();
            P.confTreeFactoryRigid = rcs -> new ConfAStarTree.Builder(P.ematRigid, (RCs)rcs).setMaxNumNodes(this.smaNodes).setTraditional().build();
        } else {
            P.confTreeFactoryMin = rcs -> new ConfAStarTree.Builder(P.emat, (RCs)rcs).setTraditional().build();
            P.confTreeFactoryRigid = rcs -> new ConfAStarTree.Builder(P.ematRigid, (RCs)rcs).setTraditional().build();
        }
        EnergyCalculator ecalcL = new EnergyCalculator.Builder(L.confSpace, ffparams).setParallelism(Parallelism.makeCpu(this.ewakstarDoerL.numCPUs)).build();
        EnergyCalculator rigidEcalcL = new EnergyCalculator.Builder(L.confSpace, ffparams).setIsMinimizing(false).setParallelism(Parallelism.makeCpu(this.ewakstarDoerL.numCPUs)).build();
        SimpleReferenceEnergies erefL = new SimplerEnergyMatrixCalculator.Builder(L.confSpace, ecalcL).build().calcReferenceEnergies();
        SimpleReferenceEnergies rigidErefL = new SimplerEnergyMatrixCalculator.Builder(L.confSpace, rigidEcalcL).build().calcReferenceEnergies();
        L.confEcalc = new ConfEnergyCalculator.Builder(L.confSpace, ecalcL).setReferenceEnergies(erefL).build();
        L.confRigidEcalc = new ConfEnergyCalculator.Builder(L.confSpace, rigidEcalcL).setReferenceEnergies(rigidErefL).build();
        L.emat = new SimplerEnergyMatrixCalculator.Builder(L.confEcalc).setCacheFile(new File(String.format("ewakstar.%s.emat", L.name))).build().calcEnergyMatrix();
        L.fragmentEnergies = L.emat;
        L.ematRigid = new SimplerEnergyMatrixCalculator.Builder(L.confRigidEcalc).setCacheFile(new File(String.format("ewakstar.%s.ematRigid", L.name))).build().calcEnergyMatrix();
        if (this.useSMA) {
            L.confTreeFactoryMin = rcs -> new ConfAStarTree.Builder(L.emat, (RCs)rcs).setMaxNumNodes(this.smaNodes).setTraditional().build();
            L.confTreeFactoryRigid = rcs -> new ConfAStarTree.Builder(L.ematRigid, (RCs)rcs).setMaxNumNodes(this.smaNodes).setTraditional().build();
        } else {
            L.confTreeFactoryMin = rcs -> new ConfAStarTree.Builder(L.emat, (RCs)rcs).setTraditional().build();
            L.confTreeFactoryRigid = rcs -> new ConfAStarTree.Builder(L.ematRigid, (RCs)rcs).setTraditional().build();
        }
    }

    public List<SequenceInfo> extractPLSeqsByLB(double numSequences, int orderMag, State PL) {
        SeqAStarNode node;
        SeqAStarTree seqTree = new SeqAStarTree.Builder(new RTs(this.seqSpace)).setHeuristics(new SequentialSeqAStarOrder(), new NOPSeqAStarScorer(), new SeqHScorer()).setMutableType(this.mutableType).setNumMutable(this.numMutable).build();
        double wtPfLB = Double.POSITIVE_INFINITY;
        boolean didSeqMax = false;
        double seqLB = Double.NEGATIVE_INFINITY;
        Boolean wtFound = false;
        double wtEnergy = 0.0;
        Boolean didEW = false;
        int wtSpot = 0;
        BoltzmannCalculator bc = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
        int seqNum = 0;
        while ((double)seqNum < numSequences && (node = seqTree.nextLeafNode()) != null) {
            SeqConfs confs = (SeqConfs)node.getData();
            if (confs == null) {
                seqLB = node.getScore();
                this.log("Estimated Sequence: %s   Sequence minimized lower bound: %12.6f", node.makeSequence(this.seqSpace), seqLB);
                confs = new SeqConfs(this, node);
                double curScore = confs.refineBounds();
                node.setData(confs);
            }
            if (confs.stateConfs.isWT) {
                wtFound = true;
                wtSpot = seqNum;
                wtEnergy = confs.stateConfs.wtConf.getEnergy();
                wtPfLB = Math.log10(bc.calc(wtEnergy).doubleValue());
                System.out.println("Found wild-type sequence in complex after " + seqNum + " sequences.");
                System.out.println("Finding all sequences within " + this.eW + " kcal of WT minimized energy: " + wtEnergy + " or until " + numSequences + " sequences are enumerated.");
            }
            Sequence newSequence = node.makeSequence(PL.confSpace.seqSpace);
            double pfUB = Math.log10(bc.calc(confs.stateConfs.lowestScoringConf.getScore()).multiply(new BigDecimal(this.getNumConfsForSeq(newSequence, PL.confSpace))).doubleValue());
            SequenceInfo info2 = new SequenceInfo(this, node, confs, pfUB);
            if (!wtFound.booleanValue()) {
                this.infos.add(info2);
                this.reportSequence(this.infos.size() == 1, info2);
            } else {
                if (seqLB > wtEnergy + this.eW) {
                    if ((double)this.infos.size() >= numSequences) {
                        didSeqMax = true;
                    }
                    didEW = true;
                    break;
                }
                if ((double)this.infos.size() >= numSequences) {
                    didSeqMax = true;
                    break;
                }
                if (confs.stateConfs.lowestScoringConf.getScore() < wtEnergy + this.eW && pfUB > wtPfLB - (double)orderMag) {
                    this.infos.add(info2);
                    this.reportSequence(this.infos.size() == 1, info2);
                }
            }
            ++seqNum;
        }
        ArrayList<SequenceInfo> badPfs = new ArrayList<SequenceInfo>();
        for (int i = 0; i < wtSpot; ++i) {
            if (!(this.infos.get((int)i).pfUB < wtPfLB - (double)orderMag) && !(this.infos.get((int)i).lowestConf.getScore() > wtEnergy + this.eW)) continue;
            badPfs.add(this.infos.get(i));
        }
        this.infos.removeAll(badPfs);
        this.log("", new Object[0]);
        if (this.infos.isEmpty()) {
            this.log("EWAK* didn't find any sequences within the window that satisfy all the constraints.", new Object[0]);
        } else {
            this.log("EWAK* found the best %d sequences within %d orders of magnitude of the wild-type sequence partition function.", this.infos.size(), orderMag);
        }
        if (didEW.booleanValue()) {
            this.log("Found all sequences within %1.0f kcal/mol of the wild-type sequence.", this.eW);
        } else {
            this.log("The energy window of %1.0f kcal/mol was not fully enumerated.", this.eW);
        }
        if (didSeqMax) {
            this.log("The sequence number max of %d was enumerated.", numSequences);
        } else if (didEW.booleanValue()) {
            this.log("The energy window was completed before enumerating the requested number of sequences.", new Object[0]);
        } else if (!didSeqMax && !didEW.booleanValue()) {
            this.log("Exhaustively enumerated all sequence possibilities!", new Object[0]);
        }
        return this.infos;
    }

    public List<SequenceInfo> extractUnboundSeqsByLB(int orderMag, Set<Sequence> seqsToUse, EwakstarLimitedSequenceTrie elst) {
        SeqAStarNode node;
        SeqAStarTree seqTree = new SeqAStarTree.Builder(new RTs(this.state.confSpace.seqSpace)).setSeqTrie(elst).setHeuristics(new SequentialSeqAStarOrder(), new NOPSeqAStarScorer(), new SeqHScorer()).setMutableType(this.mutableType).setNumMutable(this.numMutable).build();
        ArrayList<SequenceInfo> infos2 = new ArrayList<SequenceInfo>();
        double wtPfLB = Double.POSITIVE_INFINITY;
        boolean didSeqMax = false;
        double seqLB = Double.NEGATIVE_INFINITY;
        Boolean wtFound = false;
        double wtEnergy = 0.0;
        Boolean didEW = false;
        int wtSpot = 0;
        BoltzmannCalculator bc = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
        int seqNum = 0;
        while (infos2.size() < seqsToUse.size() && (node = seqTree.nextLeafNode()) != null) {
            SeqConfs confs = (SeqConfs)node.getData();
            if (confs == null) {
                seqLB = node.getScore();
                this.log("Estimated Sequence: %s   Sequence minimized lower bound: %12.6f", node.makeSequence(this.state.confSpace.seqSpace), seqLB);
                confs = new SeqConfs(this, node);
                double curScore = confs.refineBounds();
                node.setData(confs);
            }
            if (confs.stateConfs.isWT) {
                wtFound = true;
                wtSpot = seqNum;
                wtEnergy = confs.stateConfs.wtConf.getEnergy();
                wtPfLB = Math.log10(bc.calc(wtEnergy).doubleValue());
                System.out.println("Found wild-type sequence in complex after " + seqNum + " sequences.");
                System.out.println("Finding all sequences within " + this.eW + " kcal of WT minimized energy: " + wtEnergy + " or until " + seqsToUse.size() + " sequences are enumerated.");
            }
            Sequence newSequence = node.makeSequence(this.state.confSpace.seqSpace);
            double pfUB = Math.log10(bc.calc(confs.stateConfs.lowestScoringConf.getScore()).multiply(new BigDecimal(this.getNumConfsForSeq(newSequence, this.state.confSpace))).doubleValue());
            SequenceInfo info2 = new SequenceInfo(this, node, confs, pfUB);
            if (!wtFound.booleanValue()) {
                infos2.add(info2);
                ++seqNum;
                this.reportSequence(infos2.size() == 1, info2);
                continue;
            }
            if (seqLB > wtEnergy + this.eW) {
                if (infos2.size() >= seqsToUse.size()) {
                    didSeqMax = true;
                }
                didEW = true;
                break;
            }
            if (infos2.size() >= seqsToUse.size()) {
                didSeqMax = true;
                break;
            }
            if (!(confs.stateConfs.lowestScoringConf.getScore() < wtEnergy + this.eW) || !(pfUB > wtPfLB - (double)orderMag)) continue;
            infos2.add(info2);
            ++seqNum;
            this.reportSequence(infos2.size() == 1, info2);
        }
        ArrayList<SequenceInfo> badPfs = new ArrayList<SequenceInfo>();
        for (int i = 0; i < wtSpot; ++i) {
            if (!(((SequenceInfo)infos2.get((int)i)).pfUB < wtPfLB - (double)orderMag) && !(((SequenceInfo)infos2.get((int)i)).lowestConf.getScore() > wtEnergy + this.eW)) continue;
            badPfs.add((SequenceInfo)infos2.get(i));
        }
        infos2.removeAll(badPfs);
        this.log("", new Object[0]);
        if (infos2.isEmpty()) {
            this.log("EWAK* didn't find any sequences within the window that satisfy all the constraints.", new Object[0]);
        } else {
            this.log("EWAK* found the best %d sequences within %d orders of magnitude of the wild-type sequence partition function.", infos2.size(), orderMag);
        }
        if (didEW.booleanValue()) {
            this.log("Found all sequences within %1.0f kcal/mol of the wild-type sequence.", this.eW);
        } else {
            this.log("The energy window of %1.0f kcal/mol was not fully enumerated.", this.eW);
        }
        if (didSeqMax) {
            this.log("The sequence number max of %d was enumerated.", seqsToUse.size());
        } else if (didEW.booleanValue()) {
            this.log("The energy window was completed before enumerating the requested number of sequences.", new Object[0]);
        } else if (!didSeqMax && !didEW.booleanValue()) {
            this.log("Exhaustively enumerated all sequence possibilities!", new Object[0]);
        }
        return infos2;
    }

    private void log(String msg, Object ... args) {
        if (this.printToConsole) {
            Log.log(msg, args);
        }
    }

    public BigInteger getNumConfsForSeq(Sequence seq, SimpleConfSpace confSpace) {
        BigInteger myNum = seq.makeRCs(confSpace).getNumConformations();
        return myNum;
    }

    private void reportSequence(boolean isFirstSequence, SequenceInfo info2) {
        if (this.printToConsole) {
            int cellSize = info2.sequence.calcCellSize();
            this.log("\nFully calculated sequence: %s      %s\n                           %s", info2.sequence.toString(Sequence.Renderer.ResNum, cellSize), info2.sequence.isWildType() ? "Wild-type" : "", info2.sequence.toString(Sequence.Renderer.ResTypeMutations, cellSize));
            this.log("\tState: %-3s    Conformation minimized lower bound: %12.6f\n", this.state.name, info2.lowestConf.getScore());
        }
        if (this.logFile != null) {
            StringBuilder header = null;
            if (isFirstSequence) {
                header = new StringBuilder();
                for (SeqSpace.Position position : this.seqSpace.positions) {
                    if (position.index > 0) {
                        header.append("\t");
                    }
                    header.append(position.resNum);
                }
                header.append("\t");
                header.append(this.state.name);
                header.append(" Lowest minBound Energy\t");
                header.append(this.state.name);
                header.append(" Conf");
            }
            StringBuilder buf = new StringBuilder();
            for (SeqSpace.Position pos : this.seqSpace.positions) {
                if (pos.index > 0) {
                    buf.append("\t");
                }
                buf.append(info2.sequence.get(pos).mutationName());
            }
            buf.append("\t");
            ConfSearch.ScoredConf scoredConf = info2.lowestConf;
            buf.append("\t");
            buf.append(String.format("%.6f", scoredConf.getScore()));
            buf.append("\t");
            buf.append(Conf.toString(scoredConf.getAssignments()));
            try (FileWriter out = new FileWriter(this.logFile, !isFirstSequence);){
                if (header != null) {
                    out.write(header.toString());
                    out.write("\n");
                }
                out.write(buf.toString());
                out.write("\n");
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                if (header != null) {
                    System.err.println(header);
                }
                System.err.println(buf);
            }
        }
    }

    public static class State {
        public final String name;
        public final SimpleConfSpace confSpace;
        public FragmentEnergies fragmentEnergies;
        public ConfEnergyCalculator confEcalc;
        public ConfEnergyCalculator confRigidEcalc;
        public Function<RCs, ConfAStarTree> confTreeFactoryMin;
        public Function<RCs, ConfAStarTree> confTreeFactoryRigid;
        public EnergyMatrix ematRigid;
        public EnergyMatrix emat;

        public State(String name, SimpleConfSpace confSpace) {
            this.name = name;
            this.confSpace = confSpace;
        }

        public void checkConfig() {
            if (this.fragmentEnergies == null) {
                throw new InitException(this, "fragmentEnergies");
            }
            if (this.confEcalc == null) {
                throw new InitException(this, "confEcalc");
            }
            if (this.confTreeFactoryMin == null) {
                throw new InitException(this, "confTreeFactoryMin");
            }
            if (this.confTreeFactoryRigid == null) {
                throw new InitException(this, "confTreeFactoryRigid");
            }
        }

        public double getSingleEnergy(int pos, int rc) {
            return this.fragmentEnergies.getEnergy(pos, rc);
        }

        public double getPairEnergy(int pos1, int rc1, int pos2, int rc2) {
            return this.fragmentEnergies.getEnergy(pos1, rc1, pos2, rc2);
        }

        public static class InitException
        extends RuntimeException {
            public InitException(State state, String name) {
                super(String.format("set %s for state %s before running", name, state.name));
            }
        }
    }

    public class SequenceInfo {
        public final Sequence sequence;
        public final ConfSearch.ScoredConf lowestConf;
        public final double pfUB;
        public final boolean isWT;
        public boolean canPrune = false;

        public SequenceInfo(EwakstarDoer this$0, SeqAStarNode node, SeqConfs confs, double pfUB) {
            this.sequence = node.makeSequence(this$0.seqSpace);
            this.isWT = confs.stateConfs.isWT;
            this.lowestConf = confs.stateConfs.lowestScoringConf;
            this.pfUB = pfUB;
        }

        public void setCanPrune(boolean val) {
            this.canPrune = val;
        }
    }

    public static class Results {
        private EWAKStarBBKStar bbkstar;
        public List<Sequence> sequences;
    }

    public static class Builder {
        private State state;
        private double eW = 10.0;
        int numCPUs = 4;
        private String mutableType = "all";
        private int numMutable = Integer.MAX_VALUE;
        private boolean printToConsole = true;
        private boolean seqFilterOnly = false;
        private Double numEWAKStarSeqs = Double.POSITIVE_INFINITY;
        private int orderOfMag = 5;
        private double pfEw = 1.0;
        private int numPfConfs = 500;
        private int numTopOverallSeqs = 10;
        private boolean useWtBenchmark = false;
        private double epsilon = 0.68;
        private int smaNodes;
        private boolean useSMA = false;
        private boolean printPDBs = false;
        private File logFile = null;

        public Builder setEpsilon(double val) {
            this.epsilon = val;
            return this;
        }

        public Builder setNumEWAKStarSeqs(Double val) {
            this.numEWAKStarSeqs = val;
            return this;
        }

        public Builder setUseWtBenchmark(boolean val) {
            this.useWtBenchmark = val;
            return this;
        }

        public Builder setOrderOfMag(int val) {
            this.orderOfMag = val;
            return this;
        }

        public Builder setPfEw(double val) {
            this.pfEw = val;
            return this;
        }

        public Builder setNumPfConfs(int val) {
            this.numPfConfs = val;
            return this;
        }

        public Builder setNumTopOverallSeqs(int val) {
            this.numTopOverallSeqs = val;
            return this;
        }

        public Builder setSeqFilterOnly(boolean val) {
            this.seqFilterOnly = val;
            return this;
        }

        public Builder addState(State s) {
            this.state = s;
            return this;
        }

        public Builder setNumMutable(int val) {
            this.numMutable = val;
            return this;
        }

        public Builder setEw(double val) {
            this.eW = val;
            return this;
        }

        public Builder setMutableType(String type) {
            if (!(type.equals("max") || type.equals("all") || type.equals("exact"))) {
                throw new InitException(type);
            }
            this.mutableType = type;
            return this;
        }

        public Builder setNumCpus(int val) {
            this.numCPUs = val;
            return this;
        }

        public Builder setPrintToConsole(boolean val) {
            this.printToConsole = val;
            return this;
        }

        public Builder setLogFile(File val) {
            this.logFile = val;
            return this;
        }

        public Builder setupSMA(boolean val, int num) {
            this.useSMA = val;
            this.smaNodes = num;
            return this;
        }

        public Builder setPrintPDBs(boolean val) {
            this.printPDBs = val;
            return this;
        }

        public EwakstarDoer build() {
            return new EwakstarDoer(this.printPDBs, this.useSMA, this.smaNodes, this.state, this.eW, this.mutableType, this.numMutable, this.numCPUs, this.printToConsole, this.seqFilterOnly, this.logFile, this.numEWAKStarSeqs, this.useWtBenchmark, this.orderOfMag, this.pfEw, this.numPfConfs, this.epsilon, this.numTopOverallSeqs);
        }

        public static class InitException
        extends RuntimeException {
            public InitException(String mutType) {
                super(String.format("The value entered, %s,  is not a valid mutableType setting. Please set it to max, all, or exact.", mutType));
            }
        }
    }

    private class SeqHScorer
    implements SeqAStarScorer {
        MathTools.Optimizer opt = MathTools.Optimizer.Minimize;
        List<SimpleConfSpace.Position> allPositions = new ArrayList<SimpleConfSpace.Position>();
        State statesByAllPosition;

        SeqHScorer() {
            for (SimpleConfSpace.Position pos : EwakstarDoer.this.state.confSpace.positions) {
                this.allPositions.add(pos);
                this.statesByAllPosition = EwakstarDoer.this.state;
            }
        }

        @Override
        public double calc(SeqAStarNode.Assignments assignments) {
            double score = 0.0;
            for (int i1 = 0; i1 < this.allPositions.size(); ++i1) {
                SimpleConfSpace.Position pos1 = this.allPositions.get(i1);
                double bestPos1Energy = this.opt.initDouble();
                for (SeqSpace.ResType rt1 : this.getRTs(pos1, assignments)) {
                    double bestRC1Energy = this.opt.initDouble();
                    for (SimpleConfSpace.ResidueConf rc1 : this.getRCs(pos1, rt1, EwakstarDoer.this.state)) {
                        double rc1Energy = 0.0;
                        rc1Energy += EwakstarDoer.this.state.getSingleEnergy(pos1.index, rc1.index);
                        for (int i2 = 0; i2 < pos1.index; ++i2) {
                            SimpleConfSpace.Position pos2 = EwakstarDoer.this.state.confSpace.positions.get(i2);
                            double bestRT2Energy = this.opt.initDouble();
                            for (SeqSpace.ResType rt2 : this.getRTs(pos2, assignments)) {
                                double bestRC2Energy = this.opt.initDouble();
                                for (SimpleConfSpace.ResidueConf rc2 : this.getRCs(pos2, rt2, EwakstarDoer.this.state)) {
                                    double rc2Energy = EwakstarDoer.this.state.getPairEnergy(pos1.index, rc1.index, pos2.index, rc2.index);
                                    bestRC2Energy = this.opt.opt(bestRC2Energy, rc2Energy);
                                }
                                bestRT2Energy = this.opt.opt(bestRT2Energy, bestRC2Energy);
                            }
                            rc1Energy += bestRT2Energy;
                        }
                        bestRC1Energy = this.opt.opt(bestRC1Energy, rc1Energy);
                    }
                    bestPos1Energy = this.opt.opt(bestPos1Energy, bestRC1Energy);
                }
                score += bestPos1Energy;
            }
            return score;
        }

        List<SeqSpace.ResType> getRTs(SimpleConfSpace.Position confPos, SeqAStarNode.Assignments assignments) {
            SeqSpace.Position seqPos = EwakstarDoer.this.seqSpace.getPosition(confPos.resNum);
            if (seqPos != null) {
                Integer assignedRT = assignments.getAssignment(seqPos.index);
                if (assignedRT != null) {
                    return Collections.singletonList(seqPos.resTypes.get(assignedRT));
                }
                return seqPos.resTypes;
            }
            assert (confPos.resTypes.size() == 1);
            return Collections.singletonList(null);
        }

        List<SimpleConfSpace.ResidueConf> getRCs(SimpleConfSpace.Position pos, SeqSpace.ResType rt, State state) {
            if (rt != null) {
                return pos.resConfs.stream().filter(rc -> rc.template.name.equals(rt.name)).collect(Collectors.toList());
            }
            return pos.resConfs;
        }
    }

    private class SeqConfs {
        final StateConfs stateConfs;

        SeqConfs(EwakstarDoer ewakstarDoer, SeqAStarNode seqNode) {
            Sequence sequence = seqNode.makeSequence(ewakstarDoer.state.confSpace.seqSpace).filter(ewakstarDoer.state.confSpace.seqSpace);
            StateConfs.Key key = new StateConfs.Key(sequence, ewakstarDoer.state);
            StateConfs collectedConfs = ewakstarDoer.stateConfsCache.get(key);
            if (collectedConfs == null) {
                collectedConfs = new StateConfs(sequence, ewakstarDoer.state);
                ewakstarDoer.stateConfsCache.put(key, collectedConfs);
            }
            this.stateConfs = collectedConfs;
        }

        public double refineBounds() {
            this.stateConfs.getLowestScoringConf();
            double score = 0.0;
            StateConfs stateConfs = this.stateConfs;
            return score += stateConfs.getObjectiveLowerBound();
        }
    }

    private static class StateConfs {
        final State state;
        final Sequence sequence;
        ConfAStarTree confTree = null;
        ConfSearch.ScoredConf lowestScoringConf = null;
        ConfSearch.EnergiedConf wtConf = null;
        boolean isWT = false;
        List<ConfSearch.ScoredConf> confs = new ArrayList<ConfSearch.ScoredConf>();

        StateConfs(Sequence sequence, State state) {
            this.state = state;
            this.sequence = sequence;
            RCs rcs = sequence.makeRCs(state.confSpace);
            this.confTree = state.confTreeFactoryMin.apply(rcs);
            this.setIsWildType(this.sequence.toString().equals(this.state.confSpace.makeWildTypeSequence().toString()));
        }

        void setIsWildType(boolean val) {
            this.isWT = val;
        }

        void getLowestScoringConf() {
            this.confs.clear();
            if (this.isWT) {
                this.lowestScoringConf = this.confTree.nextConf();
                this.wtConf = this.state.confEcalc.calcEnergy(this.lowestScoringConf);
            } else {
                this.lowestScoringConf = this.confTree.nextConf();
            }
            this.confs.clear();
        }

        double getObjectiveLowerBound() {
            return this.lowestScoringConf.getScore();
        }

        private static class Key {
            final Sequence sequence;
            final State state;

            Key(Sequence sequence, State state) {
                this.sequence = sequence;
                this.state = state;
            }

            public int hashCode() {
                return HashCalculator.combineHashes(this.sequence.hashCode(), this.state.hashCode());
            }

            public boolean equals(Object other) {
                return other instanceof Key && this.equals((Key)other);
            }

            public boolean equals(Key other) {
                return this.sequence.equals(other.sequence) && this.state == other.state;
            }
        }
    }
}

