/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gmec;

import edu.duke.cs.osprey.astar.ConfTree;
import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.order.AStarOrder;
import edu.duke.cs.osprey.astar.conf.order.DynamicHMeanAStarOrder;
import edu.duke.cs.osprey.astar.conf.order.StaticScoreHMeanAStarOrder;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.astar.conf.scoring.MPLPPairwiseHScorer;
import edu.duke.cs.osprey.astar.conf.scoring.PairwiseGScorer;
import edu.duke.cs.osprey.astar.conf.scoring.TraditionalPairwiseHScorer;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.EdgeUpdater;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.MPLPUpdater;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.NodeUpdater;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.multistatekstar.MSSearchProblem;
import edu.duke.cs.osprey.multistatekstar.MultiSequenceConfTree;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.pruning.PruningMatrix;

public interface ConfSearchFactory {
    public ConfSearch make(EnergyMatrix var1, PruningMatrix var2);

    public static class Tools {
        public static ConfSearchFactory makeFromConfig(final SearchProblem search2, final ConfigFileParser cfp) {
            return new ConfSearchFactory(){

                @Override
                public ConfSearch make(EnergyMatrix emat, PruningMatrix pmat) {
                    AStarOrder order;
                    AStarScorer hscorer;
                    if (emat.getNumPos() != pmat.getNumPos()) {
                        throw new Error("energy matrix doesn't match pruning matrix, this is a bug");
                    }
                    if (search2.searchNeedsHigherOrderTerms() || search2.useEPIC || cfp.hasGMECMutFile()) {
                        return ConfTree.makeFull(search2, pmat, cfp.parseGMECMutFile(search2.confSpace));
                    }
                    if (search2 instanceof MSSearchProblem && !((MSSearchProblem)search2).isFullyAssigned()) {
                        return new MultiSequenceConfTree((MSSearchProblem)search2, emat, pmat);
                    }
                    PairwiseGScorer gscorer = new PairwiseGScorer(emat);
                    RCs rcs = new RCs(pmat);
                    int numMPLPIters = cfp.params.getInt("NumMPLPIters");
                    if (numMPLPIters <= 0) {
                        hscorer = new TraditionalPairwiseHScorer(emat, rcs);
                        order = new DynamicHMeanAStarOrder();
                    } else {
                        MPLPUpdater updater = cfp.params.getValue("MPLPAlg").equalsIgnoreCase("node") ? new NodeUpdater() : new EdgeUpdater();
                        double convergenceThreshold = cfp.params.getDouble("MPLPConvergenceThreshold");
                        hscorer = new MPLPPairwiseHScorer(updater, emat, numMPLPIters, convergenceThreshold);
                        order = new StaticScoreHMeanAStarOrder();
                    }
                    ConfAStarTree tree = new ConfAStarTree.Builder(search2.emat, rcs).setCustom(order, gscorer, hscorer).build();
                    tree.setParallelism(Parallelism.makeCpu(cfp.params.getInt("AStarThreads")));
                    tree.initProgress();
                    return tree;
                }
            };
        }
    }
}

