/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gmec;

import edu.duke.cs.osprey.astar.ConfTree;
import edu.duke.cs.osprey.astar.FullAStarNode;
import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.control.ConfPrinter;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.gmec.ConfSearchFactory;
import edu.duke.cs.osprey.gmec.EnergyRange;
import edu.duke.cs.osprey.gmec.GMECConfEnergyCalculator;
import edu.duke.cs.osprey.gmec.MinimizingConfEnergyCalculator;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.partcr.PartCRConfPruner;
import edu.duke.cs.osprey.pruning.Pruner;
import edu.duke.cs.osprey.pruning.PruningControl;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.Progress;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GMECFinder {
    private SearchProblem searchSpace;
    private PruningControl pruningControl;
    private ConfSearchFactory confSearchFactory;
    private GMECConfEnergyCalculator.Async ecalc = null;
    private ConfPruner confPruner = null;
    private double Ew;
    private double I0 = 0.0;
    private boolean doIMinDEE;
    private boolean useContFlex;
    private boolean outputGMECStruct;
    boolean useEPIC = false;
    public boolean useTupExp = false;
    private boolean checkApproxE = true;
    public boolean EFullConfOnly = false;
    private String confFileName;
    private double stericThresh;
    private boolean logConfsToConsole = true;
    private double lowestBound;
    private boolean usePLUG;
    static boolean PLUGPruneTriples = true;
    private boolean useDEE = true;

    public void init(SearchProblem search2, PruningControl pruningControl, ConfSearchFactory confSearchFactory, GMECConfEnergyCalculator.Async ecalc, double Ew, boolean doIMinDEE, double I0, boolean useContFlex, boolean useTupExp, boolean useEPIC, boolean checkApproxE, boolean outputGMECStruct, boolean eFullConfOnly, String confFileName, double stericThresh) {
        this.searchSpace = search2;
        this.pruningControl = pruningControl;
        this.confSearchFactory = confSearchFactory;
        this.ecalc = ecalc;
        this.Ew = Ew;
        this.doIMinDEE = doIMinDEE;
        this.I0 = I0;
        this.useContFlex = useContFlex;
        this.useTupExp = useTupExp;
        this.useEPIC = useEPIC;
        this.checkApproxE = checkApproxE;
        this.outputGMECStruct = outputGMECStruct;
        this.EFullConfOnly = eFullConfOnly;
        this.confFileName = confFileName;
        this.stericThresh = stericThresh;
    }

    public void init(ConfigFileParser cfp) {
        this.init(cfp, cfp.getSearchProblem());
    }

    public void init(ConfigFileParser cfp, SearchProblem search2) {
        this.searchSpace = search2;
        this.Ew = cfp.params.getDouble("Ew");
        this.doIMinDEE = cfp.params.getBool("imindee");
        if (this.doIMinDEE) {
            this.I0 = cfp.params.getDouble("Ival");
        }
        this.useContFlex = cfp.params.getBool("doMinimize") || cfp.params.getBool("doPerturbations");
        this.useTupExp = cfp.params.getBool("UseTupExp");
        this.useEPIC = cfp.params.getBool("UseEPIC");
        this.checkApproxE = cfp.params.getBool("CheckApproxE");
        if (this.doIMinDEE && !this.useContFlex) {
            throw new RuntimeException("ERROR: iMinDEE requires continuous flexibility");
        }
        this.outputGMECStruct = cfp.params.getBool("OUTPUTGMECSTRUCT");
        this.EFullConfOnly = cfp.params.getBool("UsePoissonBoltzmann");
        this.usePLUG = cfp.params.getBool("UsePLUG", false);
        this.useDEE = cfp.params.getBool("USEDEE", true);
        if (!this.useDEE) {
            this.doIMinDEE = false;
        }
        this.confFileName = cfp.params.getRunSpecificFileName("CONFFILENAME", ".confs.txt");
        this.stericThresh = cfp.params.getDouble("StericThresh");
        this.pruningControl = new PruningControl(this.searchSpace, 0.0, cfp.params.getBool("TYPEDEP"), cfp.params.getDouble("BOUNDSTHRESH"), cfp.params.getInt("ALGOPTION"), cfp.params.getBool("USEFLAGS"), cfp.params.getBool("USETRIPLES"), false, false, false, this.stericThresh);
        this.confSearchFactory = ConfSearchFactory.Tools.makeFromConfig(this.searchSpace, cfp);
        if (cfp.params.getBool("UsePartCR")) {
            this.setConfPruner(new PartCRConfPruner(search2, this.Ew));
        }
        if (this.useContFlex || this.EFullConfOnly) {
            if ((this.useEPIC || this.useTupExp) && !this.checkApproxE || this.searchSpace.useVoxelG) {
                this.ecalc = new GMECConfEnergyCalculator.Async.Adapter(new GMECConfEnergyCalculator(){

                    @Override
                    public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf) {
                        double energy = GMECFinder.this.searchSpace.approxMinimizedEnergy(conf.getAssignments());
                        return new ConfSearch.EnergiedConf(conf, energy);
                    }
                });
            } else {
                boolean avoidCopyingMolecules = this.EFullConfOnly;
                if (avoidCopyingMolecules) {
                    System.out.println("\n\nWARNING: concurrent minimizations disabled\n");
                    this.ecalc = new GMECConfEnergyCalculator.Async.Adapter(new GMECConfEnergyCalculator(){

                        @Override
                        public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf) {
                            double energy = GMECFinder.this.searchSpace.minimizedEnergy(conf.getAssignments());
                            return new ConfSearch.EnergiedConf(conf, energy);
                        }
                    });
                } else {
                    ForcefieldParams ffparams = EnvironmentVars.curEFcnGenerator.ffParams;
                    Parallelism parallelism = Parallelism.makeFromConfig(cfp);
                    this.ecalc = MinimizingConfEnergyCalculator.make(ffparams, search2, parallelism);
                }
            }
        } else {
            this.ecalc = new GMECConfEnergyCalculator.Async.Adapter(new GMECConfEnergyCalculator(this){

                @Override
                public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf) {
                    return new ConfSearch.EnergiedConf(conf, conf.getScore());
                }
            });
        }
    }

    public void setLogConfsToConsole(boolean val) {
        this.logConfsToConsole = val;
    }

    public void setConfPruner(ConfPruner val) {
        this.confPruner = val;
    }

    public List<ConfSearch.EnergiedConf> calcGMEC() {
        return this.calcGMEC(this.I0);
    }

    public double calcGMECEnergy() {
        return this.calcGMEC().get(0).getEnergy();
    }

    private List<ConfSearch.EnergiedConf> calcGMEC(double interval) {
        ConfSearch.ScoredConf conf;
        System.out.println("Calculating GMEC with interval = " + interval);
        boolean printEPICEnergy = this.checkApproxE && this.useEPIC && this.useTupExp;
        final ConfPrinter confPrinter = new ConfPrinter(this.searchSpace, this.confFileName, printEPICEnergy);
        if (this.useEPIC) {
            this.checkEPICThresh2(interval);
        }
        this.precomputeMatrices(this.Ew + interval);
        System.out.println("Searching for min score conformation...");
        Stopwatch minScoreStopwatch = new Stopwatch().start();
        ConfSearch confSearch = this.confSearchFactory.make(this.searchSpace.emat, this.searchSpace.pruneMat);
        try {
            System.out.println("\t(among " + confSearch.getNumConformations().floatValue() + " possibilities)");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ConfSearch.ScoredConf minScoreConf = confSearch.nextConf();
        if (minScoreConf == null) {
            System.out.println("All conformations pruned. Try choosing a larger pruning interval or steric threshold.");
            return new ArrayList<ConfSearch.EnergiedConf>();
        }
        System.out.println("Found min score conformation in " + minScoreStopwatch.getTime(1));
        System.out.println("Computing energy...");
        ConfSearch.EnergiedConf eMinScoreConf = this.ecalc.calcEnergy(minScoreConf);
        confPrinter.printConf(eMinScoreConf);
        System.out.println("\nMIN SCORE CONFORMATION");
        System.out.print(confPrinter.getConfReport(eMinScoreConf));
        final ArrayList<ConfSearch.EnergiedConf> econfs = new ArrayList<ConfSearch.EnergiedConf>();
        econfs.add(eMinScoreConf);
        final EnergyRange window = new EnergyRange(eMinScoreConf.getEnergy(), this.Ew);
        this.setWindowProgress(confSearch, window);
        System.out.println("Enumerating other low-scoring conformations...");
        final ArrayList<ConfSearch.ScoredConf> lowEnergyConfs = new ArrayList<ConfSearch.ScoredConf>();
        Stopwatch stopwatch = new Stopwatch().start();
        lowEnergyConfs.add(minScoreConf);
        int indexToMinimizeNext = 1;
        while ((conf = confSearch.nextConf()) != null) {
            lowEnergyConfs.add(conf);
            if (conf.getScore() >= window.getMax()) break;
            if (!(stopwatch.getTimeS() >= 10.0)) continue;
            stopwatch.stop();
            ConfSearch.EnergiedConf econf = this.ecalc.calcEnergy((ConfSearch.ScoredConf)lowEnergyConfs.get(indexToMinimizeNext++));
            this.handleEnergiedConf(econfs, confPrinter, window, econf);
            boolean changed = window.updateMin(econf.getEnergy());
            if (changed) {
                System.out.println(String.format("Lower conformation energy updated energy window! remaining: %14.8f", window.getMax() - conf.getScore()));
                this.setWindowProgress(confSearch, window);
            }
            stopwatch.start();
        }
        System.out.println(String.format("\tFound %d more", lowEnergyConfs.size() - 1));
        confSearch = null;
        if (!lowEnergyConfs.isEmpty()) {
            if (this.confPruner != null) {
                this.confPruner.prune(lowEnergyConfs, this.ecalc);
            }
            final Progress progress2 = new Progress(lowEnergyConfs.size());
            progress2.setProgress(indexToMinimizeNext);
            GMECConfEnergyCalculator.Async.Listener ecalcListener = new GMECConfEnergyCalculator.Async.Listener(){

                @Override
                public void onFinished(ConfSearch.EnergiedConf econf) {
                    GMECFinder.this.handleEnergiedConf(econfs, confPrinter, window, econf);
                    progress2.incrementProgress();
                    boolean changed = window.updateMin(econf.getEnergy());
                    if (changed) {
                        for (int i = lowEnergyConfs.size() - 1; i >= 0 && ((ConfSearch.ScoredConf)lowEnergyConfs.get(i)).getScore() > window.getMax(); --i) {
                            lowEnergyConfs.remove(i);
                        }
                        System.out.println(String.format("\nNew lowest energy: %.6f", window.getMin()));
                        System.out.println(String.format("\tReduced to %d low-energy conformations", lowEnergyConfs.size()));
                        progress2.setTotalWork(lowEnergyConfs.size());
                    }
                }
            };
            System.out.println(String.format("\nComputing energies for %d conformations...", lowEnergyConfs.size()));
            while (indexToMinimizeNext < lowEnergyConfs.size()) {
                this.ecalc.calcEnergyAsync((ConfSearch.ScoredConf)lowEnergyConfs.get(indexToMinimizeNext), ecalcListener);
                ++indexToMinimizeNext;
            }
            this.ecalc.getTasks().waitForFinish();
        }
        Collections.sort(econfs, new Comparator<ConfSearch.EnergiedConf>(this){

            @Override
            public int compare(ConfSearch.EnergiedConf a, ConfSearch.EnergiedConf b) {
                return Double.compare(a.getEnergy(), b.getEnergy());
            }
        });
        ConfSearch.EnergiedConf minEnergyConf = (ConfSearch.EnergiedConf)econfs.get(0);
        if (this.doIMinDEE) {
            this.lowestBound = this.useEPIC || this.useTupExp ? this.lowestPairwiseBound(this.searchSpace) : minScoreConf.getScore();
            if (minEnergyConf.getEnergy() > this.lowestBound + interval) {
                System.out.println("Pruning interval is too small. minGMEC could have been pruned.");
                System.out.println("Will estimate new interval based on conformations evaluated so far and restart");
                double nextInterval = minEnergyConf.getEnergy() - this.lowestBound;
                double intervalPad = 0.001;
                if (this.searchSpace.useVoxelG) {
                    intervalPad = 0.2;
                }
                return this.calcGMEC(nextInterval += intervalPad);
            }
        }
        ConfSearch.EnergiedConf minGMEC = minEnergyConf;
        System.out.println(String.format("\nFound minGMEC!", new Object[0]));
        System.out.print(confPrinter.getConfReport(minGMEC));
        if (this.outputGMECStruct) {
            this.searchSpace.outputMinimizedStruct(minGMEC.getAssignments(), this.searchSpace.name + ".GMEC.pdb");
        }
        Iterator iter = econfs.iterator();
        while (iter.hasNext()) {
            ConfSearch.EnergiedConf econf = (ConfSearch.EnergiedConf)iter.next();
            if (!(econf.getEnergy() > minGMEC.getEnergy() + this.Ew)) continue;
            iter.remove();
        }
        if (this.Ew > 0.0) {
            System.out.println(String.format("Also found %d more conformations in energy window", econfs.size() - 1));
        }
        if (this.ecalc instanceof MinimizingConfEnergyCalculator) {
            ((MinimizingConfEnergyCalculator)this.ecalc).clean();
        }
        return econfs;
    }

    private void handleEnergiedConf(List<ConfSearch.EnergiedConf> econfs, ConfPrinter confPrinter, EnergyRange window, ConfSearch.EnergiedConf econf) {
        econfs.add(econf);
        confPrinter.printConf(econf);
        if (this.logConfsToConsole) {
            System.out.println("\nENUMERATING CONFORMATION");
            System.out.print(confPrinter.getConfReport(econf, window));
        }
    }

    private void setWindowProgress(ConfSearch confSearch, EnergyRange window) {
        ConfAStarTree tree;
        if (confSearch instanceof ConfAStarTree && (tree = (ConfAStarTree)confSearch).getProgress() != null) {
            tree.getProgress().setGoalScore(window.getMax());
        }
    }

    public List<ConfSearch.ScoredConf> calcSequences() {
        return this.calcSequences(this.I0);
    }

    public List<ConfSearch.ScoredConf> calcSequences(double interval) {
        ConfSearch.ScoredConf conf;
        System.out.println("Finding sequences with interval " + interval + " and energy window " + this.Ew + " ...");
        boolean printEPICEnergy = this.checkApproxE && this.useEPIC && this.useTupExp;
        ConfPrinter confPrinter = new ConfPrinter(this.searchSpace, this.confFileName, printEPICEnergy);
        if (this.useEPIC) {
            this.checkEPICThresh2(interval);
        }
        this.precomputeMatrices(this.Ew + interval);
        System.out.println("Searching for min score conformation...");
        Stopwatch minScoreStopwatch = new Stopwatch().start();
        ConfSearch confSearch = this.confSearchFactory.make(this.searchSpace.emat, this.searchSpace.pruneMat);
        try {
            System.out.println("\t(among " + confSearch.getNumConformations().floatValue() + " possibilities)");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ConfSearch.ScoredConf minScoreConf = confSearch.nextConf();
        if (minScoreConf == null) {
            System.out.println("All conformations pruned. Try choosing a larger pruning interval.");
            return new ArrayList<ConfSearch.ScoredConf>();
        }
        System.out.println("Found min score conformation in " + minScoreStopwatch.getTime(1));
        System.out.println("Computing energy...");
        ConfSearch.EnergiedConf eMinScoreConf = this.ecalc.calcEnergy(minScoreConf);
        System.out.println("\nMIN SCORE CONFORMATION");
        System.out.print(confPrinter.getConfReport(eMinScoreConf));
        ArrayList<ConfSearch.ScoredConf> sequenceConfs = new ArrayList<ConfSearch.ScoredConf>();
        HashSet<String> sequenceKeys = new HashSet<String>();
        sequenceConfs.add(minScoreConf);
        sequenceKeys.add(this.makeSequenceKey(minScoreConf));
        EnergyRange window = new EnergyRange(eMinScoreConf.getEnergy(), this.Ew);
        System.out.println("Enumerating other low-scoring conformations...");
        while ((conf = confSearch.nextConf()) != null) {
            boolean isNewSequence = sequenceKeys.add(this.makeSequenceKey(conf));
            if (isNewSequence) {
                if (this.logConfsToConsole) {
                    System.out.println("\nUNIQUE SEQUENCE " + sequenceConfs.size());
                    System.out.print(confPrinter.getConfReport(conf, window));
                }
                sequenceConfs.add(conf);
            }
            if (!(conf.getScore() >= window.getMax())) continue;
            break;
        }
        return sequenceConfs;
    }

    private String makeSequenceKey(ConfSearch.ScoredConf conf) {
        StringBuilder buf = new StringBuilder();
        for (int pos = 0; pos < this.searchSpace.confSpace.numPos; ++pos) {
            String aaType = this.searchSpace.confSpace.posFlex.get((int)pos).RCs.get((int)conf.getAssignments()[pos]).AAType;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(aaType);
        }
        return buf.toString();
    }

    public double getLowestBound() {
        return this.lowestBound;
    }

    public void precomputeMatrices(double pruningInterval) {
        if (this.EFullConfOnly) {
            this.fullConfOnlyTupExp();
            return;
        }
        if (this.searchSpace.useVoxelG) {
            this.voxelGTupExp();
            return;
        }
        if (this.searchSpace.emat == null) {
            this.searchSpace.loadEnergyMatrix();
        }
        if (this.searchSpace.competitorPruneMat == null && this.useDEE) {
            System.out.println("PRECOMPUTING COMPETITOR PRUNING MATRIX");
            this.initPruning(0.0, false, false);
            if (this.usePLUG) {
                this.searchSpace.loadPLUGMatrix();
                this.searchSpace.plugMat.doMultiTermPruning(this.searchSpace.pruneMat, PLUGPruneTriples);
            }
            this.pruningControl.setOnlyGoldstein(true);
            this.pruningControl.prune();
            this.searchSpace.competitorPruneMat = this.searchSpace.pruneMat;
            this.searchSpace.pruneMat = null;
            System.out.println("COMPETITOR PRUNING DONE");
        }
        this.initPruning(pruningInterval, false, false);
        if (this.usePLUG) {
            this.searchSpace.loadPLUGMatrix();
            this.searchSpace.plugMat.doMultiTermPruning(this.searchSpace.pruneMat, PLUGPruneTriples);
        }
        if (this.useDEE) {
            this.pruningControl.prune();
        }
        if (this.useEPIC) {
            this.searchSpace.loadEPICMatrix();
            if (this.searchSpace.epicSettings.useEPICPruning && this.useDEE) {
                System.out.println("Beginning post-EPIC pruning.");
                this.initPruning(pruningInterval, true, false);
                this.pruningControl.prune();
                System.out.println("Finished post-EPIC pruning.");
            }
        }
        if (this.useTupExp) {
            this.searchSpace.loadTupExpEMatrix();
            if (this.useDEE) {
                System.out.println("Beginning post-tup-exp pruning.");
                this.initPruning(this.Ew, false, true);
                this.pruningControl.prune();
                System.out.println("Finished post-tup-exp pruning.");
            }
        }
    }

    private void initPruning(double pruningInterval, boolean useEPIC, boolean useTupExp) {
        if (this.searchSpace.pruneMat == null || this.searchSpace.pruneMat.getPruningInterval() < pruningInterval) {
            this.searchSpace.pruneMat = new PruningMatrix(this.searchSpace.confSpace, pruningInterval);
        }
        this.pruningControl.setOnlyGoldstein(false);
        this.pruningControl.setPruningInterval(pruningInterval);
        this.pruningControl.setUseEPIC(useEPIC);
        this.pruningControl.setUseTupExp(useTupExp);
    }

    private void fullConfOnlyTupExp() {
        if (!this.useTupExp) {
            throw new RuntimeException("ERROR: Need tuple expansion to handle full-conf-only E-function");
        }
        if (this.useEPIC) {
            throw new RuntimeException("ERROR: EPIC for full-conf-only E-function not yet supported");
        }
        if (this.doIMinDEE) {
            throw new RuntimeException("ERROR: iMinDEE + full-conf-only E-function not supported");
        }
        this.searchSpace.loadEnergyMatrix();
        this.searchSpace.pruneMat = new PruningMatrix(this.searchSpace.confSpace, this.Ew);
        Pruner pruner = new Pruner(this.searchSpace, false, 0.0, 0.0, false, false);
        pruner.pruneSteric(this.stericThresh);
        if (this.usePLUG) {
            this.searchSpace.loadPLUGMatrix();
            this.searchSpace.plugMat.doMultiTermPruning(this.searchSpace.pruneMat, PLUGPruneTriples);
        }
        this.searchSpace.loadTupExpEMatrix();
    }

    private void voxelGTupExp() {
        if (!this.useTupExp) {
            throw new RuntimeException("ERROR: Need tuple expansion to handle voxelG");
        }
        if (!this.useEPIC) {
            throw new RuntimeException("ERROR: Need EPIC to handle voxelG");
        }
        if (this.doIMinDEE) {
            throw new RuntimeException("ERROR: iMinDEE + voxelG not supported");
        }
        this.searchSpace.loadEnergyMatrix();
        this.searchSpace.pruneMat = new PruningMatrix(this.searchSpace.confSpace, this.Ew);
        Pruner pruner = new Pruner(this.searchSpace, false, 0.0, 0.0, false, false);
        pruner.pruneSteric(this.stericThresh);
        if (this.usePLUG) {
            this.searchSpace.loadPLUGMatrix();
            this.searchSpace.plugMat.doMultiTermPruning(this.searchSpace.pruneMat, PLUGPruneTriples);
        }
        this.searchSpace.loadEPICMatrix();
        this.searchSpace.loadTupExpEMatrix();
    }

    public double lowestPairwiseBound(SearchProblem prob) {
        System.out.println();
        System.out.println("Calculating no-EPIC lowest energy bound");
        SearchProblem probNoEPIC = new SearchProblem(prob);
        probNoEPIC.useEPIC = false;
        probNoEPIC.useTupExpForSearch = false;
        ConfTree<FullAStarNode> searchNoEPIC = ConfTree.makeFull(probNoEPIC);
        ConfSearch.ScoredConf LBConf = searchNoEPIC.nextConf();
        double LB = Double.POSITIVE_INFINITY;
        if (LBConf != null) {
            LB = probNoEPIC.lowerBound(LBConf.getAssignments());
        }
        System.out.println("No-EPIC lowest energy bound: " + LB);
        System.out.println();
        return LB;
    }

    private void checkEPICThresh2(double curInterval) {
        if (curInterval + this.Ew > this.searchSpace.epicSettings.EPICThresh2) {
            System.out.println("Raising EPICThresh2 to " + (curInterval + this.Ew) + " based on iMinDEE interval and energy window");
            this.searchSpace.epicSettings.EPICThresh2 = curInterval + this.Ew;
        }
    }

    public static interface ConfPruner {
        public void prune(List<ConfSearch.ScoredConf> var1, GMECConfEnergyCalculator var2);
    }
}

