/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gmec;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.gmec.ConfPrinter;
import edu.duke.cs.osprey.gmec.EnergyRange;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class LoggingConfPrinter
implements ConfPrinter {
    private File file;
    private FileWriter fout;
    private int numConfs;
    private double minEnergy;

    public LoggingConfPrinter(File file) {
        this.file = file;
        try {
            this.fout = new FileWriter(file);
        }
        catch (IOException ex) {
            throw new RuntimeException("can't open log file at: " + file.getAbsolutePath(), ex);
        }
        this.numConfs = 0;
        this.minEnergy = Double.POSITIVE_INFINITY;
    }

    @Override
    public void print(ConfSearch.EnergiedConf conf, SimpleConfSpace confSpace, EnergyRange range) {
        this.minEnergy = Math.min(this.minEnergy, conf.getEnergy());
        try {
            this.fout.write(Integer.toString(this.numConfs));
            this.fout.write(" CONF:");
            for (int rc : conf.getAssignments()) {
                this.fout.write(" ");
                this.fout.write(Integer.toString(rc));
            }
            if (confSpace != null) {
                this.fout.write(" RESTYPES:");
                Object object = confSpace.positions.iterator();
                while (object.hasNext()) {
                    SimpleConfSpace.Position pos = (SimpleConfSpace.Position)object.next();
                    SimpleConfSpace.ResidueConf resConf = pos.resConfs.get(conf.getAssignments()[pos.index]);
                    this.fout.write(" ");
                    this.fout.write(resConf.template.name);
                }
                this.fout.write(" ROTS:");
                for (SimpleConfSpace.Position pos : confSpace.positions) {
                    SimpleConfSpace.ResidueConf resConf = pos.resConfs.get(conf.getAssignments()[pos.index]);
                    this.fout.write(" ");
                    this.fout.write(resConf.getRotamerCode());
                }
            }
            this.fout.write(" Score: ");
            this.fout.write(Double.toString(conf.getScore()));
            this.fout.write(" Energy: ");
            this.fout.write(Double.toString(conf.getEnergy()));
            this.fout.write(" Best so far: ");
            this.fout.write(Double.toString(this.minEnergy));
            this.fout.write("\n");
            this.fout.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException("can't write conf to log file at: " + this.file.getAbsolutePath(), ex);
        }
        ++this.numConfs;
    }

    @Override
    public void cleanup() {
        IOUtils.closeQuietly((Writer)this.fout);
    }
}

