/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gmec;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.ematrix.ReferenceEnergies;
import edu.duke.cs.osprey.energy.FFInterGen;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldInteractions;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.gmec.GMECConfEnergyCalculator;
import edu.duke.cs.osprey.minimization.ConfMinimizer;
import edu.duke.cs.osprey.minimization.CpuConfMinimizer;
import edu.duke.cs.osprey.minimization.GpuConfMinimizer;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.tools.Factory;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class MinimizingConfEnergyCalculator
implements GMECConfEnergyCalculator.Async {
    private ConfMinimizer minimizer;
    private List<ConfPostProcessor> postProcessors;

    public static MinimizingConfEnergyCalculator make(ForcefieldParams ffparams, SearchProblem search2) {
        return MinimizingConfEnergyCalculator.make(ffparams, search2, Parallelism.makeCpu(1));
    }

    public static MinimizingConfEnergyCalculator make(ForcefieldParams ffparams, SearchProblem search2, Parallelism parallelism) {
        Factory<ForcefieldInteractions, Molecule> ffinteractions = mol -> FFInterGen.makeFullConf(search2.confSpace, search2.shellResidues, mol);
        MinimizingConfEnergyCalculator ecalc = new MinimizingConfEnergyCalculator(switch (parallelism.type) {
            case Parallelism.Type.Cpu -> new CpuConfMinimizer.Builder(ffparams, ffinteractions, search2.confSpace).setNumThreads(parallelism.numThreads).build();
            case Parallelism.Type.Gpu -> new GpuConfMinimizer.Builder(ffparams, ffinteractions, search2.confSpace).setGpuInfo(null, parallelism.numGpus, parallelism.numStreamsPerGpu).build();
            default -> throw new Error("unrecognized type: " + String.valueOf((Object)parallelism.type));
        });
        if (search2.useERef) {
            ecalc.addConfPostProcessor(econf -> econf.offsetEnergy(-search2.emat.geteRefMat().confERef(econf.getAssignments())));
        }
        if (search2.addResEntropy) {
            ecalc.addConfPostProcessor(ConfPostProcessor.residueEntropy(search2.confSpace));
        }
        return ecalc;
    }

    public MinimizingConfEnergyCalculator(ConfMinimizer minimizer) {
        this.minimizer = minimizer;
        this.postProcessors = new ArrayList<ConfPostProcessor>();
    }

    public void addConfPostProcessor(ConfPostProcessor val) {
        this.postProcessors.add(val);
    }

    @Override
    public TaskExecutor getTasks() {
        return this.minimizer.getAsync().getTasks();
    }

    private ConfSearch.EnergiedConf postProcessConf(ConfSearch.EnergiedConf econf) {
        for (ConfPostProcessor postProcessor : this.postProcessors) {
            postProcessor.postProcess(econf);
        }
        return econf;
    }

    @Override
    public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf) {
        return this.postProcessConf(this.minimizer.getAsync().minimizeSync(conf));
    }

    @Override
    public void calcEnergyAsync(ConfSearch.ScoredConf conf, final GMECConfEnergyCalculator.Async.Listener listener) {
        this.minimizer.getAsync().minimizeAsync(conf, new ConfMinimizer.Async.Listener(){

            @Override
            public void onMinimized(ConfSearch.EnergiedConf econf) {
                listener.onFinished(MinimizingConfEnergyCalculator.this.postProcessConf(econf));
            }
        });
    }

    public void clean() {
        this.minimizer.cleanup();
    }

    public static interface ConfPostProcessor {
        public void postProcess(ConfSearch.EnergiedConf var1);

        public static ConfPostProcessor referenceEnergies(ReferenceEnergies erefMat) {
            return econf -> econf.offsetEnergy(-erefMat.confERef(econf.getAssignments()));
        }

        public static ConfPostProcessor residueEntropy(ConfSpace confSpace) {
            return econf -> econf.offsetEnergy(confSpace.getConfResEntropy(econf.getAssignments()));
        }
    }
}

