/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu;

public enum Precision {
    Float32(4){

        @Override
        public Object fromDouble(double val) {
            return Float.valueOf((float)val);
        }

        @Override
        public double toDouble(Object val) {
            return ((Float)val).floatValue();
        }
    }
    ,
    Float64(8){

        @Override
        public Object fromDouble(double val) {
            return val;
        }

        @Override
        public double toDouble(Object val) {
            return (Double)val;
        }
    };

    public final int bytes;

    private Precision(int bytes) {
        this.bytes = bytes;
    }

    public abstract Object fromDouble(double var1);

    public abstract double toDouble(Object var1);

    public double cast(double val) {
        return this.toDouble(this.fromDouble(val));
    }

    public <T> T map(T f32, T f64) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case Float32 -> f32;
            case Float64 -> f64;
        };
    }
}

