/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu;

import edu.duke.cs.osprey.gpu.MemoryBuffer;
import edu.duke.cs.osprey.gpu.Precision;
import java.util.Arrays;
import java.util.Set;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import kotlin.text.Charsets;

public class Structs {
    public static <T> long sum(T[] things, ToLongFunction<? super T> converter) {
        return Arrays.stream(things).mapToLong(converter).sum();
    }

    public static Pad pad(long bytes) {
        return new Pad(bytes);
    }

    public static Int32 int32() {
        return new Int32();
    }

    public static Int32.Array int32array() {
        return new Int32.Array();
    }

    public static Int64 int64() {
        return new Int64();
    }

    public static Int64.Array int64array() {
        return new Int64.Array();
    }

    public static Float32 float32() {
        return new Float32();
    }

    public static Float32.Array float32array() {
        return new Float32.Array();
    }

    public static Float64 float64() {
        return new Float64();
    }

    public static Float64.Array float64array() {
        return new Float64.Array();
    }

    public static Bool bool() {
        return new Bool();
    }

    public static <T extends Struct> StructField<T> struct(T struct) {
        return new StructField<T>(struct);
    }

    public static Real real(Precision precision) {
        return new Real(precision);
    }

    public static Real.Array realarray(Precision precision) {
        return new Real.Array(precision);
    }

    public static Char8 char8() {
        return new Char8();
    }

    public static Char8.Array char8array() {
        return new Char8.Array();
    }

    public static class Pad
    extends Field {
        public Pad(long bytes) {
            super(bytes);
        }
    }

    public static class Int32
    extends Field {
        public static final long bytes = 4L;

        public Int32() {
            super(4L);
        }

        public int get(MemoryBuffer buf) {
            return buf.getInt(this);
        }

        public void set(MemoryBuffer buf, int value2) {
            buf.putInt(this, value2);
        }

        public static class Array
        extends edu.duke.cs.osprey.gpu.Structs$Array {
            public Array() {
                super(4L);
            }

            public int get(MemoryBuffer buf, long i) {
                return buf.getInt(this, i);
            }

            public void set(MemoryBuffer buf, long i, int value2) {
                buf.putInt(this, i, value2);
            }
        }
    }

    public static class Int64
    extends Field {
        public static final long bytes = 8L;

        public Int64() {
            super(8L);
        }

        public long get(MemoryBuffer buf) {
            return buf.getLong(this);
        }

        public void set(MemoryBuffer buf, long value2) {
            buf.putLong(this, value2);
        }

        public static class Array
        extends edu.duke.cs.osprey.gpu.Structs$Array {
            public Array() {
                super(8L);
            }

            public long get(MemoryBuffer buf, long i) {
                return buf.getLong(this, i);
            }

            public void set(MemoryBuffer buf, long i, long value2) {
                buf.putLong(this, i, value2);
            }
        }
    }

    public static class Float32
    extends Field {
        public static final long bytes = 4L;

        public Float32() {
            super(4L);
        }

        public float get(MemoryBuffer buf) {
            return buf.getFloat(this);
        }

        public void set(MemoryBuffer buf, float value2) {
            buf.putFloat(this, value2);
        }

        public static class Array
        extends edu.duke.cs.osprey.gpu.Structs$Array {
            public Array() {
                super(4L);
            }

            public float get(MemoryBuffer buf, long i) {
                return buf.getFloat(this, i);
            }

            public void set(MemoryBuffer buf, long i, float value2) {
                buf.putFloat(this, i, value2);
            }
        }
    }

    public static class Float64
    extends Field {
        public static final long bytes = 8L;

        public Float64() {
            super(8L);
        }

        public double get(MemoryBuffer buf) {
            return buf.getDouble(this);
        }

        public void set(MemoryBuffer buf, double value2) {
            buf.putDouble(this, value2);
        }

        public static class Array
        extends edu.duke.cs.osprey.gpu.Structs$Array {
            public Array() {
                super(8L);
            }

            public double get(MemoryBuffer buf, long i) {
                return buf.getDouble(this, i);
            }

            public void set(MemoryBuffer buf, long i, double value2) {
                buf.putDouble(this, i, value2);
            }
        }
    }

    public static class Bool
    extends Field {
        public static final long bytes = 1L;

        public Bool() {
            super(1L);
        }

        public boolean get(MemoryBuffer buf) {
            return buf.getBoolean(this);
        }

        public void set(MemoryBuffer buf, boolean value2) {
            buf.putBoolean(this, value2);
        }
    }

    public static class StructField<T extends Struct>
    extends Field {
        public StructField(T struct) {
            super(((Struct)struct).bytes());
        }

        public MemoryBuffer offsetOf(MemoryBuffer buf) {
            return buf.sliceFrom(this.offset);
        }
    }

    public static abstract class Struct {
        private Field[] fields = null;

        public <T extends Struct> T init(int bytes, String ... fieldNames) {
            Class<?> c = this.getClass();
            this.fields = new Field[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                String[] fieldName = fieldNames[i];
                try {
                    java.lang.reflect.Field declaredField = c.getDeclaredField((String)fieldName);
                    declaredField.setAccessible(true);
                    this.fields[i] = (Field)declaredField.get(this);
                    if (this.fields[i] == null) {
                        throw new Error("Field hasn't been assigned yet: " + (String)fieldName);
                    }
                    this.fields[i].name = fieldName;
                    continue;
                }
                catch (NoSuchFieldException ex) {
                    throw new Error("Can't initialize field: " + (String)fieldName, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new Error("Can't read field: " + (String)fieldName, ex);
                }
            }
            Set missingFields = Arrays.stream(c.getDeclaredFields()).filter(f -> !f.isSynthetic()).map(f -> f.getName()).collect(Collectors.toSet());
            for (String name : fieldNames) {
                missingFields.remove(name);
            }
            if (!missingFields.isEmpty()) {
                throw new IllegalArgumentException("no order given for fields: " + String.valueOf(missingFields));
            }
            if ((long)bytes != this.bytes()) {
                throw new IllegalArgumentException("struct size (" + this.bytes() + ") is not expected size (" + bytes + ")");
            }
            long offset = 0L;
            for (Field field : this.fields) {
                field.offset = offset;
                offset += field.bytes;
            }
            Struct struct = this;
            return (T)struct;
        }

        public long bytes() {
            return Structs.sum(this.fields, f -> f.bytes);
        }
    }

    public static class Real
    extends Field {
        public final Precision precision;

        private Real(Precision precision) {
            super(precision.bytes);
            this.precision = precision;
        }

        public double get(MemoryBuffer buf) {
            return switch (this.precision) {
                default -> throw new IncompatibleClassChangeError();
                case Precision.Float32 -> buf.getFloat(this);
                case Precision.Float64 -> buf.getDouble(this);
            };
        }

        public void set(MemoryBuffer buf, double value2) {
            switch (this.precision) {
                case Float32: {
                    buf.putFloat(this, (float)value2);
                    break;
                }
                case Float64: {
                    buf.putDouble(this, value2);
                }
            }
        }

        public static class Array
        extends edu.duke.cs.osprey.gpu.Structs$Array {
            public final Precision precision;

            public Array(Precision precision) {
                super(precision.bytes);
                this.precision = precision;
            }

            public double get(MemoryBuffer buf, long i) {
                return switch (this.precision) {
                    default -> throw new IncompatibleClassChangeError();
                    case Precision.Float32 -> buf.getFloat(this, i);
                    case Precision.Float64 -> buf.getDouble(this, i);
                };
            }

            public void set(MemoryBuffer buf, long i, double value2) {
                switch (this.precision) {
                    case Float32: {
                        buf.putFloat(this, i, (float)value2);
                        break;
                    }
                    case Float64: {
                        buf.putDouble(this, i, value2);
                    }
                }
            }
        }
    }

    public static class Char8
    extends Field {
        public static final long bytes = 1L;

        public Char8() {
            super(1L);
        }

        public char get(MemoryBuffer buf) {
            return buf.getChar(this);
        }

        public void set(MemoryBuffer buf, char value2) {
            buf.putChar(this, value2);
        }

        public static class Array
        extends edu.duke.cs.osprey.gpu.Structs$Array {
            public Array() {
                super(1L);
            }

            public char get(MemoryBuffer buf, long i) {
                return buf.getChar(this, i);
            }

            public void set(MemoryBuffer buf, long i, char value2) {
                buf.putChar(this, i, value2);
            }

            public String getNullTerminated(MemoryBuffer buf, int maxLen) {
                byte[] strbuf = new byte[maxLen];
                for (int i = 0; i < maxLen; ++i) {
                    strbuf[i] = buf.getByte(this, i);
                    if (strbuf[i] != 0) continue;
                    return new String(strbuf, 0, i, Charsets.US_ASCII);
                }
                return new String(strbuf, Charsets.US_ASCII);
            }
        }
    }

    public static abstract class Array {
        public final long itemBytes;

        public Array(long itemBytes) {
            this.itemBytes = itemBytes;
        }

        public long bytes(long size) {
            return size * this.itemBytes;
        }
    }

    public static abstract class Field {
        public final long bytes;
        protected String name;
        protected long offset;

        public Field(long bytes) {
            this.bytes = bytes;
        }

        public String name() {
            return this.name;
        }

        public long offset() {
            return this.offset;
        }

        public void assertAlignment(long baseOffset, int alignment) {
            assert (baseOffset % (long)alignment == 0L);
        }
    }
}

