/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.cuda;

import edu.duke.cs.osprey.Cleaner;
import edu.duke.cs.osprey.gpu.cuda.CUBuffer;
import edu.duke.cs.osprey.tools.Factory;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class BufferPool<T extends Buffer>
implements Cleaner.GarbageDetectable {
    public final BufferFactory<T> factory;
    public final BufferExpander<T> expand;
    private TreeMap<Integer, List<CUBuffer<T>>> buffers;
    private Cleaner.Cleanable cleaner;

    public BufferPool(BufferFactory<T> factory, BufferExpander<T> expand) {
        this.factory = factory;
        this.expand = expand;
        TreeMap buffers = this.buffers = new TreeMap();
        this.cleaner = () -> {
            for (List bufs : buffers.values()) {
                for (CUBuffer buf : bufs) {
                    buf.cleanup();
                }
            }
            buffers.clear();
        };
        Cleaner.addCleaner(this, this.cleaner);
    }

    public void cleanup() {
        this.cleaner.clean();
    }

    private List<CUBuffer<T>> getBuffers(int size) {
        List<CUBuffer<T>> bufs = this.buffers.get(size);
        if (bufs == null) {
            bufs = new ArrayList<CUBuffer<T>>();
            this.buffers.put(size, bufs);
        }
        return bufs;
    }

    private void add(CUBuffer<T> buf) {
        this.getBuffers(buf.size()).add(buf);
    }

    private CUBuffer<T> remove(int size) {
        if (!this.buffers.containsKey(size)) {
            return null;
        }
        List<CUBuffer<T>> bufs = this.getBuffers(size);
        if (bufs.isEmpty()) {
            this.buffers.remove(size);
            return null;
        }
        CUBuffer<T> buf = bufs.remove(bufs.size() - 1);
        if (bufs.isEmpty()) {
            this.buffers.remove(size);
        }
        return buf;
    }

    public CUBuffer<T> checkout(int size) {
        Integer sizeOrBigger = this.buffers.ceilingKey(size);
        if (sizeOrBigger != null) {
            return this.prep(this.remove(sizeOrBigger), size);
        }
        Integer sizeOrSmaller = this.buffers.floorKey(size);
        if (sizeOrSmaller != null) {
            CUBuffer<T> buf = this.remove(sizeOrSmaller);
            buf = this.expand.expand(buf, size);
            return this.prep(buf, size);
        }
        return this.prep((CUBuffer)this.factory.make(size), size);
    }

    public void release(CUBuffer<T> buf) {
        this.add(buf);
    }

    private CUBuffer<T> prep(CUBuffer<T> buf, int size) {
        ((Buffer)buf.getHostBuffer()).clear();
        assert (((Buffer)buf.getHostBuffer()).capacity() >= size);
        return buf;
    }

    public static interface BufferFactory<T extends Buffer>
    extends Factory<CUBuffer<T>, Integer> {
    }

    public static interface BufferExpander<T extends Buffer> {
        public CUBuffer<T> expand(CUBuffer<T> var1, int var2);
    }
}

