/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.cuda;

import edu.duke.cs.osprey.gpu.cuda.Gpu;
import edu.duke.cs.osprey.gpu.cuda.Gpus;
import jcuda.driver.CUdevice;
import jcuda.driver.JCudaDriver;

public class Diagnostics {
    public static void main(String[] args) {
        try {
            Gpus gpus = Gpus.get();
            int[] ints = new int[1];
            JCudaDriver.cuDeviceGetCount((int[])ints);
            int count = ints[0];
            System.out.println("All CUDA devices:");
            for (int i = 0; i < count; ++i) {
                CUdevice device = new CUdevice();
                JCudaDriver.cuDeviceGet((CUdevice)device, (int)i);
                Gpu gpu = new Gpu(device);
                System.out.println("\n\t" + gpu.getName());
                System.out.println(String.format("\t\t%-30s %d MiB", "memory:", gpu.getTotalMemory() / 1024L / 1024L));
                System.out.println(String.format("\t\t%-30s %d.%d", "compute version:", gpu.getComputeVersion()[0], gpu.getComputeVersion()[1]));
                System.out.println(String.format("\t\t%-30s %s", "integrated or discrete:", gpu.getAttribute(18) == 1 ? "integrate" : "discrete"));
                System.out.println(String.format("\t\t%-30s %d MHz", "clock rate:", gpu.getAttribute(13) / 1000));
                System.out.println(String.format("\t\t%-30s %d", "multiprocessors:", gpu.getAttribute(16)));
                System.out.println(String.format("\t\t%-30s %d", "threads per multiprocessor:", gpu.getAttribute(39)));
                System.out.println(String.format("\t\t%-30s %d", "warp size:", gpu.getAttribute(10)));
                System.out.println(String.format("\t\t%-30s %d", "max block threads:", gpu.getAttribute(2)));
                System.out.println(String.format("\t\t%-30s %d", "max grid blocks:", gpu.getAttribute(5)));
                System.out.println(String.format("\t\t%-30s %d", "registers per block (32-bit):", gpu.getAttribute(12)));
                System.out.println(String.format("\t\t%-30s %d KiB", "memory per block:", gpu.getAttribute(8) / 1024));
                System.out.println(String.format("\t\t%-30s %d KiB", "constant memory:", gpu.getAttribute(9) / 1024));
                System.out.println(String.format("\t\t%-30s %d", "Async engine count:", gpu.getAttribute(40)));
                System.out.println();
                System.out.println(String.format("\t\t%-30s %b", "64-bit double support:", gpu.supportsDoubles()));
                System.out.println(String.format("\t\t%-30s %b", "dynamic parallelism support:", gpu.supportsDynamicParallelism()));
                System.out.println(String.format("\t\t%-30s %b", "concurrent kernels:", gpu.getAttribute(31)));
            }
            System.out.println("\nCUDA GPUs usable by Osprey:");
            for (Gpu gpu : gpus.getGpus()) {
                System.out.println(String.format("%30s:     memory free: %.1f%%", gpu, Float.valueOf(100.0f * (float)gpu.getFreeMemory() / (float)gpu.getTotalMemory())));
            }
        }
        catch (UnsatisfiedLinkError ex) {
            System.out.println("CUDA does not appear to be installed. No GPUs to show.");
            return;
        }
    }
}

