/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.opencl;

import edu.duke.cs.osprey.gpu.opencl.Gpu;
import edu.duke.cs.osprey.gpu.opencl.GpuQueue;
import edu.duke.cs.osprey.gpu.opencl.Gpus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GpuQueuePool {
    private int numQueuesPerGpu;
    private List<List<GpuQueue>> queuesByGpu;
    private List<GpuQueue> queues;
    private boolean[] checkedOut;

    public GpuQueuePool() {
        this(1);
    }

    public GpuQueuePool(int queuesPerGpu) {
        this(Gpus.get().getGpus().size(), queuesPerGpu);
    }

    public GpuQueuePool(int numGpus, int queuesPerGpu) {
        this(numGpus, queuesPerGpu, false);
    }

    public GpuQueuePool(int numGpus, int numQueuesPerGpu, boolean useProfiling) {
        int i;
        this.numQueuesPerGpu = numQueuesPerGpu;
        List<Gpu> gpus = Gpus.get().getGpus();
        numGpus = Math.min(numGpus, gpus.size());
        this.queuesByGpu = new ArrayList<List<GpuQueue>>(numGpus);
        for (i = 0; i < numGpus; ++i) {
            Gpu gpu = gpus.get(i);
            ArrayList<GpuQueue> queuesAtGpu = new ArrayList<GpuQueue>();
            for (int j = 0; j < numQueuesPerGpu; ++j) {
                queuesAtGpu.add(new GpuQueue(gpu, useProfiling, false));
            }
            this.queuesByGpu.add(queuesAtGpu);
        }
        this.queues = new ArrayList<GpuQueue>(numGpus * numQueuesPerGpu);
        for (i = 0; i < numQueuesPerGpu; ++i) {
            for (int j = 0; j < numGpus; ++j) {
                this.queues.add(this.queuesByGpu.get(j).get(i));
            }
        }
        this.checkedOut = new boolean[this.queues.size()];
        Arrays.fill(this.checkedOut, false);
        System.out.println(String.format("GpuQueuePool: using %d command queue(s) across %d gpu(s)", this.queues.size(), numGpus));
    }

    public int getNumGpus() {
        return this.queuesByGpu.size();
    }

    public int getNumQueuesPerGpu() {
        return this.numQueuesPerGpu;
    }

    public int getNumQueues() {
        return this.queues.size();
    }

    public synchronized GpuQueue checkout() {
        for (int i = 0; i < this.queues.size(); ++i) {
            if (this.checkedOut[i]) continue;
            this.checkedOut[i] = true;
            return this.queues.get(i);
        }
        throw new IllegalStateException(String.format("no more queues to checkout, %d already used", this.queues.size()));
    }

    public synchronized void release(GpuQueue queue) {
        if (this.queues == null) {
            queue.cleanup();
            return;
        }
        for (int i = 0; i < this.queues.size(); ++i) {
            if (this.queues.get(i) != queue) continue;
            this.checkedOut[i] = false;
        }
    }

    public void cleanup() {
        if (this.queues != null) {
            for (GpuQueue queue : this.queues) {
                queue.cleanup();
            }
            this.queues = null;
            this.queuesByGpu = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.queues != null) {
                System.err.println("WARNING: " + this.getClass().getName() + " was garbage collected, but not cleaned up. Attempting cleanup now");
                this.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }
}

