/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.opencl;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLPlatform;
import edu.duke.cs.osprey.gpu.opencl.Gpu;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Gpus {
    private static Gpus instance = null;
    private List<Gpu> gpus;

    public static Gpus get() {
        if (instance == null) {
            instance = new Gpus();
        }
        return instance;
    }

    private Gpus() {
        System.out.print("Discovering OpenCL GPUs...");
        try {
            this.gpus = new ArrayList<Gpu>();
            for (int i = 0; i < CLPlatform.listCLPlatforms().length; ++i) {
                CLPlatform platform2 = CLPlatform.listCLPlatforms()[i];
                for (CLDevice device : platform2.listCLDevices()) {
                    if (device.getType() == CLDevice.Type.CPU) continue;
                    try {
                        CLContext gpuContext = CLContext.create((CLDevice[])new CLDevice[]{device});
                        CLDevice isolatedDevice = gpuContext.getDevices()[0];
                        Gpu gpu = new Gpu(isolatedDevice);
                        if (gpu.supportsDoubles()) {
                            this.gpus.add(gpu);
                            continue;
                        }
                        gpuContext.release();
                    }
                    catch (CLException.CLInvalidDeviceException cLInvalidDeviceException) {
                        // empty catch block
                    }
                }
            }
            if (this.gpus.isEmpty()) {
                System.out.println(" none found");
            } else {
                System.out.println(" found " + this.gpus.size());
            }
        }
        catch (CLException.CLPlatformNotFoundKhrException | UnsatisfiedLinkError ex) {
            System.out.println(" OpenCL is not supported on this system.");
            StringWriter buf = new StringWriter();
            ex.printStackTrace(new PrintWriter(buf));
            System.out.println(buf.toString());
        }
    }

    public List<Gpu> getGpus() {
        return Collections.unmodifiableList(this.gpus);
    }
}

