/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.opencl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLEvent;
import com.jogamp.opencl.CLEventList;
import com.jogamp.opencl.CLException;
import edu.duke.cs.osprey.tools.TimeFormatter;
import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;

public class ProfilingEvents {
    private static Field idsField;
    private CLEventList events;
    private PointerBuffer ids;

    public ProfilingEvents(int numEvents) {
        this.events = new CLEventList(numEvents);
        if (this.events != null) {
            try {
                this.ids = (PointerBuffer)idsField.get(this.events);
            }
            catch (Exception ex) {
                throw new Error("can't hack the events ids, did the JOCL library change?", ex);
            }
        }
    }

    public CLEventList getCLEvents() {
        return this.events;
    }

    public PointerBuffer getCLIds() {
        return this.ids;
    }

    public String makeReport() {
        StringBuilder buf = new StringBuilder();
        buf.append("GPU Profile: ");
        buf.append(this.events.size());
        buf.append(" events");
        long sumNs = 0L;
        for (CLEvent event : this.events) {
            CLEvent.CommandType type = event.getType();
            try {
                long startNs = event.getProfilingInfo(CLEvent.ProfilingCommand.START);
                long endNs = event.getProfilingInfo(CLEvent.ProfilingCommand.END);
                long diffNs = endNs - startNs;
                sumNs += diffNs;
                buf.append(String.format("\n\t%16s %s", type.name(), TimeFormatter.format(diffNs, TimeUnit.MICROSECONDS)));
            }
            catch (CLException.CLProfilingInfoNotAvailableException ex) {
                buf.append(String.format("\n\t%16s (unknown timing)", type.name()));
            }
        }
        buf.append(String.format("\n\tTotal: %s", TimeFormatter.format(sumNs, TimeUnit.MICROSECONDS)));
        return buf.toString();
    }

    public long getTotalNs() {
        long sumNs = 0L;
        for (CLEvent event : this.events) {
            try {
                long startNs = event.getProfilingInfo(CLEvent.ProfilingCommand.START);
                long endNs = event.getProfilingInfo(CLEvent.ProfilingCommand.END);
                long diffNs = endNs - startNs;
                sumNs += diffNs;
            }
            catch (CLException.CLProfilingInfoNotAvailableException ex) {
                System.err.println("can't get timing for profiling event: " + String.valueOf(event));
            }
        }
        return sumNs;
    }

    public void cleanup() {
        this.events.release();
    }

    static {
        try {
            idsField = CLEventList.class.getDeclaredField("IDs");
            idsField.setAccessible(true);
        }
        catch (Exception ex) {
            throw new Error("can't hack the events ids, did the JOCL library change?", ex);
        }
    }
}

