/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.opencl.kernels;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLMemory;
import edu.duke.cs.osprey.energy.forcefield.BigForcefieldEnergy;
import edu.duke.cs.osprey.gpu.ForcefieldKernel;
import edu.duke.cs.osprey.gpu.opencl.GpuQueue;
import edu.duke.cs.osprey.gpu.opencl.Kernel;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class ForcefieldKernelOpenCL
extends Kernel
implements ForcefieldKernel {
    private CLBuffer<DoubleBuffer> coords;
    private CLBuffer<IntBuffer> atomFlags;
    private CLBuffer<DoubleBuffer> precomputed;
    private CLBuffer<IntBuffer> subsetTable;
    private CLBuffer<DoubleBuffer> energies;
    private CLBuffer<ByteBuffer> args;
    private int workSize = 0;
    private int groupSize = 128;
    private BigForcefieldEnergy ffenergy;
    private BigForcefieldEnergy.Subset subset;

    public ForcefieldKernelOpenCL(GpuQueue queue, BigForcefieldEnergy ffenergy) throws IOException {
        super(queue, "forcefield.cl", "calc");
        this.ffenergy = ffenergy;
        CLContext context = this.getQueue().getCLQueue().getContext();
        this.coords = context.createBuffer((Buffer)ffenergy.getCoords(), new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        this.atomFlags = context.createBuffer((Buffer)ffenergy.getAtomFlags(), new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        this.precomputed = context.createBuffer((Buffer)ffenergy.getPrecomputed(), new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        this.subsetTable = context.createIntBuffer(ffenergy.getFullSubset().getNumAtomPairs(), new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        this.energies = context.createDoubleBuffer(this.getEnergySize(ffenergy.getFullSubset()), new CLMemory.Mem[]{CLMemory.Mem.WRITE_ONLY});
        ((IntBuffer)this.atomFlags.getBuffer()).rewind();
        ((DoubleBuffer)this.precomputed.getBuffer()).rewind();
        this.uploadBufferAsync(this.atomFlags);
        this.uploadBufferAsync(this.precomputed);
        this.args = context.createByteBuffer(40, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        ByteBuffer argsBuf = (ByteBuffer)this.args.getBuffer();
        argsBuf.rewind();
        argsBuf.putInt(0);
        argsBuf.putInt(0);
        argsBuf.putDouble(ffenergy.getParams().coulombFactor);
        argsBuf.putDouble(ffenergy.getParams().scaledCoulombFactor);
        argsBuf.putDouble(ffenergy.getParams().solvationCutoff2);
        argsBuf.put((byte)(ffenergy.getParams().useDistDependentDielectric ? 1 : 0));
        argsBuf.put((byte)(ffenergy.getParams().useHElectrostatics ? 1 : 0));
        argsBuf.put((byte)(ffenergy.getParams().useHVdw ? 1 : 0));
        argsBuf.put((byte)0);
        argsBuf.put((byte)(ffenergy.getParams().useEEF1 ? 1 : 0));
        argsBuf.flip();
        this.subset = null;
        this.setSubsetInternal(ffenergy.getFullSubset());
        this.getCLKernel().setArg(0, this.coords).setArg(1, this.atomFlags).setArg(2, this.precomputed).setArg(3, this.subsetTable).setArg(4, this.energies).setArg(5, this.args).setNullArg(6, this.groupSize * 8);
    }

    public CLBuffer<DoubleBuffer> getCoords() {
        return this.coords;
    }

    public CLBuffer<DoubleBuffer> getEnergies() {
        return this.energies;
    }

    public CLBuffer<ByteBuffer> getArgs() {
        return this.args;
    }

    @Override
    public BigForcefieldEnergy getForcefield() {
        return this.ffenergy;
    }

    @Override
    public BigForcefieldEnergy.Subset getSubset() {
        return this.subset;
    }

    @Override
    public boolean setSubset(BigForcefieldEnergy.Subset subset) {
        return this.setSubsetInternal(subset);
    }

    private boolean setSubsetInternal(BigForcefieldEnergy.Subset subset) {
        if (this.subset == subset) {
            return false;
        }
        this.subset = subset;
        boolean useSubset = subset.getSubsetTable() != null;
        this.workSize = this.roundUpWorkSize(subset.getNumAtomPairs(), this.groupSize);
        ByteBuffer buf = (ByteBuffer)this.args.getBuffer();
        buf.putInt(0, subset.getNumAtomPairs());
        buf.putInt(4, subset.getNum14AtomPairs());
        buf.put(35, (byte)(useSubset ? 1 : 0));
        buf.rewind();
        this.uploadBufferAsync(this.args);
        if (useSubset) {
            ((IntBuffer)this.subsetTable.getBuffer()).clear();
            subset.getSubsetTable().rewind();
            ((IntBuffer)this.subsetTable.getBuffer()).put(subset.getSubsetTable());
            ((IntBuffer)this.subsetTable.getBuffer()).flip();
            this.uploadPartialBufferAsync(this.subsetTable);
        }
        return true;
    }

    public boolean isDoEnergy() {
        this.downloadBufferSync(this.args);
        return ((ByteBuffer)this.args.getBuffer()).get(35) == 1;
    }

    public void setDoEnergy(boolean val) {
        ByteBuffer buf = (ByteBuffer)this.args.getBuffer();
        buf.put(35, (byte)(val ? 1 : 0));
        buf.rewind();
        this.uploadBufferAsync(this.args);
    }

    @Override
    public void uploadCoordsAsync() {
        this.ffenergy.updateCoords();
        ((DoubleBuffer)this.coords.getBuffer()).rewind();
        this.uploadBufferAsync(this.coords);
    }

    public DoubleBuffer downloadCoordsSync() {
        ((DoubleBuffer)this.coords.getBuffer()).rewind();
        this.downloadBufferSync(this.coords);
        return (DoubleBuffer)this.coords.getBuffer();
    }

    @Override
    public void runAsync() {
        this.runAsync(this.workSize, this.groupSize);
    }

    @Override
    public double downloadEnergySync() {
        ((DoubleBuffer)this.energies.getBuffer()).rewind();
        this.downloadBufferSync(this.energies);
        DoubleBuffer buf = (DoubleBuffer)this.energies.getBuffer();
        double energy = this.subset.getInternalSolvationEnergy();
        buf.rewind();
        int n = this.getEnergySize();
        for (int i = 0; i < n; ++i) {
            energy += buf.get();
        }
        return energy;
    }

    public int getEnergySize() {
        return this.getEnergySize(this.subset);
    }

    public int getEnergySize(BigForcefieldEnergy.Subset subset) {
        return this.roundUpWorkSize(subset.getNumAtomPairs(), this.groupSize) / this.groupSize;
    }

    public int getGpuBytesNeeded() {
        return this.coords.getCLCapacity() * 8 + this.atomFlags.getCLCapacity() * 4 + this.precomputed.getCLCapacity() * 8 + this.subsetTable.getCLCapacity() * 4 + this.args.getCLCapacity() + this.getEnergySize() * 8 + this.groupSize * 8;
    }

    @Override
    public void cleanup() {
        if (this.coords != null) {
            this.coords.release();
            this.atomFlags.release();
            this.precomputed.release();
            this.subsetTable.release();
            this.args.release();
            this.energies.release();
            this.coords = null;
        }
        super.cleanup();
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            if (this.coords != null) {
                System.err.println("WARNING: " + this.getClass().getName() + " was garbage collected, but not cleaned up. Attempting cleanup now");
                this.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }
}

