/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.opencl.kernels;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLMemory;
import edu.duke.cs.osprey.gpu.opencl.GpuQueue;
import edu.duke.cs.osprey.gpu.opencl.Kernel;
import java.io.IOException;
import java.nio.DoubleBuffer;

public class TestFancyKernel
extends Kernel {
    private CLBuffer<DoubleBuffer> bufA;
    private CLBuffer<DoubleBuffer> bufB;
    private CLBuffer<DoubleBuffer> bufOut;
    private int workSize;
    private int groupSize;

    public TestFancyKernel(GpuQueue queue) throws IOException {
        super(queue, "test.cl", "fancy");
    }

    public DoubleBuffer getA() {
        return (DoubleBuffer)this.bufA.getBuffer();
    }

    public DoubleBuffer getB() {
        return (DoubleBuffer)this.bufB.getBuffer();
    }

    public DoubleBuffer getOut() {
        return (DoubleBuffer)this.bufOut.getBuffer();
    }

    public void setArgs(int workSize) {
        this.groupSize = this.getMaxGroupSize();
        this.workSize = this.roundUpWorkSize(workSize, this.groupSize);
        this.cleanup();
        CLContext context = this.getQueue().getCLQueue().getContext();
        this.bufA = context.createDoubleBuffer(workSize, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        this.bufB = context.createDoubleBuffer(workSize, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        this.bufOut = context.createDoubleBuffer(workSize, new CLMemory.Mem[]{CLMemory.Mem.WRITE_ONLY});
    }

    public void runAsync() {
        this.getCLKernel().putArg(this.bufA).putArg(this.bufB).putArg(this.bufOut).rewind();
        this.runAsync(this.workSize, this.groupSize);
    }

    public void uploadSync() {
        this.uploadBufferAsync(this.bufA);
        this.uploadBufferAsync(this.bufB);
        this.waitForGpu();
    }

    public void downloadSync() {
        this.downloadBufferSync(this.bufOut);
    }

    @Override
    public void cleanup() {
        if (this.bufA != null) {
            this.bufA.release();
        }
        if (this.bufB != null) {
            this.bufB.release();
        }
        if (this.bufOut != null) {
            this.bufOut.release();
        }
    }
}

