/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.features.slide;

import cuchaz.kludge.imgui.Commands;
import cuchaz.kludge.vulkan.ColorRGBA;
import edu.duke.cs.osprey.gui.prep.BondGuesser;
import edu.duke.cs.osprey.gui.prep.BondGuesserKt;
import edu.duke.cs.osprey.molscope.gui.InfoTipKt;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import edu.duke.cs.osprey.molscope.view.MoleculeRenderView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0011R\u00020\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Ledu/duke/cs/osprey/gui/features/slide/SelectedChain;", "", "view", "Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Polymer;", "chain", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Chain;", "(Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;Ledu/duke/cs/osprey/molscope/molecule/Polymer;Ledu/duke/cs/osprey/molscope/molecule/Polymer$Chain;)V", "bondGuesser", "Ledu/duke/cs/osprey/gui/prep/BondGuesser;", "getBondGuesser", "()Ledu/duke/cs/osprey/gui/prep/BondGuesser;", "getChain", "()Ledu/duke/cs/osprey/molscope/molecule/Polymer$Chain;", "interBonds", "", "Ledu/duke/cs/osprey/gui/features/slide/SelectedChain$InterBond;", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Polymer;", "getView", "()Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;", "drawChainBreaks", "", "imgui", "Lcuchaz/kludge/imgui/Commands;", "Bond", "InterBond", "osprey3"})
@SourceDebugExtension(value={"SMAP\nBondEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BondEditor.kt\nedu/duke/cs/osprey/gui/features/slide/SelectedChain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,478:1\n1747#2,3:479\n*S KotlinDebug\n*F\n+ 1 BondEditor.kt\nedu/duke/cs/osprey/gui/features/slide/SelectedChain\n*L\n396#1:479,3\n*E\n"})
final class SelectedChain {
    @NotNull
    private final MoleculeRenderView view;
    @NotNull
    private final Polymer mol;
    @NotNull
    private final Polymer.Chain chain;
    @NotNull
    private final BondGuesser bondGuesser;
    @NotNull
    private final List<InterBond> interBonds;

    /*
     * WARNING - void declaration
     */
    public SelectedChain(@NotNull MoleculeRenderView view, @NotNull Polymer mol, @NotNull Polymer.Chain chain) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        this.view = view;
        this.mol = mol;
        this.chain = chain;
        this.bondGuesser = new BondGuesser(0.0, 0.0, null, 7, null);
        ArrayList arrayList2 = arrayList = new ArrayList();
        SelectedChain selectedChain = this;
        boolean bl = false;
        int n = this.chain.getResidues().size();
        for (int i = 1; i < n; ++i) {
            void $this$interBonds_u24lambda_u241;
            Polymer.Residue res1 = this.chain.getResidues().get(i - 1);
            Polymer.Residue res2 = this.chain.getResidues().get(i);
            ArrayList<Bond> bonds2 = new ArrayList<Bond>();
            for (Atom atom1 : res1.getAtoms()) {
                for (Atom atom2 : this.mol.getBonds().bondedAtoms(atom1)) {
                    boolean bl2;
                    block6: {
                        Iterable $this$any$iv = res2.getAtoms();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Atom it = (Atom)element$iv;
                                boolean bl3 = false;
                                if (!(it == atom2)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bonds2.add(new Bond(atom1, atom2));
                }
            }
            $this$interBonds_u24lambda_u241.add(new InterBond(res1, res2, (List<Bond>)bonds2));
        }
        selectedChain.interBonds = arrayList;
    }

    @NotNull
    public final MoleculeRenderView getView() {
        return this.view;
    }

    @NotNull
    public final Polymer getMol() {
        return this.mol;
    }

    @NotNull
    public final Polymer.Chain getChain() {
        return this.chain;
    }

    @NotNull
    public final BondGuesser getBondGuesser() {
        return this.bondGuesser;
    }

    public final void drawChainBreaks(@NotNull Commands imgui) {
        Intrinsics.checkNotNullParameter((Object)imgui, (String)"imgui");
        Commands $this$drawChainBreaks_u24lambda_u242 = imgui;
        boolean bl = false;
        Commands.child-MUbzFbY$default((Commands)$this$drawChainBreaks_u24lambda_u242, (String)"chain", (float)300.0f, (float)600.0f, (boolean)true, (int)0, (Function0)((Function0)new Function0<Unit>(this, $this$drawChainBreaks_u24lambda_u242){
            final /* synthetic */ SelectedChain this$0;
            final /* synthetic */ Commands $this_run;
            {
                this.this$0 = $receiver;
                this.$this_run = $receiver2;
                super(0);
            }

            public final void invoke() {
                Iterator<E> iterator2 = SelectedChain.access$getInterBonds$p(this.this$0).iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    int i = n++;
                    InterBond interBond = (InterBond)iterator2.next();
                    this.$this_run.text(interBond.getLabel());
                    Commands.sameLine$default((Commands)this.$this_run, (float)0.0f, (float)0.0f, (int)3, null);
                    if (Commands.button$default((Commands)this.$this_run, (String)("X##" + i), (float)0.0f, (float)0.0f, (int)6, null)) {
                        interBond.removeBonds();
                    }
                    Commands.sameLine$default((Commands)this.$this_run, (float)0.0f, (float)0.0f, (int)3, null);
                    InfoTipKt.infoTip$default(this.$this_run, "Remove the bonds between these residues", 0.0f, 2, null);
                    this.$this_run.indent(10.0f);
                    if (!((Collection)interBond.getBonds()).isEmpty()) {
                        for (Bond bond : interBond.getBonds()) {
                            this.$this_run.text(bond.getAtom1().getName() + " - " + bond.getAtom2().getName());
                            Commands.sameLine$default((Commands)this.$this_run, (float)0.0f, (float)0.0f, (int)3, null);
                            ColorRGBA colorRGBA = (ColorRGBA)(bond.getGood() ? new ColorRGBA.Int(0, 255, 0, 0, 8, null) : new ColorRGBA.Int(255, 0, 0, 0, 8, null));
                            String string = "%.2f";
                            Object[] objectArray = new Object[]{bond.getDist()};
                            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                            this.$this_run.textColored(colorRGBA, string2 + " A");
                            if (!Commands.isItemHovered-x3nR-DE$default((Commands)this.$this_run, (int)0, (int)1, null)) continue;
                            string = "%.2f A %s in range [%.2f A, %.2f A]";
                            objectArray = new Object[]{bond.getDist(), bond.getGood() ? "is" : "is not", bond.getCovalentRange().getStart(), bond.getCovalentRange().getEndInclusive()};
                            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                            this.$this_run.setTooltip(string3);
                        }
                    } else {
                        this.$this_run.text("(no bonds found)");
                    }
                    this.$this_run.unindent(10.0f);
                }
            }
        }), (int)16, null);
    }

    public static final /* synthetic */ List access$getInterBonds$p(SelectedChain $this) {
        return $this.interBonds;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ledu/duke/cs/osprey/gui/features/slide/SelectedChain$Bond;", "", "atom1", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "atom2", "(Ledu/duke/cs/osprey/gui/features/slide/SelectedChain;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;)V", "getAtom1", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getAtom2", "covalentRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "getCovalentRange", "()Lkotlin/ranges/ClosedFloatingPointRange;", "dist", "getDist", "()D", "good", "", "getGood", "()Z", "osprey3"})
    public final class Bond {
        @NotNull
        private final Atom atom1;
        @NotNull
        private final Atom atom2;
        private final double dist;
        @NotNull
        private final ClosedFloatingPointRange<Double> covalentRange;
        private final boolean good;

        public Bond(@NotNull Atom atom1, Atom atom2) {
            Intrinsics.checkNotNullParameter((Object)atom1, (String)"atom1");
            Intrinsics.checkNotNullParameter((Object)atom2, (String)"atom2");
            this.atom1 = atom1;
            this.atom2 = atom2;
            this.dist = this.atom1.getPos().distance((Vector3dc)this.atom2.getPos());
            this.covalentRange = BondGuesserKt.covalentRange$default(this.atom1, this.atom2, null, 2, null);
            this.good = this.covalentRange.contains((Comparable)Double.valueOf(this.dist));
        }

        @NotNull
        public final Atom getAtom1() {
            return this.atom1;
        }

        @NotNull
        public final Atom getAtom2() {
            return this.atom2;
        }

        public final double getDist() {
            return this.dist;
        }

        @NotNull
        public final ClosedFloatingPointRange<Double> getCovalentRange() {
            return this.covalentRange;
        }

        public final boolean getGood() {
            return this.good;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007R\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\n\u0010\f\u001a\u00020\r*\u00020\u0003R\u001b\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007R\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0015"}, d2={"Ledu/duke/cs/osprey/gui/features/slide/SelectedChain$InterBond;", "", "res1", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "res2", "bonds", "", "Ledu/duke/cs/osprey/gui/features/slide/SelectedChain$Bond;", "Ledu/duke/cs/osprey/gui/features/slide/SelectedChain;", "(Ledu/duke/cs/osprey/gui/features/slide/SelectedChain;Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;Ljava/util/List;)V", "getBonds", "()Ljava/util/List;", "label", "", "getLabel", "()Ljava/lang/String;", "getRes1", "()Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "getRes2", "removeBonds", "", "osprey3"})
    public final class InterBond {
        @NotNull
        private final Polymer.Residue res1;
        @NotNull
        private final Polymer.Residue res2;
        @NotNull
        private final List<Bond> bonds;
        @NotNull
        private final String label;

        public InterBond(@NotNull Polymer.Residue res1, @NotNull Polymer.Residue res2, List<Bond> bonds2) {
            Intrinsics.checkNotNullParameter((Object)res1, (String)"res1");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res2");
            Intrinsics.checkNotNullParameter(bonds2, (String)"bonds");
            this.res1 = res1;
            this.res2 = res2;
            this.bonds = bonds2;
            this.label = this.label(this.res1) + " - " + this.label(this.res2);
        }

        @NotNull
        public final Polymer.Residue getRes1() {
            return this.res1;
        }

        @NotNull
        public final Polymer.Residue getRes2() {
            return this.res2;
        }

        @NotNull
        public final List<Bond> getBonds() {
            return this.bonds;
        }

        @NotNull
        public final String label(@NotNull Polymer.Residue $this$label) {
            Intrinsics.checkNotNullParameter((Object)$this$label, (String)"<this>");
            return $this$label.getType() + " " + $this$label.getId();
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final void removeBonds() {
            for (Bond bond : this.bonds) {
                SelectedChain.this.getMol().getBonds().remove(bond.getAtom1(), bond.getAtom2());
            }
            SelectedChain.this.getView().moleculeChanged();
            this.bonds.clear();
        }
    }
}

