/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield;

import edu.duke.cs.osprey.gui.forcefield.AtomIndex;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.MoleculeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a8\u0006\f"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/AtomPairer;", "", "()V", "molPairs", "", "Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolPairInfo;", "infos", "Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolInfo;", "infos1", "infos2", "MolInfo", "MolPairInfo", "osprey3"})
@SourceDebugExtension(value={"SMAP\nAtomPairer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomPairer.kt\nedu/duke/cs/osprey/gui/forcefield/AtomPairer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n766#2:137\n857#2,2:138\n*S KotlinDebug\n*F\n+ 1 AtomPairer.kt\nedu/duke/cs/osprey/gui/forcefield/AtomPairer\n*L\n36#1:137\n36#1:138,2\n*E\n"})
public final class AtomPairer {
    @NotNull
    public static final AtomPairer INSTANCE = new AtomPairer();

    private AtomPairer() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MolPairInfo> molPairs(@NotNull List<? extends MolInfo> infos2) {
        ArrayList<MolPairInfo> arrayList;
        Intrinsics.checkNotNullParameter(infos2, (String)"infos");
        ArrayList<MolPairInfo> $this$molPairs_u24lambda_u241 = arrayList = new ArrayList<MolPairInfo>();
        boolean bl = false;
        for (MolInfo molInfo : infos2) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = infos2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MolInfo it = (MolInfo)element$iv$iv;
                boolean bl2 = false;
                if (!(molInfo.getMoli() <= it.getMoli())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (MolInfo mol2 : (List)destination$iv$iv) {
                $this$molPairs_u24lambda_u241.add(new MolPairInfo(molInfo, mol2));
            }
        }
        return arrayList;
    }

    @NotNull
    public final List<MolPairInfo> molPairs(@NotNull List<? extends MolInfo> infos1, @NotNull List<? extends MolInfo> infos2) {
        ArrayList<MolPairInfo> arrayList;
        Intrinsics.checkNotNullParameter(infos1, (String)"infos1");
        Intrinsics.checkNotNullParameter(infos2, (String)"infos2");
        ArrayList<MolPairInfo> $this$molPairs_u24lambda_u242 = arrayList = new ArrayList<MolPairInfo>();
        boolean bl = false;
        for (MolInfo molInfo : infos1) {
            for (MolInfo molInfo2 : infos2) {
                $this$molPairs_u24lambda_u242.add(new MolPairInfo(molInfo, molInfo2));
            }
        }
        return arrayList;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolInfo;", "", "moli", "", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "atoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "atomIndex", "Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;", "(ILedu/duke/cs/osprey/molscope/molecule/Molecule;Ljava/lang/Iterable;Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;)V", "getAtomIndex", "()Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;", "getAtoms", "()Ljava/lang/Iterable;", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "getMoli", "()I", "osprey3"})
    public static class MolInfo {
        private final int moli;
        @NotNull
        private final Molecule mol;
        @NotNull
        private final Iterable<Atom> atoms;
        @NotNull
        private final AtomIndex atomIndex;

        public MolInfo(int moli, @NotNull Molecule mol, @NotNull Iterable<Atom> atoms, @NotNull AtomIndex atomIndex) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Intrinsics.checkNotNullParameter((Object)atomIndex, (String)"atomIndex");
            this.moli = moli;
            this.mol = mol;
            this.atoms = atoms;
            this.atomIndex = atomIndex;
        }

        public final int getMoli() {
            return this.moli;
        }

        @NotNull
        public final Molecule getMol() {
            return this.mol;
        }

        @NotNull
        public final Iterable<Atom> getAtoms() {
            return this.atoms;
        }

        @NotNull
        public final AtomIndex getAtomIndex() {
            return this.atomIndex;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0094\u0001\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2{\u0010\r\u001aw\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\n0\u000ej\u0002`\u0016\u00a2\u0006\u0002\u0010\u0017J\u0095\u0001\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032{\u0010\r\u001aw\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\n0\u000ej\u0002`\u0016H\u0002J\u00a6\u0001\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2{\u0010\r\u001aw\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\n0\u000ej\u0002`\u0016H\u0002\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001b"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolPairInfo;", "", "mol1", "Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolInfo;", "mol2", "(Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolInfo;Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolInfo;)V", "getMol1", "()Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolInfo;", "getMol2", "forEach", "", "unconnectedDist", "", "func", "Lkotlin/Function5;", "Lkotlin/ParameterName;", "name", "info1", "atomi1", "info2", "atomi2", "distance", "Ledu/duke/cs/osprey/gui/forcefield/FfparamsPairFunc;", "(Ljava/lang/Integer;Lkotlin/jvm/functions/Function5;)V", "forEachIntermol", "forEachIntramol", "(Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolInfo;Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolInfo;Ljava/lang/Integer;Lkotlin/jvm/functions/Function5;)V", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nAtomPairer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomPairer.kt\nedu/duke/cs/osprey/gui/forcefield/AtomPairer$MolPairInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n766#2:137\n857#2,2:138\n1855#2,2:140\n766#2:142\n857#2,2:143\n1855#2,2:145\n*S KotlinDebug\n*F\n+ 1 AtomPairer.kt\nedu/duke/cs/osprey/gui/forcefield/AtomPairer$MolPairInfo\n*L\n102#1:137\n102#1:138,2\n103#1:140,2\n113#1:142\n113#1:143,2\n114#1:145,2\n*E\n"})
    public static class MolPairInfo {
        @NotNull
        private final MolInfo mol1;
        @NotNull
        private final MolInfo mol2;

        public MolPairInfo(@NotNull MolInfo mol1, @NotNull MolInfo mol2) {
            Intrinsics.checkNotNullParameter((Object)mol1, (String)"mol1");
            Intrinsics.checkNotNullParameter((Object)mol2, (String)"mol2");
            this.mol1 = mol1;
            this.mol2 = mol2;
        }

        @NotNull
        public final MolInfo getMol1() {
            return this.mol1;
        }

        @NotNull
        public final MolInfo getMol2() {
            return this.mol2;
        }

        public final void forEach(@Nullable Integer unconnectedDist, @NotNull Function5<? super MolInfo, ? super Integer, ? super MolInfo, ? super Integer, ? super Integer, Unit> func) {
            Intrinsics.checkNotNullParameter(func, (String)"func");
            if (this.mol1.getMoli() == this.mol2.getMoli()) {
                this.forEachIntramol(this.mol1, this.mol2, unconnectedDist, func);
            } else {
                this.forEachIntermol(this.mol1, this.mol2, func);
            }
        }

        public static /* synthetic */ void forEach$default(MolPairInfo molPairInfo, Integer n, Function5 function5, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: forEach");
            }
            if ((n2 & 1) != 0) {
                n = null;
            }
            molPairInfo.forEach(n, (Function5<? super MolInfo, ? super Integer, ? super MolInfo, ? super Integer, ? super Integer, Unit>)function5);
        }

        private final void forEachIntramol(MolInfo info1, MolInfo info2, Integer unconnectedDist, Function5<? super MolInfo, ? super Integer, ? super MolInfo, ? super Integer, ? super Integer, Unit> func) {
            boolean bl;
            boolean bl2 = bl = info1.getMol() == info2.getMol();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Molecule mol = info1.getMol();
            Set<Atom> atomLookup = MoleculeKt.toIdentitySet(CollectionsKt.toList(info2.getAtoms()));
            for (Atom atom1 : info1.getAtoms()) {
                Iterable<Atom> $this$forEach$iv;
                Object element$iv$iv;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                int atomi1 = MolPairInfo.forEachIntramol$index1(atom1, info1);
                Set<Atom> visitedAtoms2 = Atom.Companion.identitySet();
                Iterable<Molecule.Searched> iterable = mol.bfs(atom1, false, (Function3<? super Atom, ? super Atom, ? super Integer, Boolean>)((Function3)new Function3<Atom, Atom, Integer, Boolean>(unconnectedDist){
                    final /* synthetic */ Integer $unconnectedDist;
                    {
                        this.$unconnectedDist = $unconnectedDist;
                        super(3);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Atom atom, @NotNull Atom atom2, int dist) {
                        Intrinsics.checkNotNullParameter((Object)atom, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)atom2, (String)"<anonymous parameter 1>");
                        return this.$unconnectedDist == null || dist < this.$unconnectedDist;
                    }
                }));
                boolean $i$f$filter = false;
                Iterator<Atom> iterator2 = $this$filter$iv;
                Collection collection = new ArrayList();
                boolean $i$f$filterTo22 = false;
                Iterator iterator3 = $this$filterTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    element$iv$iv = iterator3.next();
                    Molecule.Searched it = (Molecule.Searched)element$iv$iv;
                    boolean bl3 = false;
                    if (!atomLookup.contains(it.getAtom())) continue;
                    collection.add(element$iv$iv);
                }
                $this$filter$iv = (List)collection;
                boolean $i$f$forEach = false;
                for (Object t : $this$forEach$iv) {
                    Molecule.Searched $i$f$filterTo22 = (Molecule.Searched)t;
                    boolean bl4 = false;
                    Atom atom2 = $i$f$filterTo22.component1();
                    int dist = $i$f$filterTo22.component2();
                    visitedAtoms2.add(atom2);
                    int atomi2 = MolPairInfo.forEachIntramol$index2(atom2, info2);
                    if (!MolPairInfo.forEachIntramol$shouldVisitAtomPair(info1, info2, atomi1, atomi2)) continue;
                    func.invoke((Object)info1, (Object)atomi1, (Object)info2, (Object)atomi2, (Object)dist);
                }
                $this$forEach$iv = info2.getAtoms();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                Collection collection2 = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator bl4 = $this$filterTo$iv$iv.iterator();
                while (bl4.hasNext()) {
                    element$iv$iv = bl4.next();
                    Atom it = (Atom)element$iv$iv;
                    boolean bl5 = false;
                    if (!(it != atom1 && !visitedAtoms2.contains(it))) continue;
                    collection2.add(element$iv$iv);
                }
                $this$filter$iv = (List)collection2;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Atom atom;
                    Atom atom2 = atom = iterator2.next();
                    boolean bl6 = false;
                    int atomi2 = MolPairInfo.forEachIntramol$index2(atom2, info2);
                    if (!MolPairInfo.forEachIntramol$shouldVisitAtomPair(info1, info2, atomi1, atomi2)) continue;
                    func.invoke((Object)info1, (Object)atomi1, (Object)info2, (Object)atomi2, null);
                }
            }
        }

        static /* synthetic */ void forEachIntramol$default(MolPairInfo molPairInfo, MolInfo molInfo, MolInfo molInfo2, Integer n, Function5 function5, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: forEachIntramol");
            }
            if ((n2 & 4) != 0) {
                n = null;
            }
            molPairInfo.forEachIntramol(molInfo, molInfo2, n, (Function5<? super MolInfo, ? super Integer, ? super MolInfo, ? super Integer, ? super Integer, Unit>)function5);
        }

        private final void forEachIntermol(MolInfo info1, MolInfo info2, Function5<? super MolInfo, ? super Integer, ? super MolInfo, ? super Integer, ? super Integer, Unit> func) {
            for (Atom atom1 : info1.getAtoms()) {
                int atomi1 = info1.getAtomIndex().getOrThrow(atom1);
                for (Atom atom2 : info2.getAtoms()) {
                    int atomi2 = info2.getAtomIndex().getOrThrow(atom2);
                    func.invoke((Object)info1, (Object)atomi1, (Object)info2, (Object)atomi2, null);
                }
            }
        }

        private static final int forEachIntramol$index1(Atom $this$forEachIntramol_u24index1, MolInfo $info1) {
            return $info1.getAtomIndex().getOrThrow($this$forEachIntramol_u24index1);
        }

        private static final int forEachIntramol$index2(Atom $this$forEachIntramol_u24index2, MolInfo $info2) {
            return $info2.getAtomIndex().getOrThrow($this$forEachIntramol_u24index2);
        }

        private static final boolean forEachIntramol$shouldVisitAtomPair(MolInfo $info1, MolInfo $info2, int i1, int i2) {
            return $info1 == $info2 ? i1 >= i2 : true;
        }
    }
}

