/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield;

import edu.duke.cs.osprey.gui.forcefield.AtomIndex;
import edu.duke.cs.osprey.gui.forcefield.AtomPairer;
import edu.duke.cs.osprey.gui.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u000e"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/ForcefieldCalculator;", "", "()V", "calc", "", "atomPairsParams", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomPairsParams;", "infos", "", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldCalculator$MolInfo;", "unconnectedDistance", "", "(Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomPairsParams;Ljava/util/List;Ljava/lang/Integer;)D", "MolInfo", "osprey3"})
public final class ForcefieldCalculator {
    @NotNull
    public static final ForcefieldCalculator INSTANCE = new ForcefieldCalculator();

    private ForcefieldCalculator() {
    }

    public final double calc(@NotNull ForcefieldParams.AtomPairsParams atomPairsParams, @NotNull List<MolInfo> infos2, @Nullable Integer unconnectedDistance) {
        Intrinsics.checkNotNullParameter((Object)atomPairsParams, (String)"atomPairsParams");
        Intrinsics.checkNotNullParameter(infos2, (String)"infos");
        Ref.DoubleRef energy = new Ref.DoubleRef();
        for (MolInfo info2 : infos2) {
            for (Atom atom : info2.getAtoms()) {
                int atomi = info2.getAtomIndex().getOrThrow(atom);
                Object object = info2.getAtomsParams().get(atomi);
                if (object == null || (object = object.internalEnergy()) == null) {
                    continue;
                }
                energy.element = energy.element + (Double)object;
            }
        }
        for (AtomPairer.MolPairInfo molPair : AtomPairer.INSTANCE.molPairs(infos2)) {
            molPair.forEach(unconnectedDistance, (Function5<? super AtomPairer.MolInfo, ? super Integer, ? super AtomPairer.MolInfo, ? super Integer, ? super Integer, Unit>)((Function5)new Function5<AtomPairer.MolInfo, Integer, AtomPairer.MolInfo, Integer, Integer, Unit>(atomPairsParams, energy){
                final /* synthetic */ ForcefieldParams.AtomPairsParams $atomPairsParams;
                final /* synthetic */ Ref.DoubleRef $energy;
                {
                    this.$atomPairsParams = $atomPairsParams;
                    this.$energy = $energy;
                    super(5);
                }

                public final void invoke(@NotNull AtomPairer.MolInfo info1, int atomi1, @NotNull AtomPairer.MolInfo info2, int atomi2, @Nullable Integer distance) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)info1, (String)"info1");
                        Intrinsics.checkNotNullParameter((Object)info2, (String)"info2");
                        ForcefieldParams.AtomPairParams atomPairParams = this.$atomPairsParams.get(info1.getMoli(), atomi1, info2.getMoli(), atomi2, distance);
                        if (atomPairParams == null) break block0;
                        ForcefieldParams.AtomPairParams atomPairParams2 = atomPairParams;
                        Ref.DoubleRef doubleRef = this.$energy;
                        ForcefieldParams.AtomPairParams params = atomPairParams2;
                        boolean bl = false;
                        Atom atom1 = info1.getAtomIndex().getOrThrow(atomi1);
                        Atom atom2 = info2.getAtomIndex().getOrThrow(atomi2);
                        doubleRef.element += params.calcEnergy(atom1.getPos().distance((Vector3dc)atom2.getPos()));
                    }
                }
            }));
        }
        return energy.element;
    }

    public static /* synthetic */ double calc$default(ForcefieldCalculator forcefieldCalculator, ForcefieldParams.AtomPairsParams atomPairsParams, List list, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return forcefieldCalculator.calc(atomPairsParams, list, n);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/ForcefieldCalculator$MolInfo;", "Ledu/duke/cs/osprey/gui/forcefield/AtomPairer$MolInfo;", "moli", "", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "atoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "atomIndex", "Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;", "atomsParams", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomsParams;", "(ILedu/duke/cs/osprey/molscope/molecule/Molecule;Ljava/lang/Iterable;Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomsParams;)V", "getAtomsParams", "()Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomsParams;", "osprey3"})
    public static final class MolInfo
    extends AtomPairer.MolInfo {
        @NotNull
        private final ForcefieldParams.AtomsParams atomsParams;

        public MolInfo(int moli, @NotNull Molecule mol, @NotNull Iterable<Atom> atoms, @NotNull AtomIndex atomIndex, @NotNull ForcefieldParams.AtomsParams atomsParams) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Intrinsics.checkNotNullParameter((Object)atomIndex, (String)"atomIndex");
            Intrinsics.checkNotNullParameter((Object)atomsParams, (String)"atomsParams");
            super(moli, mol, atoms, atomIndex);
            this.atomsParams = atomsParams;
        }

        @NotNull
        public final ForcefieldParams.AtomsParams getAtomsParams() {
            return this.atomsParams;
        }
    }
}

