/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield.amber;

import edu.duke.cs.osprey.gui.forcefield.AtomIndex;
import edu.duke.cs.osprey.gui.forcefield.amber.ForcefieldName;
import edu.duke.cs.osprey.gui.io.Mol2Metadata;
import edu.duke.cs.osprey.gui.tools.CombineCollisionException;
import edu.duke.cs.osprey.gui.tools.IntPair;
import edu.duke.cs.osprey.gui.tools.LangKt;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.AtomPair;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bBI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\n\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0003JU\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\n2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00d6\u0001J\u0016\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007J\t\u0010#\u001a\u00020\fH\u00d6\u0001R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTypes;", "", "ffname", "Ledu/duke/cs/osprey/gui/forcefield/amber/ForcefieldName;", "mol2Metadata", "Ledu/duke/cs/osprey/gui/io/Mol2Metadata;", "atomIndex", "Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;", "(Ledu/duke/cs/osprey/gui/forcefield/amber/ForcefieldName;Ledu/duke/cs/osprey/gui/io/Mol2Metadata;Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;)V", "atomTypes", "", "", "", "bondTypes", "Ledu/duke/cs/osprey/gui/tools/IntPair;", "atomCharges", "(Ledu/duke/cs/osprey/gui/forcefield/amber/ForcefieldName;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getAtomCharges", "()Ljava/util/Map;", "getAtomTypes", "getBondTypes", "getFfname", "()Ledu/duke/cs/osprey/gui/forcefield/amber/ForcefieldName;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toMol2Metadata", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "toString", "Companion", "osprey3"})
@SourceDebugExtension(value={"SMAP\nparams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 params.kt\nedu/duke/cs/osprey/gui/forcefield/amber/AmberTypes\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n457#2:311\n403#2:312\n457#2:317\n403#2:318\n457#2:323\n403#2:324\n1238#3,4:313\n1238#3,4:319\n1238#3,4:325\n*S KotlinDebug\n*F\n+ 1 params.kt\nedu/duke/cs/osprey/gui/forcefield/amber/AmberTypes\n*L\n33#1:311\n33#1:312\n36#1:317\n36#1:318\n39#1:323\n39#1:324\n33#1:313,4\n36#1:319,4\n39#1:325,4\n*E\n"})
public final class AmberTypes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ForcefieldName ffname;
    @NotNull
    private final Map<Integer, String> atomTypes;
    @NotNull
    private final Map<IntPair, String> bondTypes;
    @NotNull
    private final Map<Integer, String> atomCharges;

    public AmberTypes(@NotNull ForcefieldName ffname, @NotNull Map<Integer, String> atomTypes, @NotNull Map<IntPair, String> bondTypes, @NotNull Map<Integer, String> atomCharges) {
        Intrinsics.checkNotNullParameter((Object)ffname, (String)"ffname");
        Intrinsics.checkNotNullParameter(atomTypes, (String)"atomTypes");
        Intrinsics.checkNotNullParameter(bondTypes, (String)"bondTypes");
        Intrinsics.checkNotNullParameter(atomCharges, (String)"atomCharges");
        this.ffname = ffname;
        this.atomTypes = atomTypes;
        this.bondTypes = bondTypes;
        this.atomCharges = atomCharges;
    }

    @NotNull
    public final ForcefieldName getFfname() {
        return this.ffname;
    }

    @NotNull
    public final Map<Integer, String> getAtomTypes() {
        return this.atomTypes;
    }

    @NotNull
    public final Map<IntPair, String> getBondTypes() {
        return this.bondTypes;
    }

    @NotNull
    public final Map<Integer, String> getAtomCharges() {
        return this.atomCharges;
    }

    public AmberTypes(@NotNull ForcefieldName ffname, @NotNull Mol2Metadata mol2Metadata, @NotNull AtomIndex atomIndex) {
        Map map;
        Map map2;
        Object v;
        Map.Entry it$iv$iv;
        boolean bl;
        Map map3;
        Object object;
        Atom atom;
        Map map4;
        Map.Entry entry;
        Map<AtomPair, String> $this$mapKeysTo$iv$iv;
        Map<Object, String> $this$mapKeys$iv;
        Intrinsics.checkNotNullParameter((Object)ffname, (String)"ffname");
        Intrinsics.checkNotNullParameter((Object)mol2Metadata, (String)"mol2Metadata");
        Intrinsics.checkNotNullParameter((Object)atomIndex, (String)"atomIndex");
        Map<Atom, String> map5 = mol2Metadata.getAtomTypes();
        ForcefieldName forcefieldName = ffname;
        AmberTypes amberTypes = this;
        boolean $i$f$mapKeys = false;
        void var6_8 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            entry = (Map.Entry)element$iv$iv$iv;
            map4 = destination$iv$iv;
            boolean bl2 = false;
            atom = (Atom)entry.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object = atomIndex.getOrThrow(atom);
            map3 = map4;
            bl = false;
            v = it$iv$iv.getValue();
            map3.put(object, v);
        }
        map4 = destination$iv$iv;
        $this$mapKeys$iv = mol2Metadata.getBondTypes();
        $i$f$mapKeys = false;
        $this$mapKeysTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl3 = false;
            AtomPair bond = (AtomPair)entry.getKey();
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            object = new IntPair(atomIndex.getOrThrow(bond.getA()), atomIndex.getOrThrow(bond.getB()));
            map3 = map2;
            bl = false;
            v = it$iv$iv.getValue();
            map3.put(object, v);
        }
        map2 = destination$iv$iv;
        $this$mapKeys$iv = mol2Metadata.getAtomCharges();
        $i$f$mapKeys = false;
        $this$mapKeysTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl4 = false;
            atom = (Atom)entry.getKey();
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            object = atomIndex.getOrThrow(atom);
            map3 = map;
            bl = false;
            v = it$iv$iv.getValue();
            map3.put(object, v);
        }
        map = destination$iv$iv;
        amberTypes(forcefieldName, map4, map2, map);
    }

    @NotNull
    public final Mol2Metadata toMol2Metadata(@NotNull Molecule mol, @NotNull AtomIndex atomIndex) {
        String type;
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        Intrinsics.checkNotNullParameter((Object)atomIndex, (String)"atomIndex");
        Mol2Metadata metadata = new Mol2Metadata();
        for (Map.Entry<Integer, String> entry : this.atomTypes.entrySet()) {
            int atomi = ((Number)entry.getKey()).intValue();
            type = entry.getValue();
            metadata.getAtomTypes().put(atomIndex.getOrThrow(atomi), type);
        }
        for (Map.Entry<Object, String> entry : this.bondTypes.entrySet()) {
            IntPair bond = (IntPair)entry.getKey();
            type = entry.getValue();
            metadata.getBondTypes().put(new AtomPair(atomIndex.getOrThrow(bond.getI1()), atomIndex.getOrThrow(bond.getI2())), type);
        }
        for (Map.Entry<Object, String> entry : this.atomCharges.entrySet()) {
            int atomi = ((Number)entry.getKey()).intValue();
            String charge = entry.getValue();
            metadata.getAtomCharges().put(atomIndex.getOrThrow(atomi), charge);
        }
        if (mol instanceof Polymer) {
            for (Polymer.Chain chain : ((Polymer)mol).getChains()) {
                for (Polymer.Residue res : chain.getResidues()) {
                    metadata.getDictionaryTypes().put(res, Mol2Metadata.Companion.getDefaultPolymerDictionaryType());
                }
            }
        }
        return metadata;
    }

    @NotNull
    public final ForcefieldName component1() {
        return this.ffname;
    }

    @NotNull
    public final Map<Integer, String> component2() {
        return this.atomTypes;
    }

    @NotNull
    public final Map<IntPair, String> component3() {
        return this.bondTypes;
    }

    @NotNull
    public final Map<Integer, String> component4() {
        return this.atomCharges;
    }

    @NotNull
    public final AmberTypes copy(@NotNull ForcefieldName ffname, @NotNull Map<Integer, String> atomTypes, @NotNull Map<IntPair, String> bondTypes, @NotNull Map<Integer, String> atomCharges) {
        Intrinsics.checkNotNullParameter((Object)ffname, (String)"ffname");
        Intrinsics.checkNotNullParameter(atomTypes, (String)"atomTypes");
        Intrinsics.checkNotNullParameter(bondTypes, (String)"bondTypes");
        Intrinsics.checkNotNullParameter(atomCharges, (String)"atomCharges");
        return new AmberTypes(ffname, atomTypes, bondTypes, atomCharges);
    }

    public static /* synthetic */ AmberTypes copy$default(AmberTypes amberTypes, ForcefieldName forcefieldName, Map map, Map map2, Map map3, int n, Object object) {
        if ((n & 1) != 0) {
            forcefieldName = amberTypes.ffname;
        }
        if ((n & 2) != 0) {
            map = amberTypes.atomTypes;
        }
        if ((n & 4) != 0) {
            map2 = amberTypes.bondTypes;
        }
        if ((n & 8) != 0) {
            map3 = amberTypes.atomCharges;
        }
        return amberTypes.copy(forcefieldName, map, map2, map3);
    }

    @NotNull
    public String toString() {
        return "AmberTypes(ffname=" + this.ffname + ", atomTypes=" + this.atomTypes + ", bondTypes=" + this.bondTypes + ", atomCharges=" + this.atomCharges + ")";
    }

    public int hashCode() {
        int result = this.ffname.hashCode();
        result = result * 31 + ((Object)this.atomTypes).hashCode();
        result = result * 31 + ((Object)this.bondTypes).hashCode();
        result = result * 31 + ((Object)this.atomCharges).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AmberTypes)) {
            return false;
        }
        AmberTypes amberTypes = (AmberTypes)other;
        if (!Intrinsics.areEqual((Object)this.ffname, (Object)amberTypes.ffname)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.atomTypes, amberTypes.atomTypes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.bondTypes, amberTypes.bondTypes)) {
            return false;
        }
        return Intrinsics.areEqual(this.atomCharges, amberTypes.atomCharges);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\r"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTypes$Companion;", "", "()V", "combine", "Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTypes;", "types1", "preferredAtomIndices1", "", "", "ignoredAtomIndices1", "types2", "preferredAtomIndices2", "ignoredAtomIndices2", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nparams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 params.kt\nedu/duke/cs/osprey/gui/forcefield/amber/AmberTypes$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n766#2:311\n857#2,2:312\n766#2:314\n857#2,2:315\n*S KotlinDebug\n*F\n+ 1 params.kt\nedu/duke/cs/osprey/gui/forcefield/amber/AmberTypes$Companion\n*L\n104#1:311\n104#1:312,2\n107#1:314\n107#1:315,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AmberTypes combine(@NotNull AmberTypes types1, @NotNull Set<Integer> preferredAtomIndices1, @NotNull Set<Integer> ignoredAtomIndices1, @NotNull AmberTypes types2, @NotNull Set<Integer> preferredAtomIndices2, @NotNull Set<Integer> ignoredAtomIndices2) {
            Map map;
            Map ex2;
            Map map2;
            Intrinsics.checkNotNullParameter((Object)types1, (String)"types1");
            Intrinsics.checkNotNullParameter(preferredAtomIndices1, (String)"preferredAtomIndices1");
            Intrinsics.checkNotNullParameter(ignoredAtomIndices1, (String)"ignoredAtomIndices1");
            Intrinsics.checkNotNullParameter((Object)types2, (String)"types2");
            Intrinsics.checkNotNullParameter(preferredAtomIndices2, (String)"preferredAtomIndices2");
            Intrinsics.checkNotNullParameter(ignoredAtomIndices2, (String)"ignoredAtomIndices2");
            if (!Intrinsics.areEqual((Object)types1.getFfname(), (Object)types2.getFfname())) {
                throw new IllegalArgumentException(StringsKt.trimMargin$default((String)("\n\t\t\t\t\t|two Amber types disagree on the forcefield name:\n\t\t\t\t\t|   " + types1.getFfname() + "\n\t\t\t\t\t|   " + types2.getFfname() + "\n\t\t\t\t"), null, (int)1, null));
            }
            ForcefieldName ffname = types1.getFfname();
            try {
                map2 = LangKt.combineMaps$default(types1.getAtomTypes(), preferredAtomIndices1, ignoredAtomIndices1, types2.getAtomTypes(), preferredAtomIndices2, ignoredAtomIndices2, null, 64, null);
            }
            catch (CombineCollisionException ex2) {
                throw new IllegalArgumentException(StringsKt.trimMargin$default((String)("\n\t\t\t\t\t|two Amber types disagree on types for atom " + ex2.getKey() + ":\n\t\t\t\t\t|\t" + ex2.getVal1() + "\n\t\t\t\t\t|\t" + ex2.getVal2() + "\n\t\t\t\t"), null, (int)1, null));
            }
            Map combinedAtomTypes = map2;
            try {
                ex2 = LangKt.combineMaps$default(types1.getBondTypes(), edu.duke.cs.osprey.gui.forcefield.amber.AmberTypes$Companion.combine$preferred(types1.getBondTypes().keySet(), preferredAtomIndices1), edu.duke.cs.osprey.gui.forcefield.amber.AmberTypes$Companion.combine$ignored(types1.getBondTypes().keySet(), ignoredAtomIndices1), types2.getBondTypes(), edu.duke.cs.osprey.gui.forcefield.amber.AmberTypes$Companion.combine$preferred(types2.getBondTypes().keySet(), preferredAtomIndices2), edu.duke.cs.osprey.gui.forcefield.amber.AmberTypes$Companion.combine$ignored(types2.getBondTypes().keySet(), ignoredAtomIndices2), null, 64, null);
            }
            catch (CombineCollisionException ex3) {
                throw new IllegalArgumentException(StringsKt.trimMargin$default((String)("\n\t\t\t\t\t|two Amber types disagree on types for bond " + ex3.getKey() + ":\n\t\t\t\t\t|\t" + ex3.getVal1() + "\n\t\t\t\t\t|\t" + ex3.getVal2() + "\n\t\t\t\t"), null, (int)1, null));
            }
            Map combinedBondTypes = ex2;
            try {
                map = LangKt.combineMaps$default(types1.getAtomCharges(), preferredAtomIndices1, ignoredAtomIndices1, types2.getAtomCharges(), preferredAtomIndices2, ignoredAtomIndices2, null, 64, null);
            }
            catch (CombineCollisionException ex4) {
                throw new IllegalArgumentException(StringsKt.trimMargin$default((String)("\n\t\t\t\t\t|two Amber types disagree on charges for atom " + ex4.getKey() + ":\n\t\t\t\t\t|\t" + ex4.getVal1() + "\n\t\t\t\t\t|\t" + ex4.getVal2() + "\n\t\t\t\t"), null, (int)1, null));
            }
            Map combinedAtomCharges = map;
            return new AmberTypes(ffname, combinedAtomTypes, combinedBondTypes, combinedAtomCharges);
        }

        /*
         * WARNING - void declaration
         */
        private static final Set<IntPair> combine$preferred(Set<IntPair> $this$combine_u24preferred, Set<Integer> preferredAtomIndices) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$combine_u24preferred;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IntPair intPair = (IntPair)element$iv$iv;
                boolean bl = false;
                int i1 = intPair.component1();
                int i2 = intPair.component2();
                if (!(preferredAtomIndices.contains(i1) && preferredAtomIndices.contains(i2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        private static final Set<IntPair> combine$ignored(Set<IntPair> $this$combine_u24ignored, Set<Integer> ignoredAtomIndices) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$combine_u24ignored;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IntPair intPair = (IntPair)element$iv$iv;
                boolean bl = false;
                int i1 = intPair.component1();
                int i2 = intPair.component2();
                if (!(ignoredAtomIndices.contains(i1) || ignoredAtomIndices.contains(i2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

