/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield.amber;

import edu.duke.cs.osprey.gui.forcefield.amber.MolPartitioningKt;
import edu.duke.cs.osprey.gui.forcefield.amber.MoleculeType;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.AtomMap;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00030\u00170\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\"\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000e\"\u0004\b\u001d\u0010\u0013\u00a8\u0006\""}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/MinimizerInfo;", "", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "restrainedAtoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ljava/util/List;)V", "atomMap", "Ledu/duke/cs/osprey/molscope/molecule/AtomMap;", "getAtomMap", "()Ledu/duke/cs/osprey/molscope/molecule/AtomMap;", "minimizableAtoms", "getMinimizableAtoms", "()Ljava/util/List;", "minimizedCoords", "Lorg/joml/Vector3d;", "getMinimizedCoords", "setMinimizedCoords", "(Ljava/util/List;)V", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "partition", "Lkotlin/Pair;", "Ledu/duke/cs/osprey/gui/forcefield/amber/MoleculeType;", "getPartition", "getRestrainedAtoms", "unminimizedCoords", "getUnminimizedCoords", "setUnminimizedCoords", "captureCoords", "", "setCoords", "coords", "osprey3"})
@SourceDebugExtension(value={"SMAP\nminimization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 minimization.kt\nedu/duke/cs/osprey/gui/forcefield/amber/MinimizerInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n766#2:167\n857#2,2:168\n1360#2:170\n1446#2,2:171\n1549#2:173\n1620#2,3:174\n1448#2,3:177\n1549#2:180\n1620#2,3:181\n1864#2,3:184\n*S KotlinDebug\n*F\n+ 1 minimization.kt\nedu/duke/cs/osprey/gui/forcefield/amber/MinimizerInfo\n*L\n40#1:167\n40#1:168,2\n46#1:170\n46#1:171,2\n47#1:173\n47#1:174,3\n46#1:177,3\n54#1:180\n54#1:181,3\n60#1:184,3\n*E\n"})
public final class MinimizerInfo {
    @NotNull
    private final Molecule mol;
    @NotNull
    private final List<Atom> restrainedAtoms;
    @NotNull
    private final List<Pair<MoleculeType, Molecule>> partition;
    @NotNull
    private final AtomMap atomMap;
    @NotNull
    private final List<Atom> minimizableAtoms;
    @Nullable
    private List<? extends Vector3d> unminimizedCoords;
    @Nullable
    private List<? extends Vector3d> minimizedCoords;

    /*
     * WARNING - void declaration
     */
    public MinimizerInfo(@NotNull Molecule mol, @NotNull List<Atom> restrainedAtoms) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Pair pair;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        Intrinsics.checkNotNullParameter(restrainedAtoms, (String)"restrainedAtoms");
        this.mol = mol;
        this.restrainedAtoms = restrainedAtoms;
        Pair<List<Pair<MoleculeType, Molecule>>, AtomMap> pair2 = MolPartitioningKt.partitionAndAtomMap(this.mol, false);
        List partition = (List)pair2.component1();
        AtomMap atomMap2 = (AtomMap)pair2.component2();
        Iterable iterable = partition;
        MinimizerInfo minimizerInfo = this;
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            MoleculeType moltype = (MoleculeType)((Object)pair.component1());
            if (!(moltype != MoleculeType.Solvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        minimizerInfo.partition = (List)destination$iv$iv;
        this.atomMap = atomMap2;
        $this$filter$iv = this.partition;
        minimizerInfo = this;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            Molecule mol2 = (Molecule)pair.component2();
            Iterable $this$map$iv = mol2.getAtoms();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Atom atom = (Atom)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add((Atom)atomMap2.getAOrThrow(it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        minimizerInfo.minimizableAtoms = (List)destination$iv$iv;
    }

    public /* synthetic */ MinimizerInfo(Molecule molecule, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(molecule, list);
    }

    @NotNull
    public final Molecule getMol() {
        return this.mol;
    }

    @NotNull
    public final List<Atom> getRestrainedAtoms() {
        return this.restrainedAtoms;
    }

    @NotNull
    public final List<Pair<MoleculeType, Molecule>> getPartition() {
        return this.partition;
    }

    @NotNull
    public final AtomMap getAtomMap() {
        return this.atomMap;
    }

    @NotNull
    public final List<Atom> getMinimizableAtoms() {
        return this.minimizableAtoms;
    }

    @Nullable
    public final List<Vector3d> getUnminimizedCoords() {
        return this.unminimizedCoords;
    }

    public final void setUnminimizedCoords(@Nullable List<? extends Vector3d> list) {
        this.unminimizedCoords = list;
    }

    /*
     * WARNING - void declaration
     */
    public final void captureCoords() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.minimizableAtoms;
        MinimizerInfo minimizerInfo = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Atom atom = (Atom)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Vector3d((Vector3dc)it.getPos()));
        }
        minimizerInfo.unminimizedCoords = (List)destination$iv$iv;
    }

    @Nullable
    public final List<Vector3d> getMinimizedCoords() {
        return this.minimizedCoords;
    }

    public final void setMinimizedCoords(@Nullable List<? extends Vector3d> list) {
        this.minimizedCoords = list;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCoords(@NotNull List<? extends Vector3d> coords) {
        Intrinsics.checkNotNullParameter(coords, (String)"coords");
        Iterable $this$forEachIndexed$iv = this.minimizableAtoms;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void atom;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Atom atom2 = (Atom)item$iv;
            int i = n;
            boolean bl = false;
            atom.getPos().set((Vector3dc)coords.get(i));
        }
    }
}

