/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield.amber;

import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J?\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u0006\u0010&\u001a\u00020\"J\u0006\u0010'\u001a\u00020\u001aJ\b\u0010(\u001a\u00020\u0012H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/ProtonatedAtom;", "", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "chain", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Chain;", "res", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "heavy", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "light", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/molecule/Polymer$Chain;Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;)V", "getChain", "()Ledu/duke/cs/osprey/molscope/molecule/Polymer$Chain;", "getHeavy", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getLight", "location", "", "getLocation", "()Ljava/lang/String;", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "getRes", "()Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "add", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "included", "remove", "toString", "osprey3"})
@SourceDebugExtension(value={"SMAP\nprotonate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 protonate.kt\nedu/duke/cs/osprey/gui/forcefield/amber/ProtonatedAtom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,431:1\n1747#2,3:432\n1#3:435\n*S KotlinDebug\n*F\n+ 1 protonate.kt\nedu/duke/cs/osprey/gui/forcefield/amber/ProtonatedAtom\n*L\n194#1:432,3\n*E\n"})
public final class ProtonatedAtom {
    @NotNull
    private final Molecule mol;
    @Nullable
    private final Polymer.Chain chain;
    @Nullable
    private final Polymer.Residue res;
    @NotNull
    private final Atom heavy;
    @NotNull
    private final Atom light;

    public ProtonatedAtom(@NotNull Molecule mol, @Nullable Polymer.Chain chain, @Nullable Polymer.Residue res, @NotNull Atom heavy, @NotNull Atom light) {
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        Intrinsics.checkNotNullParameter((Object)heavy, (String)"heavy");
        Intrinsics.checkNotNullParameter((Object)light, (String)"light");
        this.mol = mol;
        this.chain = chain;
        this.res = res;
        this.heavy = heavy;
        this.light = light;
    }

    @NotNull
    public final Molecule getMol() {
        return this.mol;
    }

    @Nullable
    public final Polymer.Chain getChain() {
        return this.chain;
    }

    @Nullable
    public final Polymer.Residue getRes() {
        return this.res;
    }

    @NotNull
    public final Atom getHeavy() {
        return this.heavy;
    }

    @NotNull
    public final Atom getLight() {
        return this.light;
    }

    public final boolean included() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.mol.getAtoms();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Atom it = (Atom)element$iv;
                    boolean bl2 = false;
                    if (!(it == this.light)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void add() {
        if (this.included()) {
            return;
        }
        this.mol.getAtoms().add(this.light);
        Object object = this.res;
        if (object != null && (object = ((Polymer.Residue)object).getAtoms()) != null) {
            object.add(this.light);
        }
        this.mol.getBonds().add(this.heavy, this.light);
    }

    public final void remove() {
        this.mol.getAtoms().remove(this.light);
        Object object = this.res;
        if (object != null && (object = ((Polymer.Residue)object).getAtoms()) != null) {
            object.remove(this.light);
        }
        this.mol.getBonds().remove(this.heavy, this.light);
    }

    @Nullable
    public final String getLocation() {
        return this.res != null && this.chain != null ? this.chain.getId() + this.res.getId() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String toString() {
        String string;
        String string2 = this.getLocation();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String string3 = this.light.getName() + " - " + this.heavy.getName() + " @ " + it;
            if (string3 != null) {
                string = string3;
                return string;
            }
        }
        string = this.light.getName() + " - " + this.heavy.getName();
        return string;
    }

    @NotNull
    public final Molecule component1() {
        return this.mol;
    }

    @Nullable
    public final Polymer.Chain component2() {
        return this.chain;
    }

    @Nullable
    public final Polymer.Residue component3() {
        return this.res;
    }

    @NotNull
    public final Atom component4() {
        return this.heavy;
    }

    @NotNull
    public final Atom component5() {
        return this.light;
    }

    @NotNull
    public final ProtonatedAtom copy(@NotNull Molecule mol, @Nullable Polymer.Chain chain, @Nullable Polymer.Residue res, @NotNull Atom heavy, @NotNull Atom light) {
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        Intrinsics.checkNotNullParameter((Object)heavy, (String)"heavy");
        Intrinsics.checkNotNullParameter((Object)light, (String)"light");
        return new ProtonatedAtom(mol, chain, res, heavy, light);
    }

    public static /* synthetic */ ProtonatedAtom copy$default(ProtonatedAtom protonatedAtom, Molecule molecule, Polymer.Chain chain, Polymer.Residue residue, Atom atom, Atom atom2, int n, Object object) {
        if ((n & 1) != 0) {
            molecule = protonatedAtom.mol;
        }
        if ((n & 2) != 0) {
            chain = protonatedAtom.chain;
        }
        if ((n & 4) != 0) {
            residue = protonatedAtom.res;
        }
        if ((n & 8) != 0) {
            atom = protonatedAtom.heavy;
        }
        if ((n & 0x10) != 0) {
            atom2 = protonatedAtom.light;
        }
        return protonatedAtom.copy(molecule, chain, residue, atom, atom2);
    }

    public int hashCode() {
        int result = this.mol.hashCode();
        result = result * 31 + (this.chain == null ? 0 : this.chain.hashCode());
        result = result * 31 + (this.res == null ? 0 : this.res.hashCode());
        result = result * 31 + this.heavy.hashCode();
        result = result * 31 + this.light.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProtonatedAtom)) {
            return false;
        }
        ProtonatedAtom protonatedAtom = (ProtonatedAtom)other;
        if (!Intrinsics.areEqual((Object)this.mol, (Object)protonatedAtom.mol)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.chain, (Object)protonatedAtom.chain)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.res, (Object)protonatedAtom.res)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.heavy, (Object)protonatedAtom.heavy)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.light, (Object)protonatedAtom.light);
    }
}

